/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf;

import com.baidu.bjf.remoting.protobuf.Codec;
import com.baidu.bjf.remoting.protobuf.utils.FieldUtils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class IDLProxyObject {
    private Codec codec;
    private Object target;
    private Class<?> cls;
    private final Map<String, ReflectInfo> cachedFields = new HashMap<String, ReflectInfo>();
    private boolean cached = true;

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public IDLProxyObject(Codec codec, Object target, Class<?> cls) {
        if (codec == null) {
            throw new IllegalArgumentException("param 'codec' is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("param 'target' is null.");
        }
        if (cls == null) {
            throw new IllegalArgumentException("param 'cls' is null.");
        }
        this.codec = codec;
        this.target = target;
        this.cls = cls;
    }

    public IDLProxyObject newInstnace() {
        try {
            Object object = this.cls.newInstance();
            return new IDLProxyObject(this.codec, object, this.cls);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private IDLProxyObject doSetFieldValue(String fullField, String field, Object value, Object object, boolean useCache, Map<String, ReflectInfo> cachedFields) {
        ReflectInfo info;
        if (useCache && (info = cachedFields.get(fullField)) != null) {
            this.setField(value, info.target, info.field);
            return this;
        }
        int index = field.indexOf(46);
        if (index != -1) {
            String parent = field.substring(0, index);
            String sub = field.substring(index + 1);
            try {
                Field f = FieldUtils.findField(object.getClass(), parent);
                if (f == null) {
                    throw new RuntimeException("No field '" + parent + "' found at class " + object.getClass().getName());
                }
                Class<?> type = f.getType();
                f.setAccessible(true);
                Object o = f.get(object);
                if (o == null) {
                    boolean memberClass = type.isMemberClass();
                    if (memberClass && Modifier.isStatic(type.getModifiers())) {
                        Constructor<?> constructor = type.getConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        o = constructor.newInstance(new Object[0]);
                    } else if (memberClass) {
                        Constructor<?> constructor = type.getConstructor(object.getClass());
                        constructor.setAccessible(true);
                        o = constructor.newInstance(object);
                    } else {
                        o = type.newInstance();
                    }
                    f.set(object, o);
                }
                return this.put(fullField, sub, value, o);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        Field f = FieldUtils.findField(object.getClass(), field);
        if (f == null) {
            throw new RuntimeException("No field '" + field + "' found at class " + object.getClass().getName());
        }
        if (useCache && !cachedFields.containsKey(fullField)) {
            cachedFields.put(fullField, new ReflectInfo(f, object));
        }
        this.setField(value, object, f);
        return this;
    }

    private IDLProxyObject put(String fullField, String field, Object value, Object object) {
        return this.doSetFieldValue(fullField, field, value, object, this.cached, this.cachedFields);
    }

    public IDLProxyObject put(String field, Object value) {
        return this.put(field, field, value, this.target);
    }

    private void setField(Object value, Object object, Field f) {
        f.setAccessible(true);
        Object valueToSet = value;
        try {
            if (Enum.class.isAssignableFrom(f.getType())) {
                Object v = Enum.valueOf(f.getType(), String.valueOf(value));
                valueToSet = v;
            }
            f.set(object, valueToSet);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Object get(String field) {
        if (this.target == null) {
            return null;
        }
        return this.get(field, field, this.target);
    }

    private Object doGetFieldValue(String fullField, String field, Object object, boolean useCache, Map<String, ReflectInfo> cachedFields) {
        ReflectInfo info;
        if (useCache && (info = cachedFields.get(fullField)) != null) {
            return this.getField(info.target, info.field);
        }
        int index = field.indexOf(46);
        if (index != -1) {
            String parent = field.substring(0, index);
            String sub = field.substring(index + 1);
            try {
                Field f = FieldUtils.findField(object.getClass(), parent);
                if (f == null) {
                    throw new RuntimeException("No field '" + parent + "' found at class " + object.getClass().getName());
                }
                f.setAccessible(true);
                Object o = f.get(object);
                if (o == null) {
                    return null;
                }
                return this.get(fullField, sub, o);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        Field f = FieldUtils.findField(object.getClass(), field);
        if (f == null) {
            throw new RuntimeException("No field '" + field + "' found at class " + object.getClass().getName());
        }
        if (useCache && !cachedFields.containsKey(fullField)) {
            cachedFields.put(fullField, new ReflectInfo(f, object));
        }
        return this.getField(object, f);
    }

    private Object get(String fullField, String field, Object object) {
        return this.doGetFieldValue(fullField, field, object, this.cached, this.cachedFields);
    }

    private Object getField(Object object, Field f) {
        f.setAccessible(true);
        try {
            return f.get(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public byte[] encode() throws IOException {
        return this.codec.encode(this.target);
    }

    public IDLProxyObject decode(byte[] bb) throws IOException {
        if (bb == null) {
            throw new IllegalArgumentException("param 'bb' is null");
        }
        Object object = this.codec.decode(bb);
        return new IDLProxyObject(this.codec, object, this.cls);
    }

    public void clearFieldCache() {
        this.cachedFields.clear();
    }

    public Object getTarget() {
        return this.target;
    }

    private static class ReflectInfo {
        private Field field;
        private Object target;

        public ReflectInfo(Field field, Object target) {
            this.field = field;
            this.target = target;
        }
    }
}

