/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.code;

import com.baidu.bjf.remoting.protobuf.Codec;
import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;

public class CodecOutputByteArray {
    private static final ThreadLocal<Stack<CodecOutputByteArray>> instanceGetter = ThreadLocal.withInitial(Stack::new);
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final CodedOutputStream stream = CodedOutputStream.newInstance((OutputStream)this.byteArrayOutputStream, (int)0);
    private static final int MAX_ELEMENT = 10;

    private CodecOutputByteArray() {
    }

    public static CodecOutputByteArray get() {
        Stack<CodecOutputByteArray> stack = instanceGetter.get();
        if (stack.size() > 0) {
            return stack.pop();
        }
        return new CodecOutputByteArray();
    }

    public static int threadScopeSize() {
        return instanceGetter.get().size();
    }

    public static void clear() {
        instanceGetter.get().clear();
    }

    public CodedOutputStream getCodedOutputStream() {
        return this.stream;
    }

    public byte[] getData() throws IOException {
        this.stream.flush();
        byte[] bytes = this.byteArrayOutputStream.toByteArray();
        this.recycle();
        return bytes;
    }

    public static <T> byte[] getData(Codec<T> codec, T obj) throws IOException {
        CodecOutputByteArray data = CodecOutputByteArray.get();
        codec.writeTo(obj, data.stream);
        return data.getData();
    }

    private void recycle() {
        this.byteArrayOutputStream.reset();
        Stack<CodecOutputByteArray> stack = instanceGetter.get();
        if (stack.size() >= 10) {
            return;
        }
        stack.push(this);
    }
}

