/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.command;

import com.baidu.bjf.remoting.protobuf.ProtobufIDLProxy;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import java.io.File;
import java.io.IOException;

public class Main {
    private static final String JAVA_OUT_ARG = "--java_out=";

    public static void main(String[] args) {
        File currentPath = new File(".");
        if (args == null || args.length < 1) {
            Main.help();
            System.exit(-1);
        }
        File javaOutPath = null;
        File protoPath = null;
        if (args.length > 1) {
            if (args[0].startsWith(JAVA_OUT_ARG)) {
                javaOutPath = new File(StringUtils.removeStart(args[0], JAVA_OUT_ARG));
            }
            protoPath = new File(args[1]);
        } else {
            javaOutPath = currentPath;
            protoPath = new File(args[0]);
        }
        if (!protoPath.exists()) {
            System.out.println("proto file not found at " + protoPath.getAbsolutePath());
            System.exit(-1);
        }
        ProtobufIDLProxy.setFormatJavaField(true);
        try {
            ProtobufIDLProxy.generateSource(protoPath, javaOutPath);
            System.out.println("create success. output path=" + javaOutPath.getAbsolutePath());
        }
        catch (IOException e) {
            System.out.println("create failed: " + e.getMessage());
        }
        System.exit(0);
    }

    private static void help() {
        System.out.println(" Usage: java -jar  jprotobuf-jar-with-dependencies.jar  --java_out=.  test.proto");
    }
}

