/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.utils.compiler;

import com.baidu.bjf.remoting.protobuf.utils.ClassHelper;
import com.baidu.bjf.remoting.protobuf.utils.OS;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import com.baidu.bjf.remoting.protobuf.utils.ZipUtils;
import com.baidu.bjf.remoting.protobuf.utils.compiler.AbstractCompiler;
import com.baidu.bjf.remoting.protobuf.utils.compiler.ClassUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkCompiler
extends AbstractCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JdkCompiler.class.getName());
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final ClassLoaderImpl classLoader;
    private final JavaFileManagerImpl javaFileManager;
    private volatile List<String> options = new ArrayList<String>();
    private static final String DEFAULT_JDK_VERSION = "1.8";
    private static final String BOOT_INF_CLASSES = "BOOT-INF/classes/";
    private static final String TEMP_PATH = System.getProperty("java.io.tmpdir") + File.separator + "JPROTOBUF_CACHE_DIR";

    public JdkCompiler(ClassLoader loader) {
        this(loader, DEFAULT_JDK_VERSION);
    }

    public JdkCompiler(final ClassLoader loader, String jdkVersion) {
        this.options.add("-source");
        this.options.add(jdkVersion);
        this.options.add("-target");
        this.options.add(jdkVersion);
        if (this.compiler == null) {
            throw new RuntimeException("compiler is null maybe you are on JRE enviroment please change to JDK environment.");
        }
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        StandardJavaFileManager manager = this.compiler.getStandardFileManager(diagnosticCollector, null, Charset.forName("utf-8"));
        if (loader instanceof URLClassLoader && !loader.getClass().getName().equals("sun.misc.Launcher$AppClassLoader")) {
            try {
                boolean isJava21 = "21".equals(System.getProperty("java.specification.version"));
                URLClassLoader urlClassLoader = (URLClassLoader)loader;
                ArrayList<File> files = new ArrayList<File>();
                boolean isInternalJar = false;
                String rootJar = null;
                HashSet<String> fileNames = new HashSet<String>();
                for (URL url : urlClassLoader.getURLs()) {
                    String file = url.getFile();
                    files.add(new File(file));
                    if (StringUtils.endsWith(file, "!/")) {
                        file = StringUtils.removeEnd(file, "!/");
                    }
                    if (file.startsWith("file:")) {
                        file = StringUtils.removeStart(file, "file:");
                    }
                    if (isJava21 && file.startsWith("nested:")) {
                        file = StringUtils.removeStart(file, "nested:");
                    }
                    if (file.indexOf("!") != -1) {
                        isInternalJar = true;
                        rootJar = StringUtils.substringBefore(file, "!");
                        if (OS.isFamilyWindows() || OS.isFamilyWin9x()) {
                            rootJar = StringUtils.removeStart(rootJar, "/");
                        }
                    }
                    File f = new File(file);
                    fileNames.add(f.getName());
                    files.add(f);
                }
                if (isInternalJar && rootJar != null) {
                    ZipUtils.unZip(new File(rootJar), TEMP_PATH);
                    JdkCompiler.listFiles(TEMP_PATH, files, fileNames);
                    files.add(new File(TEMP_PATH, BOOT_INF_CLASSES));
                }
                manager.setLocation(StandardLocation.CLASS_PATH, files);
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        this.classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoaderImpl>(){

            @Override
            public ClassLoaderImpl run() {
                return new ClassLoaderImpl(loader);
            }
        });
        this.javaFileManager = new JavaFileManagerImpl(manager, this.classLoader);
    }

    @Override
    public synchronized Class<?> doCompile(String name, String sourceCode, OutputStream os) throws Throwable {
        byte[] bytes;
        int i;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Begin to compile source code: class is '{}'", (Object)name);
        }
        String packageName = (i = name.lastIndexOf(46)) < 0 ? "" : name.substring(0, i);
        String className = i < 0 ? name : name.substring(i + 1);
        JavaFileObjectImpl javaFileObject = new JavaFileObjectImpl(className, sourceCode);
        this.javaFileManager.putFileForInput(StandardLocation.SOURCE_PATH, packageName, className + ".java", javaFileObject);
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        Boolean result = this.compiler.getTask(null, this.javaFileManager, diagnosticCollector, this.options, null, Arrays.asList(javaFileObject)).call();
        if (result == null || !result.booleanValue()) {
            throw new IllegalStateException("Compilation failed. class: " + name + ", diagnostics: " + diagnosticCollector.getDiagnostics());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("compile source code done: class is '{}'", (Object)name);
            LOGGER.debug("loading class '{}'", (Object)name);
        }
        Class<?> retClass = this.classLoader.loadClass(name);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("loading class done  '{}'", (Object)name);
        }
        if (os != null && (bytes = this.classLoader.loadClassBytes(name)) != null) {
            os.write(bytes);
            os.flush();
        }
        return retClass;
    }

    @Override
    public byte[] loadBytes(String className) {
        byte[] bytes = this.classLoader.loadClassBytes(className);
        return bytes;
    }

    private static void listFiles(String classesPath, List<File> list, final Set<String> filters) {
        Collection listFiles = FileUtils.listFiles((File)new File(classesPath), (IOFileFilter)new IOFileFilter(){

            public boolean accept(File dir, String name) {
                return filters.contains(name);
            }

            public boolean accept(File file) {
                return filters.contains(file.getName());
            }
        }, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File dir, String name) {
                return true;
            }

            public boolean accept(File file) {
                return true;
            }
        });
        if (listFiles != null) {
            for (Object f : listFiles) {
                try {
                    File file = (File)f;
                    list.add(file);
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage());
                }
            }
        }
    }

    private final class ClassLoaderImpl
    extends ClassLoader {
        private final Map<String, JavaFileObject> classes;

        ClassLoaderImpl(ClassLoader parentClassLoader) {
            super(parentClassLoader);
            this.classes = new HashMap<String, JavaFileObject>();
        }

        Collection<JavaFileObject> files() {
            return Collections.unmodifiableCollection(this.classes.values());
        }

        public byte[] loadClassBytes(String qualifiedClassName) {
            JavaFileObject file = this.classes.get(qualifiedClassName);
            if (file != null) {
                byte[] bytes = ((JavaFileObjectImpl)file).getByteCode();
                return bytes;
            }
            return null;
        }

        @Override
        protected Class<?> findClass(String qualifiedClassName) throws ClassNotFoundException {
            JavaFileObject file = this.classes.get(qualifiedClassName);
            if (file != null) {
                byte[] bytes = ((JavaFileObjectImpl)file).getByteCode();
                return this.defineClass(qualifiedClassName, bytes, 0, bytes.length);
            }
            try {
                return ClassHelper.forNameWithCallerClassLoader(qualifiedClassName, this.getClass());
            }
            catch (ClassNotFoundException nf) {
                return super.findClass(qualifiedClassName);
            }
        }

        void add(String qualifiedClassName, JavaFileObject javaFile) {
            this.classes.put(qualifiedClassName, javaFile);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            String qualifiedClassName;
            JavaFileObjectImpl file;
            if (name.endsWith(".class") && (file = (JavaFileObjectImpl)this.classes.get(qualifiedClassName = name.substring(0, name.length() - ".class".length()).replace('/', '.'))) != null) {
                return new ByteArrayInputStream(file.getByteCode());
            }
            return super.getResourceAsStream(name);
        }
    }

    private static final class JavaFileManagerImpl
    extends ForwardingJavaFileManager<JavaFileManager> {
        private final ClassLoaderImpl classLoader;
        private final Map<URI, JavaFileObject> fileObjects = new HashMap<URI, JavaFileObject>();

        public JavaFileManagerImpl(JavaFileManager fileManager, ClassLoaderImpl classLoader) {
            super(fileManager);
            this.classLoader = classLoader;
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
            FileObject o = this.fileObjects.get(this.uri(location, packageName, relativeName));
            if (o != null) {
                return o;
            }
            return super.getFileForInput(location, packageName, relativeName);
        }

        public void putFileForInput(StandardLocation location, String packageName, String relativeName, JavaFileObject file) {
            this.fileObjects.put(this.uri(location, packageName, relativeName), file);
        }

        private URI uri(JavaFileManager.Location location, String packageName, String relativeName) {
            return ClassUtils.toURI(location.getName() + '/' + packageName + '/' + relativeName);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String qualifiedName, JavaFileObject.Kind kind, FileObject outputFile) throws IOException {
            JavaFileObjectImpl file = new JavaFileObjectImpl(qualifiedName, kind);
            this.classLoader.add(qualifiedName, file);
            return file;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this.classLoader;
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location loc, JavaFileObject file) {
            if (file instanceof JavaFileObjectImpl) {
                return file.getName();
            }
            return super.inferBinaryName(loc, file);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            Iterable<JavaFileObject> result = super.list(location, packageName, kinds, recurse);
            ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
            if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
                for (JavaFileObject file : this.fileObjects.values()) {
                    if (file.getKind() != JavaFileObject.Kind.CLASS || !file.getName().startsWith(packageName)) continue;
                    files.add(file);
                }
                files.addAll(this.classLoader.files());
            } else if (location == StandardLocation.SOURCE_PATH && kinds.contains((Object)JavaFileObject.Kind.SOURCE)) {
                for (JavaFileObject file : this.fileObjects.values()) {
                    if (file.getKind() != JavaFileObject.Kind.SOURCE || !file.getName().startsWith(packageName)) continue;
                    files.add(file);
                }
            }
            for (JavaFileObject file : result) {
                files.add(file);
            }
            return files;
        }
    }

    private static final class JavaFileObjectImpl
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream bytecode;
        private final CharSequence source;

        public JavaFileObjectImpl(String baseName, CharSequence source) {
            super(ClassUtils.toURI(baseName + ".java"), JavaFileObject.Kind.SOURCE);
            this.source = source;
        }

        JavaFileObjectImpl(String name, JavaFileObject.Kind kind) {
            super(ClassUtils.toURI(name), kind);
            this.source = null;
        }

        public JavaFileObjectImpl(URI uri, JavaFileObject.Kind kind) {
            super(uri, kind);
            this.source = null;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws UnsupportedOperationException {
            if (this.source == null) {
                throw new UnsupportedOperationException("source == null");
            }
            return this.source;
        }

        @Override
        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.getByteCode());
        }

        @Override
        public OutputStream openOutputStream() {
            this.bytecode = new ByteArrayOutputStream();
            return this.bytecode;
        }

        public byte[] getByteCode() {
            if (this.bytecode == null) {
                return null;
            }
            return this.bytecode.toByteArray();
        }
    }
}

