/*
 * Decompiled with CFR 0.152.
 */
package com.staros.client;

import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.staros.client.StarClientException;
import com.staros.exception.StarException;
import com.staros.manager.StarManagerServer;
import com.staros.proto.AddFileStoreRequest;
import com.staros.proto.AddFileStoreResponse;
import com.staros.proto.AddWorkerRequest;
import com.staros.proto.AddWorkerResponse;
import com.staros.proto.AllocateFilePathRequest;
import com.staros.proto.AllocateFilePathResponse;
import com.staros.proto.BootstrapServiceRequest;
import com.staros.proto.BootstrapServiceResponse;
import com.staros.proto.CreateMetaGroupInfo;
import com.staros.proto.CreateMetaGroupRequest;
import com.staros.proto.CreateMetaGroupResponse;
import com.staros.proto.CreateShardGroupInfo;
import com.staros.proto.CreateShardGroupRequest;
import com.staros.proto.CreateShardGroupResponse;
import com.staros.proto.CreateShardInfo;
import com.staros.proto.CreateShardRequest;
import com.staros.proto.CreateShardResponse;
import com.staros.proto.CreateWorkerGroupRequest;
import com.staros.proto.CreateWorkerGroupResponse;
import com.staros.proto.DeleteMetaGroupInfo;
import com.staros.proto.DeleteMetaGroupRequest;
import com.staros.proto.DeleteShardGroupInfo;
import com.staros.proto.DeleteShardGroupRequest;
import com.staros.proto.DeleteShardRequest;
import com.staros.proto.DeleteWorkerGroupRequest;
import com.staros.proto.DeregisterServiceRequest;
import com.staros.proto.DumpRequest;
import com.staros.proto.DumpResponse;
import com.staros.proto.FilePathInfo;
import com.staros.proto.FileStoreInfo;
import com.staros.proto.FileStoreType;
import com.staros.proto.GetFileStoreRequest;
import com.staros.proto.GetFileStoreResponse;
import com.staros.proto.GetMetaGroupRequest;
import com.staros.proto.GetMetaGroupResponse;
import com.staros.proto.GetServiceRequest;
import com.staros.proto.GetServiceResponse;
import com.staros.proto.GetShardGroupRequest;
import com.staros.proto.GetShardGroupResponse;
import com.staros.proto.GetShardRequest;
import com.staros.proto.GetShardResponse;
import com.staros.proto.GetWorkerRequest;
import com.staros.proto.GetWorkerResponse;
import com.staros.proto.LeaderInfo;
import com.staros.proto.ListFileStoreRequest;
import com.staros.proto.ListFileStoreResponse;
import com.staros.proto.ListMetaGroupRequest;
import com.staros.proto.ListMetaGroupResponse;
import com.staros.proto.ListShardGroupRequest;
import com.staros.proto.ListShardGroupResponse;
import com.staros.proto.ListShardRequest;
import com.staros.proto.ListShardResponse;
import com.staros.proto.ListWorkerGroupRequest;
import com.staros.proto.ListWorkerGroupResponse;
import com.staros.proto.MetaGroupInfo;
import com.staros.proto.QueryMetaGroupStableRequest;
import com.staros.proto.QueryMetaGroupStableResponse;
import com.staros.proto.RegisterServiceRequest;
import com.staros.proto.RemoveFileStoreRequest;
import com.staros.proto.RemoveWorkerRequest;
import com.staros.proto.ServiceInfo;
import com.staros.proto.ServiceTemplateInfo;
import com.staros.proto.ShardGroupInfo;
import com.staros.proto.ShardInfo;
import com.staros.proto.ShardInfoList;
import com.staros.proto.ShutdownServiceRequest;
import com.staros.proto.StarManagerGrpc;
import com.staros.proto.StarStatus;
import com.staros.proto.StatusCode;
import com.staros.proto.UpdateFileStoreRequest;
import com.staros.proto.UpdateMetaGroupInfo;
import com.staros.proto.UpdateMetaGroupRequest;
import com.staros.proto.UpdateWorkerGroupRequest;
import com.staros.proto.UpdateWorkerGroupResponse;
import com.staros.proto.WorkerGroupDetailInfo;
import com.staros.proto.WorkerGroupSpec;
import com.staros.proto.WorkerInfo;
import com.staros.util.LockCloseable;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.tuple.Pair;

public class StarClient {
    public static final long DEFAULT_ID = 0L;
    public static final int GRPC_CHANNEL_MAX_MESSAGE_SIZE = 0x4000000;
    private String defaultServerAddress;
    private ManagedChannel channel = null;
    private StarManagerGrpc.StarManagerBlockingStub blockingStub;
    private final StarManagerServer server;
    private final ReentrantLock leaderLock = new ReentrantLock();
    private String leaderAddress;
    private ManagedChannel leaderChannel = null;
    private StarManagerGrpc.StarManagerBlockingStub leaderStub;
    public static final FileStoreType FS_NOT_SET = FileStoreType.INVALID;

    public StarClient() {
        this(null);
    }

    public StarClient(StarManagerServer server) {
        this.server = server;
    }

    public void connectServer(String serverIpPort) {
        this.defaultServerAddress = serverIpPort;
        this.channel = ManagedChannelBuilder.forTarget((String)this.defaultServerAddress).maxInboundMessageSize(0x4000000).usePlaintext().build();
        this.blockingStub = StarManagerGrpc.newBlockingStub((Channel)this.channel);
    }

    public void stop() {
        StarClient.stopChannel(this.channel);
        StarClient.stopChannel(this.leaderChannel);
    }

    private static void stopChannel(ManagedChannel ch) {
        if (ch == null) {
            return;
        }
        ch.shutdownNow();
        try {
            ch.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void registerService(String serviceTemplateName) throws StarClientException {
        ServiceTemplateInfo serviceTemplate = ServiceTemplateInfo.newBuilder().setServiceTemplateName(serviceTemplateName).build();
        RegisterServiceRequest request = RegisterServiceRequest.newBuilder().setServiceTemplateInfo(serviceTemplate).build();
        this.internalRpcCall(x -> x.registerService(request), false);
    }

    public void deregisterService(String serviceTemplateName) throws StarClientException {
        DeregisterServiceRequest request = DeregisterServiceRequest.newBuilder().setServiceTemplateName(serviceTemplateName).build();
        this.internalRpcCall(x -> x.deregisterService(request), false);
    }

    public String bootstrapService(String serviceTemplateName, String serviceName) throws StarClientException {
        BootstrapServiceRequest request = BootstrapServiceRequest.newBuilder().setServiceTemplateName(serviceTemplateName).setServiceName(serviceName).build();
        BootstrapServiceResponse response = this.internalRpcCall(x -> x.bootstrapService(request), false);
        return response.getServiceId();
    }

    public void shutdownService(String serviceId) throws StarClientException {
        ShutdownServiceRequest request = ShutdownServiceRequest.newBuilder().setServiceId(serviceId).build();
        this.internalRpcCall(x -> x.shutdownService(request), false);
    }

    public ServiceInfo getServiceInfoById(String serviceId) throws StarClientException {
        GetServiceRequest request = GetServiceRequest.newBuilder().setServiceId(serviceId).build();
        GetServiceResponse response = this.internalRpcCall(x -> x.getService(request), false);
        return response.getServiceInfo();
    }

    public ServiceInfo getServiceInfoByName(String serviceName) throws StarClientException {
        GetServiceRequest request = GetServiceRequest.newBuilder().setServiceName(serviceName).build();
        GetServiceResponse response = this.internalRpcCall(x -> x.getService(request), false);
        return response.getServiceInfo();
    }

    public WorkerGroupDetailInfo createWorkerGroup(String serviceId, String owner, WorkerGroupSpec spec, Map<String, String> labels, Map<String, String> properties) throws StarClientException {
        CreateWorkerGroupRequest request = CreateWorkerGroupRequest.newBuilder().setServiceId(serviceId).setOwner(owner).setSpec(spec).putAllLabels(labels).putAllProperties(properties).build();
        CreateWorkerGroupResponse response = this.internalRpcCall(x -> x.createWorkerGroup(request), false);
        return response.getGroupInfo();
    }

    public List<WorkerGroupDetailInfo> listWorkerGroup(String serviceId, List<Long> groupIds, boolean includeWorkersInfo) throws StarClientException {
        return this.listWorkerGroupInternal(serviceId, groupIds, Collections.emptyMap(), includeWorkersInfo);
    }

    public List<WorkerGroupDetailInfo> listWorkerGroup(String serviceId, Map<String, String> filterLabels) throws StarClientException {
        return this.listWorkerGroupInternal(serviceId, Collections.emptyList(), filterLabels, false);
    }

    private List<WorkerGroupDetailInfo> listWorkerGroupInternal(String serviceId, List<Long> groupIds, Map<String, String> filterLabels, boolean includeWorkersInfo) throws StarClientException {
        if (this.server == null) {
            return this.listWorkerGroupInternalRPC(serviceId, groupIds, filterLabels, includeWorkersInfo);
        }
        return this.listWorkerGroupInternalIPC(serviceId, groupIds, filterLabels, includeWorkersInfo);
    }

    private List<WorkerGroupDetailInfo> listWorkerGroupInternalRPC(String serviceId, List<Long> groupIds, Map<String, String> filterLabels, boolean includeWorkersInfo) throws StarClientException {
        ListWorkerGroupRequest request = ListWorkerGroupRequest.newBuilder().setServiceId(serviceId).addAllGroupIds(groupIds).setIncludeWorkersInfo(includeWorkersInfo).putAllFilterLabels(filterLabels).build();
        ListWorkerGroupResponse response = this.internalRpcCall(x -> x.listWorkerGroup(request), false);
        return response.getGroupsInfoList();
    }

    private List<WorkerGroupDetailInfo> listWorkerGroupInternalIPC(String serviceId, List<Long> groupIds, Map<String, String> filterLabels, boolean includeWorkersInfo) throws StarClientException {
        try {
            return this.internalIpcCall(() -> this.server.getStarManager().listWorkerGroups(serviceId, groupIds, filterLabels, includeWorkersInfo));
        }
        catch (StarClientException exception) {
            if (exception.getCode() == StatusCode.NOT_LEADER && this.leaderStub != null) {
                return this.listWorkerGroupInternalRPC(serviceId, groupIds, filterLabels, includeWorkersInfo);
            }
            throw exception;
        }
    }

    public WorkerGroupDetailInfo updateWorkerGroup(String serviceId, long groupId, Map<String, String> labels, Map<String, String> properties) throws StarClientException {
        UpdateWorkerGroupRequest.Builder reqBuilder = UpdateWorkerGroupRequest.newBuilder();
        reqBuilder.setGroupId(groupId).setServiceId(serviceId);
        if (labels != null && !labels.isEmpty()) {
            reqBuilder.putAllLabels(labels);
        }
        if (properties != null && !properties.isEmpty()) {
            reqBuilder.putAllProperties(properties);
        }
        UpdateWorkerGroupResponse response = this.internalRpcCall(x -> x.updateWorkerGroup(reqBuilder.build()), false);
        return response.getGroupInfo();
    }

    public WorkerGroupDetailInfo alterWorkerGroupSpec(String serviceId, long groupId, WorkerGroupSpec spec) throws StarClientException {
        UpdateWorkerGroupRequest request = UpdateWorkerGroupRequest.newBuilder().setServiceId(serviceId).setSpec(spec).setGroupId(groupId).build();
        UpdateWorkerGroupResponse response = this.internalRpcCall(x -> x.updateWorkerGroup(request), false);
        return response.getGroupInfo();
    }

    public void deleteWorkerGroup(String serviceId, long groupId) throws StarClientException {
        DeleteWorkerGroupRequest request = DeleteWorkerGroupRequest.newBuilder().setServiceId(serviceId).setGroupId(groupId).build();
        this.internalRpcCall(x -> x.deleteWorkerGroup(request), false);
    }

    public long addWorker(String serviceId, String workerIpPort) throws StarClientException {
        return this.addWorker(serviceId, workerIpPort, 0L);
    }

    public long addWorker(String serviceId, String workerIpPort, long workerGroupId) throws StarClientException {
        AddWorkerRequest request = AddWorkerRequest.newBuilder().setServiceId(serviceId).setIpPort(workerIpPort).setGroupId(workerGroupId).build();
        AddWorkerResponse response = this.internalRpcCall(x -> x.addWorker(request), false);
        return response.getWorkerId();
    }

    public void removeWorker(String serviceId, long workerId) throws StarClientException {
        this.removeWorker(serviceId, workerId, 0L);
    }

    public void removeWorker(String serviceId, long workerId, long workerGroupId) throws StarClientException {
        RemoveWorkerRequest request = RemoveWorkerRequest.newBuilder().setServiceId(serviceId).setWorkerId(workerId).setGroupId(workerGroupId).build();
        this.internalRpcCall(x -> x.removeWorker(request), false);
    }

    public WorkerInfo getWorkerInfo(String serviceId, long workerId) throws StarClientException {
        GetWorkerRequest request = GetWorkerRequest.newBuilder().setServiceId(serviceId).setWorkerId(workerId).build();
        GetWorkerResponse response = this.internalRpcCall(x -> x.getWorker(request), false);
        return response.getWorkerInfo();
    }

    public WorkerInfo getWorkerInfo(String serviceId, String ipPort) throws StarClientException {
        GetWorkerRequest request = GetWorkerRequest.newBuilder().setServiceId(serviceId).setIpPort(ipPort).build();
        GetWorkerResponse response = this.internalRpcCall(x -> x.getWorker(request), false);
        return response.getWorkerInfo();
    }

    public List<ShardInfo> createShard(String serviceId, List<CreateShardInfo> createShardInfos) throws StarClientException {
        if (createShardInfos.isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "shard info can not be empty.");
        }
        CreateShardRequest request = CreateShardRequest.newBuilder().setServiceId(serviceId).addAllCreateShardInfos(createShardInfos).build();
        CreateShardResponse response = this.internalRpcCall(x -> x.createShard(request), false);
        return response.getShardInfoList();
    }

    public void deleteShard(String serviceId, Set<Long> shardIds) throws StarClientException {
        if (shardIds.isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "shard id can not be empty.");
        }
        ArrayList<Long> shardIdsFinal = new ArrayList<Long>(shardIds);
        DeleteShardRequest request = DeleteShardRequest.newBuilder().setServiceId(serviceId).addAllShardId(shardIdsFinal).build();
        this.internalRpcCall(x -> x.deleteShard(request), false);
    }

    public List<ShardInfo> getShardInfo(String serviceId, List<Long> shardIds) throws StarClientException {
        return this.getShardInfo(serviceId, shardIds, 0L);
    }

    public List<ShardInfo> getShardInfo(String serviceId, List<Long> shardIds, long workerGroupId) throws StarClientException {
        if (shardIds.isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "shard id can not be empty.");
        }
        if (this.server == null) {
            return this.getShardInfoInternalRPC(serviceId, shardIds, workerGroupId, false);
        }
        return this.getShardInfoInternalIPC(serviceId, shardIds, workerGroupId);
    }

    private List<ShardInfo> getShardInfoInternalRPC(String serviceId, List<Long> shardIds, long workerGroupId, boolean useLeader) throws StarClientException {
        GetShardRequest request = GetShardRequest.newBuilder().setServiceId(serviceId).addAllShardId(shardIds).setWorkerGroupId(workerGroupId).build();
        GetShardResponse response = this.internalRpcCall(x -> x.getShard(request), useLeader);
        return response.getShardInfoList();
    }

    private List<ShardInfo> getShardInfoInternalIPC(String serviceId, List<Long> shardIds, long workerGroupId) throws StarClientException {
        try {
            return this.internalIpcCall(() -> this.server.getStarManager().getShardInfo(serviceId, shardIds, workerGroupId));
        }
        catch (StarClientException exception) {
            if (exception.getCode() == StatusCode.NOT_LEADER && this.leaderStub != null) {
                return this.getShardInfoInternalRPC(serviceId, shardIds, workerGroupId, true);
            }
            throw exception;
        }
    }

    public List<List<ShardInfo>> listShard(String serviceId, List<Long> groupIds) throws StarClientException {
        return this.listShard(serviceId, groupIds, 0L, false);
    }

    public List<List<ShardInfo>> listShard(String serviceId, List<Long> groupIds, long workerGroupId, boolean withoutReplicaInfo) throws StarClientException {
        if (groupIds.isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "group id can not be empty.");
        }
        ListShardRequest request = ListShardRequest.newBuilder().setServiceId(serviceId).addAllGroupIds(groupIds).setWorkerGroupId(workerGroupId).setWithoutReplicaInfo(withoutReplicaInfo).build();
        ListShardResponse response = this.internalRpcCall(x -> x.listShard(request), false);
        List shardInfoLists = response.getShardInfoListsList();
        ArrayList<List<ShardInfo>> shardInfos = new ArrayList<List<ShardInfo>>(shardInfoLists.size());
        for (ShardInfoList shardInfoList : shardInfoLists) {
            shardInfos.add(shardInfoList.getShardInfosList());
        }
        return shardInfos;
    }

    public List<ShardGroupInfo> createShardGroup(String serviceId, List<CreateShardGroupInfo> createShardGroupInfos) throws StarClientException {
        if (createShardGroupInfos.isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "shard group info can not be empty.");
        }
        CreateShardGroupRequest request = CreateShardGroupRequest.newBuilder().setServiceId(serviceId).addAllCreateShardGroupInfos(createShardGroupInfos).build();
        CreateShardGroupResponse response = this.internalRpcCall(x -> x.createShardGroup(request), false);
        return response.getShardGroupInfosList();
    }

    public void deleteShardGroup(String serviceId, List<Long> groupIds, boolean deleteShards) throws StarClientException {
        if (groupIds.isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "shard group id can not be empty.");
        }
        DeleteShardGroupRequest request = DeleteShardGroupRequest.newBuilder().setServiceId(serviceId).setDeleteInfo(DeleteShardGroupInfo.newBuilder().addAllGroupIds(groupIds).setCascadeDeleteShard(deleteShards).build()).build();
        this.internalRpcCall(x -> x.deleteShardGroup(request), false);
    }

    public Pair<List<ShardGroupInfo>, Long> listShardGroup(String serviceId, long startGroupId) throws StarClientException {
        ListShardGroupRequest request = ListShardGroupRequest.newBuilder().setServiceId(serviceId).setIncludeAnonymousGroup(false).setStartGroupId(startGroupId).build();
        ListShardGroupResponse response = this.internalRpcCall(x -> x.listShardGroup(request), false);
        return Pair.of((Object)response.getShardGroupInfosList(), (Object)response.getNextGroupId());
    }

    public List<ShardGroupInfo> listShardGroup(String serviceId) throws StarClientException {
        Pair<List<ShardGroupInfo>, Long> pair;
        long startGroupId = 0L;
        ArrayList<ShardGroupInfo> shardGroupInfos = new ArrayList<ShardGroupInfo>();
        do {
            pair = this.listShardGroup(serviceId, startGroupId);
            shardGroupInfos.addAll((Collection)pair.getKey());
        } while ((startGroupId = ((Long)pair.getValue()).longValue()) != 0L);
        return shardGroupInfos;
    }

    public List<ShardGroupInfo> getShardGroup(String serviceId, List<Long> groupIds) throws StarClientException {
        if (groupIds.isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "group id can not be empty.");
        }
        GetShardGroupRequest request = GetShardGroupRequest.newBuilder().setServiceId(serviceId).addAllShardGroupId(groupIds).build();
        GetShardGroupResponse response = this.internalRpcCall(x -> x.getShardGroup(request), false);
        return response.getShardGroupInfoList();
    }

    public MetaGroupInfo createMetaGroup(String serviceId, CreateMetaGroupInfo info) throws StarClientException {
        CreateMetaGroupRequest request = CreateMetaGroupRequest.newBuilder().setServiceId(serviceId).setCreateMetaGroupInfo(info).build();
        CreateMetaGroupResponse response = this.internalRpcCall(x -> x.createMetaGroup(request), false);
        return response.getMetaGroupInfo();
    }

    public void deleteMetaGroup(String serviceId, DeleteMetaGroupInfo info) throws StarClientException {
        DeleteMetaGroupRequest request = DeleteMetaGroupRequest.newBuilder().setServiceId(serviceId).setDeleteMetaGroupInfo(info).build();
        this.internalRpcCall(x -> x.deleteMetaGroup(request), false);
    }

    public void updateMetaGroup(String serviceId, UpdateMetaGroupInfo info) throws StarClientException {
        UpdateMetaGroupRequest request = UpdateMetaGroupRequest.newBuilder().setServiceId(serviceId).setUpdateMetaGroupInfo(info).build();
        this.internalRpcCall(x -> x.updateMetaGroup(request), false);
    }

    public MetaGroupInfo getMetaGroupInfo(String serviceId, long metaGroupId) throws StarClientException {
        GetMetaGroupRequest request = GetMetaGroupRequest.newBuilder().setServiceId(serviceId).setMetaGroupId(metaGroupId).build();
        GetMetaGroupResponse response = this.internalRpcCall(x -> x.getMetaGroup(request), false);
        return response.getMetaGroupInfo();
    }

    public List<MetaGroupInfo> listMetaGroup(String serviceId) throws StarClientException {
        ListMetaGroupRequest request = ListMetaGroupRequest.newBuilder().setServiceId(serviceId).build();
        ListMetaGroupResponse response = this.internalRpcCall(x -> x.listMetaGroup(request), false);
        return response.getMetaGroupInfosList();
    }

    public boolean queryMetaGroupStable(String serviceId, long metaGroupId) throws StarClientException {
        return this.queryMetaGroupStable(serviceId, metaGroupId, 0L);
    }

    public boolean queryMetaGroupStable(String serviceId, long metaGroupId, long workerGroupId) throws StarClientException {
        QueryMetaGroupStableRequest.Builder reqBuilder = QueryMetaGroupStableRequest.newBuilder().setServiceId(serviceId).setMetaGroupId(metaGroupId);
        if (workerGroupId != 0L) {
            reqBuilder.setWorkerGroupId(workerGroupId);
        }
        QueryMetaGroupStableResponse response = this.internalRpcCall(x -> x.queryMetaGroupStable(reqBuilder.build()), false);
        return response.getIsStable();
    }

    public FilePathInfo allocateFilePath(String serviceId, FileStoreType fsType, String suffix) throws StarClientException {
        return this.allocateFilePath(serviceId, fsType, suffix, "");
    }

    public FilePathInfo allocateFilePath(String serviceId, String fsKey, String suffix) throws StarClientException {
        return this.allocateFilePath(serviceId, FS_NOT_SET, suffix, fsKey);
    }

    private FilePathInfo allocateFilePath(String serviceId, FileStoreType fsType, String suffix, String fsKey) throws StarClientException {
        AllocateFilePathRequest request = AllocateFilePathRequest.newBuilder().setServiceId(serviceId).setSuffix(suffix).setFsType(fsType).setFsKey(fsKey).build();
        AllocateFilePathResponse response = this.internalRpcCall(x -> x.allocateFilePath(request), false);
        return response.getPathInfo();
    }

    public String addFileStore(FileStoreInfo info, String serviceId) throws StarClientException {
        if (info.getFsName().isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "Fs name can not be empty");
        }
        AddFileStoreRequest request = AddFileStoreRequest.newBuilder().setFsInfo(info).setServiceId(serviceId).build();
        AddFileStoreResponse response = this.internalRpcCall(x -> x.addFileStore(request), false);
        return response.getFsKey();
    }

    public void removeFileStore(String fsKey, String serviceId) throws StarClientException {
        this.removeFileStoreInternal(fsKey, "", serviceId);
    }

    public void removeFileStoreByName(String fsName, String serviceId) throws StarClientException {
        this.removeFileStoreInternal("", fsName, serviceId);
    }

    private void removeFileStoreInternal(String fsKey, String fsName, String serviceId) throws StarClientException {
        RemoveFileStoreRequest request = RemoveFileStoreRequest.newBuilder().setFsName(fsName).setFsKey(fsKey).setServiceId(serviceId).build();
        this.internalRpcCall(x -> x.removeFileStore(request), false);
    }

    public void updateFileStore(FileStoreInfo info, String serviceId) throws StarClientException {
        UpdateFileStoreRequest request = UpdateFileStoreRequest.newBuilder().setFsInfo(info).setServiceId(serviceId).build();
        this.internalRpcCall(x -> x.updateFileStore(request), false);
    }

    public List<FileStoreInfo> listFileStore(String serviceId) throws StarClientException {
        return this.listFileStore(serviceId, FS_NOT_SET);
    }

    public List<FileStoreInfo> listFileStore(String serviceId, FileStoreType fsType) throws StarClientException {
        ListFileStoreRequest request = ListFileStoreRequest.newBuilder().setServiceId(serviceId).setFsType(fsType).build();
        ListFileStoreResponse response = this.internalRpcCall(x -> x.listFileStore(request), false);
        return response.getFsInfosList();
    }

    public FileStoreInfo getFileStore(String fsKey, String serviceId) throws StarClientException {
        return this.getFileStoreInternal("", fsKey, serviceId);
    }

    public FileStoreInfo getFileStoreByName(String fsName, String serviceId) throws StarClientException {
        return this.getFileStoreInternal(fsName, "", serviceId);
    }

    private FileStoreInfo getFileStoreInternal(String fsName, String fsKey, String serviceId) throws StarClientException {
        GetFileStoreRequest request = GetFileStoreRequest.newBuilder().setServiceId(serviceId).setFsName(fsName).setFsKey(fsKey).build();
        GetFileStoreResponse response = this.internalRpcCall(x -> x.getFileStore(request), false);
        return response.getFsInfo();
    }

    public String dump() throws StarClientException {
        DumpRequest request = DumpRequest.newBuilder().build();
        DumpResponse response = this.internalRpcCall(x -> x.dump(request), false);
        return response.getLocation();
    }

    private <V extends Message> V internalRpcCall(RpcCallable<V> callable, boolean useLeader) throws StarClientException {
        Message result;
        try {
            result = (Message)callable.call(useLeader && this.leaderStub != null ? this.leaderStub : this.blockingStub);
        }
        catch (Exception exception) {
            throw new StarClientException(StatusCode.GRPC, exception.getMessage());
        }
        try {
            this.handleStatusError(result);
            return (V)result;
        }
        catch (StarClientException exception) {
            if (!useLeader && exception.getCode() == StatusCode.NOT_LEADER) {
                byte[] extraInfo = exception.getExtraInfo();
                if (extraInfo != null && extraInfo.length > 0) {
                    this.updateLeaderInfo(extraInfo);
                }
                if (this.leaderStub != null) {
                    return this.internalRpcCall(callable, true);
                }
            }
            throw exception;
        }
    }

    private <V> V internalIpcCall(IpcCallable<V> callable) throws StarClientException {
        try {
            return callable.call();
        }
        catch (StarException exception) {
            byte[] extraInfo;
            StarClientException clientException = new StarClientException(exception.toStatus());
            if (clientException.getCode() == StatusCode.NOT_LEADER && (extraInfo = clientException.getExtraInfo()) != null && extraInfo.length > 0) {
                this.updateLeaderInfo(extraInfo);
            }
            throw clientException;
        }
    }

    private void updateLeaderInfo(byte[] info) {
        LeaderInfo leader;
        try {
            leader = LeaderInfo.parseFrom((byte[])info);
        }
        catch (InvalidProtocolBufferException exception) {
            return;
        }
        String newLeader = String.format("%s:%d", leader.getHost(), leader.getPort());
        try (LockCloseable ignored = new LockCloseable((Lock)this.leaderLock);){
            if (!newLeader.equals(this.leaderAddress)) {
                ManagedChannel oldChannel = this.leaderChannel;
                this.leaderAddress = newLeader;
                this.leaderChannel = ManagedChannelBuilder.forTarget((String)this.leaderAddress).maxInboundMessageSize(0x4000000).usePlaintext().build();
                this.leaderStub = StarManagerGrpc.newBlockingStub((Channel)this.leaderChannel);
                new Thread(() -> StarClient.stopChannel(oldChannel)).start();
            }
        }
    }

    private static StarStatus extractStatusFromProtobufMessage(Message msg) {
        Descriptors.FieldDescriptor descriptor = msg.getDescriptorForType().findFieldByName("status");
        if (descriptor == null) {
            return null;
        }
        Object status = msg.getField(descriptor);
        if (!(status instanceof StarStatus)) {
            return null;
        }
        return (StarStatus)status;
    }

    private void handleStatusError(Message msg) throws StarClientException {
        StarStatus status = StarClient.extractStatusFromProtobufMessage(msg);
        if (status == null) {
            return;
        }
        if (status.getStatusCode() == StatusCode.OK) {
            return;
        }
        throw new StarClientException(status);
    }

    protected static interface IpcCallable<V> {
        public V call() throws StarException;
    }

    protected static interface RpcCallable<V> {
        public V call(StarManagerGrpc.StarManagerBlockingStub var1) throws StarClientException;
    }
}

