/*
 * Decompiled with CFR 0.152.
 */
package com.staros.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.staros.client.StarClientException;
import com.staros.exception.StarException;
import com.staros.manager.StarManagerServer;
import com.staros.proto.AddFileStoreRequest;
import com.staros.proto.AddFileStoreResponse;
import com.staros.proto.AddWorkerRequest;
import com.staros.proto.AddWorkerResponse;
import com.staros.proto.AllocateFilePathRequest;
import com.staros.proto.AllocateFilePathResponse;
import com.staros.proto.BootstrapServiceRequest;
import com.staros.proto.BootstrapServiceResponse;
import com.staros.proto.CreateMetaGroupInfo;
import com.staros.proto.CreateMetaGroupRequest;
import com.staros.proto.CreateMetaGroupResponse;
import com.staros.proto.CreateShardGroupInfo;
import com.staros.proto.CreateShardGroupRequest;
import com.staros.proto.CreateShardGroupResponse;
import com.staros.proto.CreateShardInfo;
import com.staros.proto.CreateShardRequest;
import com.staros.proto.CreateShardResponse;
import com.staros.proto.CreateWorkerGroupRequest;
import com.staros.proto.CreateWorkerGroupResponse;
import com.staros.proto.DeleteMetaGroupInfo;
import com.staros.proto.DeleteMetaGroupRequest;
import com.staros.proto.DeleteShardGroupInfo;
import com.staros.proto.DeleteShardGroupRequest;
import com.staros.proto.DeleteShardRequest;
import com.staros.proto.DeleteWorkerGroupRequest;
import com.staros.proto.DeregisterServiceRequest;
import com.staros.proto.DumpRequest;
import com.staros.proto.DumpResponse;
import com.staros.proto.FilePathInfo;
import com.staros.proto.FileStoreInfo;
import com.staros.proto.FileStoreType;
import com.staros.proto.GetFileStoreRequest;
import com.staros.proto.GetFileStoreResponse;
import com.staros.proto.GetMetaGroupRequest;
import com.staros.proto.GetMetaGroupResponse;
import com.staros.proto.GetServiceRequest;
import com.staros.proto.GetServiceResponse;
import com.staros.proto.GetShardGroupRequest;
import com.staros.proto.GetShardGroupResponse;
import com.staros.proto.GetShardRequest;
import com.staros.proto.GetShardResponse;
import com.staros.proto.GetWorkerRequest;
import com.staros.proto.GetWorkerResponse;
import com.staros.proto.LeaderInfo;
import com.staros.proto.ListFileStoreRequest;
import com.staros.proto.ListFileStoreResponse;
import com.staros.proto.ListMetaGroupRequest;
import com.staros.proto.ListMetaGroupResponse;
import com.staros.proto.ListShardGroupRequest;
import com.staros.proto.ListShardGroupResponse;
import com.staros.proto.ListShardRequest;
import com.staros.proto.ListShardResponse;
import com.staros.proto.ListWorkerGroupRequest;
import com.staros.proto.ListWorkerGroupResponse;
import com.staros.proto.MetaGroupInfo;
import com.staros.proto.QueryMetaGroupStableRequest;
import com.staros.proto.QueryMetaGroupStableResponse;
import com.staros.proto.RegisterServiceRequest;
import com.staros.proto.RemoveFileStoreRequest;
import com.staros.proto.RemoveWorkerRequest;
import com.staros.proto.ReplicationType;
import com.staros.proto.S3FileStoreInfo;
import com.staros.proto.ServiceInfo;
import com.staros.proto.ServiceTemplateInfo;
import com.staros.proto.ShardGroupInfo;
import com.staros.proto.ShardInfo;
import com.staros.proto.ShardInfoList;
import com.staros.proto.ShutdownServiceRequest;
import com.staros.proto.StarManagerGrpc;
import com.staros.proto.StarStatus;
import com.staros.proto.StatusCode;
import com.staros.proto.UpdateFileStoreRequest;
import com.staros.proto.UpdateMetaGroupInfo;
import com.staros.proto.UpdateMetaGroupRequest;
import com.staros.proto.UpdateShardGroupInfo;
import com.staros.proto.UpdateShardGroupRequest;
import com.staros.proto.UpdateShardInfo;
import com.staros.proto.UpdateShardRequest;
import com.staros.proto.UpdateWorkerGroupRequest;
import com.staros.proto.UpdateWorkerGroupResponse;
import com.staros.proto.WarmupLevel;
import com.staros.proto.WorkerGroupDetailInfo;
import com.staros.proto.WorkerGroupSpec;
import com.staros.proto.WorkerInfo;
import com.staros.util.LockCloseable;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StarClient {
    private static final Logger LOG = LogManager.getLogger(StarClient.class);
    public static final long DEFAULT_ID = 0L;
    public static final int GRPC_CHANNEL_MAX_MESSAGE_SIZE = 0x4000000;
    private String defaultServerAddress = null;
    private ManagedChannel readChannel = null;
    private ManagedChannel writeChannel = null;
    private StarManagerGrpc.StarManagerBlockingStub readStub;
    private StarManagerGrpc.StarManagerBlockingStub writeStub;
    private final StarManagerServer server;
    private final ReentrantLock leaderLock = new ReentrantLock();
    private String leaderAddress = null;
    private ManagedChannel leaderReadChannel = null;
    private StarManagerGrpc.StarManagerBlockingStub leaderReadStub;
    private ManagedChannel leaderWriteChannel = null;
    private StarManagerGrpc.StarManagerBlockingStub leaderWriteStub;
    private int clientReadTimeoutSec = 15;
    private int clientListTimeoutSec = 30;
    private int clientWriteTimeoutSec = 30;
    private double clientReadMaxRetryCount = 0.0;
    public static final FileStoreType FS_NOT_SET = FileStoreType.INVALID;

    public StarClient() {
        this(null);
    }

    public StarClient(StarManagerServer server) {
        this.server = server;
    }

    public synchronized void resetStub(String address, boolean readOnly, boolean isLeader) {
        ManagedChannel oldReadChannel = null;
        ManagedChannel oldWriteChannel = null;
        ManagedChannelBuilder readBuilder = ManagedChannelBuilder.forTarget((String)address).maxInboundMessageSize(0x4000000).usePlaintext();
        if (this.clientReadMaxRetryCount > 1.0) {
            ImmutableMap retryPolicy = ImmutableMap.builder().put((Object)"maxAttempts", (Object)this.clientReadMaxRetryCount).put((Object)"initialBackoff", (Object)"1s").put((Object)"maxBackoff", (Object)"5s").put((Object)"backoffMultiplier", (Object)1.5).put((Object)"retryableStatusCodes", (Object)ImmutableList.of((Object)"UNAVAILABLE")).build();
            ImmutableMap methodConfig = ImmutableMap.of((Object)"name", (Object)ImmutableList.of((Object)ImmutableMap.of()), (Object)"retryPolicy", (Object)retryPolicy);
            ImmutableMap serviceConfig = ImmutableMap.of((Object)"methodConfig", (Object)ImmutableList.of((Object)methodConfig));
            readBuilder.defaultServiceConfig((Map)serviceConfig).maxRetryAttempts((int)this.clientReadMaxRetryCount).enableRetry();
        }
        if (!isLeader) {
            oldReadChannel = this.readChannel;
            this.readChannel = readBuilder.build();
            this.readStub = StarManagerGrpc.newBlockingStub((Channel)this.readChannel);
        } else {
            oldReadChannel = this.leaderReadChannel;
            this.leaderReadChannel = readBuilder.build();
            this.leaderReadStub = StarManagerGrpc.newBlockingStub((Channel)this.leaderReadChannel);
        }
        ManagedChannel oldReadChannelCopy = oldReadChannel;
        if (readOnly) {
            new Thread(() -> StarClient.stopChannel(oldReadChannelCopy)).start();
            return;
        }
        if (!isLeader) {
            oldWriteChannel = this.writeChannel;
            this.writeChannel = ManagedChannelBuilder.forTarget((String)address).maxInboundMessageSize(0x4000000).usePlaintext().build();
            this.writeStub = StarManagerGrpc.newBlockingStub((Channel)this.writeChannel);
        } else {
            oldWriteChannel = this.leaderWriteChannel;
            this.leaderWriteChannel = ManagedChannelBuilder.forTarget((String)address).maxInboundMessageSize(0x4000000).usePlaintext().build();
            this.leaderWriteStub = StarManagerGrpc.newBlockingStub((Channel)this.leaderWriteChannel);
        }
        ManagedChannel oldWriteChannelCopy = oldWriteChannel;
        new Thread(() -> {
            StarClient.stopChannel(oldReadChannelCopy);
            StarClient.stopChannel(oldWriteChannelCopy);
        }).start();
    }

    public void connectServer(String serverIpPort) {
        this.defaultServerAddress = serverIpPort;
        this.resetStub(this.defaultServerAddress, false, false);
    }

    public void stop() {
        StarClient.stopChannel(this.readChannel);
        StarClient.stopChannel(this.writeChannel);
        StarClient.stopChannel(this.leaderReadChannel);
        StarClient.stopChannel(this.leaderWriteChannel);
    }

    private static void stopChannel(ManagedChannel ch) {
        if (ch == null) {
            return;
        }
        ch.shutdownNow();
        try {
            ch.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void registerService(String serviceTemplateName) throws StarClientException {
        ServiceTemplateInfo serviceTemplate = ServiceTemplateInfo.newBuilder().setServiceTemplateName(serviceTemplateName).build();
        RegisterServiceRequest request = RegisterServiceRequest.newBuilder().setServiceTemplateInfo(serviceTemplate).build();
        this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).registerService(request));
    }

    public void deregisterService(String serviceTemplateName) throws StarClientException {
        DeregisterServiceRequest request = DeregisterServiceRequest.newBuilder().setServiceTemplateName(serviceTemplateName).build();
        this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).deregisterService(request));
    }

    public String bootstrapService(String serviceTemplateName, String serviceName) throws StarClientException {
        BootstrapServiceRequest request = BootstrapServiceRequest.newBuilder().setServiceTemplateName(serviceTemplateName).setServiceName(serviceName).build();
        BootstrapServiceResponse response = this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).bootstrapService(request));
        return response.getServiceId();
    }

    public void shutdownService(String serviceId) throws StarClientException {
        ShutdownServiceRequest request = ShutdownServiceRequest.newBuilder().setServiceId(serviceId).build();
        this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).shutdownService(request));
    }

    public ServiceInfo getServiceInfoById(String serviceId) throws StarClientException {
        GetServiceRequest request = GetServiceRequest.newBuilder().setServiceId(serviceId).build();
        GetServiceResponse response = this.internalReadRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientReadTimeoutSec, TimeUnit.SECONDS)).getService(request));
        return response.getServiceInfo();
    }

    public ServiceInfo getServiceInfoByName(String serviceName) throws StarClientException {
        GetServiceRequest request = GetServiceRequest.newBuilder().setServiceName(serviceName).build();
        GetServiceResponse response = this.internalReadRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientReadTimeoutSec, TimeUnit.SECONDS)).getService(request));
        return response.getServiceInfo();
    }

    public WorkerGroupDetailInfo createWorkerGroup(String serviceId, String owner, WorkerGroupSpec spec, Map<String, String> labels, Map<String, String> properties) throws StarClientException {
        CreateWorkerGroupRequest request = CreateWorkerGroupRequest.newBuilder().setServiceId(serviceId).setOwner(owner).setSpec(spec).putAllLabels(labels).putAllProperties(properties).build();
        CreateWorkerGroupResponse response = this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).createWorkerGroup(request));
        return response.getGroupInfo();
    }

    public WorkerGroupDetailInfo createWorkerGroup(String serviceId, String owner, WorkerGroupSpec spec, Map<String, String> labels, Map<String, String> properties, int replicaNumber, ReplicationType replicationType) throws StarClientException {
        return this.createWorkerGroup(serviceId, owner, spec, labels, properties, replicaNumber, replicationType, WarmupLevel.WARMUP_NOT_SET);
    }

    public WorkerGroupDetailInfo createWorkerGroup(String serviceId, String owner, WorkerGroupSpec spec, Map<String, String> labels, Map<String, String> properties, int replicaNumber, ReplicationType replicationType, WarmupLevel warmupLevel) throws StarClientException {
        CreateWorkerGroupRequest request = CreateWorkerGroupRequest.newBuilder().setServiceId(serviceId).setOwner(owner).setSpec(spec).putAllLabels(labels).putAllProperties(properties).setReplicaNumber(replicaNumber).setReplicationType(replicationType).setWarmupLevel(warmupLevel).build();
        CreateWorkerGroupResponse response = this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).createWorkerGroup(request));
        return response.getGroupInfo();
    }

    public List<WorkerGroupDetailInfo> listWorkerGroup(String serviceId, List<Long> groupIds, boolean includeWorkersInfo) throws StarClientException {
        return this.listWorkerGroupInternal(serviceId, groupIds, Collections.emptyMap(), includeWorkersInfo);
    }

    public List<WorkerGroupDetailInfo> listWorkerGroup(String serviceId, Map<String, String> filterLabels) throws StarClientException {
        return this.listWorkerGroupInternal(serviceId, Collections.emptyList(), filterLabels, false);
    }

    private List<WorkerGroupDetailInfo> listWorkerGroupInternal(String serviceId, List<Long> groupIds, Map<String, String> filterLabels, boolean includeWorkersInfo) throws StarClientException {
        if (this.server == null) {
            return this.listWorkerGroupInternalRPC(serviceId, groupIds, filterLabels, includeWorkersInfo);
        }
        return this.listWorkerGroupInternalIPC(serviceId, groupIds, filterLabels, includeWorkersInfo);
    }

    private List<WorkerGroupDetailInfo> listWorkerGroupInternalRPC(String serviceId, List<Long> groupIds, Map<String, String> filterLabels, boolean includeWorkersInfo) throws StarClientException {
        ListWorkerGroupRequest request = ListWorkerGroupRequest.newBuilder().setServiceId(serviceId).addAllGroupIds(groupIds).setIncludeWorkersInfo(includeWorkersInfo).putAllFilterLabels(filterLabels).build();
        ListWorkerGroupResponse response = this.internalReadRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientListTimeoutSec, TimeUnit.SECONDS)).listWorkerGroup(request));
        return response.getGroupsInfoList();
    }

    private List<WorkerGroupDetailInfo> listWorkerGroupInternalIPC(String serviceId, List<Long> groupIds, Map<String, String> filterLabels, boolean includeWorkersInfo) throws StarClientException {
        try {
            return this.internalIpcCall(() -> this.server.getStarManager().listWorkerGroups(serviceId, groupIds, filterLabels, includeWorkersInfo));
        }
        catch (StarClientException exception) {
            if (exception.getCode() == StatusCode.NOT_LEADER && this.leaderReadStub != null) {
                return this.listWorkerGroupInternalRPC(serviceId, groupIds, filterLabels, includeWorkersInfo);
            }
            throw exception;
        }
    }

    public WorkerGroupDetailInfo updateWorkerGroup(String serviceId, long groupId, Map<String, String> labels, Map<String, String> properties, int replicaNumber, ReplicationType replicationType) throws StarClientException {
        return this.updateWorkerGroup(serviceId, groupId, labels, properties, replicaNumber, replicationType, WarmupLevel.WARMUP_NOT_SET);
    }

    public WorkerGroupDetailInfo updateWorkerGroup(String serviceId, long groupId, Map<String, String> labels, Map<String, String> properties, int replicaNumber, ReplicationType replicationType, WarmupLevel warmupLevel) throws StarClientException {
        UpdateWorkerGroupRequest.Builder reqBuilder = UpdateWorkerGroupRequest.newBuilder();
        reqBuilder.setGroupId(groupId).setServiceId(serviceId);
        if (labels != null && !labels.isEmpty()) {
            reqBuilder.putAllLabels(labels);
        }
        if (properties != null && !properties.isEmpty()) {
            reqBuilder.putAllProperties(properties);
        }
        if (replicaNumber > 0) {
            reqBuilder.setReplicaNumber(replicaNumber);
        }
        if (replicationType != ReplicationType.NO_SET) {
            reqBuilder.setReplicationType(replicationType);
        }
        if (warmupLevel != WarmupLevel.WARMUP_NOT_SET) {
            reqBuilder.setWarmupLevel(warmupLevel);
        }
        UpdateWorkerGroupResponse response = this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).updateWorkerGroup(reqBuilder.build()));
        return response.getGroupInfo();
    }

    public WorkerGroupDetailInfo alterWorkerGroupSpec(String serviceId, long groupId, WorkerGroupSpec spec) throws StarClientException {
        UpdateWorkerGroupRequest request = UpdateWorkerGroupRequest.newBuilder().setServiceId(serviceId).setSpec(spec).setGroupId(groupId).build();
        UpdateWorkerGroupResponse response = this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).updateWorkerGroup(request));
        return response.getGroupInfo();
    }

    public void deleteWorkerGroup(String serviceId, long groupId) throws StarClientException {
        DeleteWorkerGroupRequest request = DeleteWorkerGroupRequest.newBuilder().setServiceId(serviceId).setGroupId(groupId).build();
        this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).deleteWorkerGroup(request));
    }

    public long addWorker(String serviceId, String workerIpPort) throws StarClientException {
        return this.addWorker(serviceId, workerIpPort, 0L);
    }

    public long addWorker(String serviceId, String workerIpPort, long workerGroupId) throws StarClientException {
        AddWorkerRequest request = AddWorkerRequest.newBuilder().setServiceId(serviceId).setIpPort(workerIpPort).setGroupId(workerGroupId).build();
        AddWorkerResponse response = this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).addWorker(request));
        return response.getWorkerId();
    }

    public void removeWorker(String serviceId, long workerId) throws StarClientException {
        this.removeWorker(serviceId, workerId, 0L);
    }

    public void removeWorker(String serviceId, long workerId, long workerGroupId) throws StarClientException {
        RemoveWorkerRequest request = RemoveWorkerRequest.newBuilder().setServiceId(serviceId).setWorkerId(workerId).setGroupId(workerGroupId).build();
        this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).removeWorker(request));
    }

    public WorkerInfo getWorkerInfo(String serviceId, long workerId) throws StarClientException {
        GetWorkerRequest request = GetWorkerRequest.newBuilder().setServiceId(serviceId).setWorkerId(workerId).build();
        GetWorkerResponse response = this.internalReadRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientReadTimeoutSec, TimeUnit.SECONDS)).getWorker(request));
        return response.getWorkerInfo();
    }

    public WorkerInfo getWorkerInfo(String serviceId, String ipPort) throws StarClientException {
        GetWorkerRequest request = GetWorkerRequest.newBuilder().setServiceId(serviceId).setIpPort(ipPort).build();
        GetWorkerResponse response = this.internalReadRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientReadTimeoutSec, TimeUnit.SECONDS)).getWorker(request));
        return response.getWorkerInfo();
    }

    public List<ShardInfo> createShard(String serviceId, List<CreateShardInfo> createShardInfos) throws StarClientException {
        if (createShardInfos.isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "shard info can not be empty.");
        }
        CreateShardRequest request = CreateShardRequest.newBuilder().setServiceId(serviceId).addAllCreateShardInfos(createShardInfos).build();
        CreateShardResponse response = this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).createShard(request));
        return response.getShardInfoList();
    }

    public void updateShard(String serviceId, List<UpdateShardInfo> updateShardInfos) throws StarClientException {
        UpdateShardRequest request = UpdateShardRequest.newBuilder().setServiceId(serviceId).addAllUpdateShardInfos(updateShardInfos).build();
        this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).updateShard(request));
    }

    public void deleteShard(String serviceId, Set<Long> shardIds) throws StarClientException {
        if (shardIds.isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "shard id can not be empty.");
        }
        ArrayList<Long> shardIdsFinal = new ArrayList<Long>(shardIds);
        DeleteShardRequest request = DeleteShardRequest.newBuilder().setServiceId(serviceId).addAllShardId(shardIdsFinal).build();
        this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).deleteShard(request));
    }

    public List<ShardInfo> getShardInfo(String serviceId, List<Long> shardIds) throws StarClientException {
        return this.getShardInfo(serviceId, shardIds, 0L);
    }

    public List<ShardInfo> getShardInfo(String serviceId, List<Long> shardIds, long workerGroupId) throws StarClientException {
        if (shardIds.isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "shard id can not be empty.");
        }
        if (this.server == null) {
            return this.getShardInfoInternalRPC(serviceId, shardIds, workerGroupId, false);
        }
        return this.getShardInfoInternalIPC(serviceId, shardIds, workerGroupId);
    }

    private List<ShardInfo> getShardInfoInternalRPC(String serviceId, List<Long> shardIds, long workerGroupId, boolean useLeader) throws StarClientException {
        GetShardRequest request = GetShardRequest.newBuilder().setServiceId(serviceId).addAllShardId(shardIds).setWorkerGroupId(workerGroupId).build();
        GetShardResponse response = this.internalReadRpcCallWithLeader(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientReadTimeoutSec, TimeUnit.SECONDS)).getShard(request), useLeader);
        return response.getShardInfoList();
    }

    private List<ShardInfo> getShardInfoInternalIPC(String serviceId, List<Long> shardIds, long workerGroupId) throws StarClientException {
        try {
            return this.internalIpcCall(() -> this.server.getStarManager().getShardInfo(serviceId, shardIds, workerGroupId));
        }
        catch (StarClientException exception) {
            if (exception.getCode() == StatusCode.NOT_LEADER && this.leaderReadStub != null) {
                return this.getShardInfoInternalRPC(serviceId, shardIds, workerGroupId, true);
            }
            throw exception;
        }
    }

    public List<List<ShardInfo>> listShard(String serviceId, List<Long> groupIds) throws StarClientException {
        return this.listShard(serviceId, groupIds, 0L, false);
    }

    public List<List<ShardInfo>> listShard(String serviceId, List<Long> groupIds, long workerGroupId, boolean withoutReplicaInfo) throws StarClientException {
        if (groupIds.isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "group id can not be empty.");
        }
        ListShardRequest request = ListShardRequest.newBuilder().setServiceId(serviceId).addAllGroupIds(groupIds).setWorkerGroupId(workerGroupId).setWithoutReplicaInfo(withoutReplicaInfo).build();
        ListShardResponse response = this.internalReadRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientListTimeoutSec, TimeUnit.SECONDS)).listShard(request));
        List shardInfoLists = response.getShardInfoListsList();
        ArrayList<List<ShardInfo>> shardInfos = new ArrayList<List<ShardInfo>>(shardInfoLists.size());
        for (ShardInfoList shardInfoList : shardInfoLists) {
            shardInfos.add(shardInfoList.getShardInfosList());
        }
        return shardInfos;
    }

    public List<ShardGroupInfo> createShardGroup(String serviceId, List<CreateShardGroupInfo> createShardGroupInfos) throws StarClientException {
        if (createShardGroupInfos.isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "shard group info can not be empty.");
        }
        CreateShardGroupRequest request = CreateShardGroupRequest.newBuilder().setServiceId(serviceId).addAllCreateShardGroupInfos(createShardGroupInfos).build();
        CreateShardGroupResponse response = this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).createShardGroup(request));
        return response.getShardGroupInfosList();
    }

    public void deleteShardGroup(String serviceId, List<Long> groupIds, boolean deleteShards) throws StarClientException {
        if (groupIds.isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "shard group id can not be empty.");
        }
        DeleteShardGroupRequest request = DeleteShardGroupRequest.newBuilder().setServiceId(serviceId).setDeleteInfo(DeleteShardGroupInfo.newBuilder().addAllGroupIds(groupIds).setCascadeDeleteShard(deleteShards).build()).build();
        this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).deleteShardGroup(request));
    }

    public void updateShardGroup(String serviceId, List<UpdateShardGroupInfo> updateShardGroupInfos) throws StarClientException {
        UpdateShardGroupRequest request = UpdateShardGroupRequest.newBuilder().setServiceId(serviceId).addAllUpdateShardGroupInfos(updateShardGroupInfos).build();
        this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).updateShardGroup(request));
    }

    public Pair<List<ShardGroupInfo>, Long> listShardGroup(String serviceId, long startGroupId) throws StarClientException {
        ListShardGroupRequest request = ListShardGroupRequest.newBuilder().setServiceId(serviceId).setIncludeAnonymousGroup(false).setStartGroupId(startGroupId).build();
        ListShardGroupResponse response = this.internalReadRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientListTimeoutSec, TimeUnit.SECONDS)).listShardGroup(request));
        return Pair.of((Object)response.getShardGroupInfosList(), (Object)response.getNextGroupId());
    }

    public List<ShardGroupInfo> listShardGroup(String serviceId) throws StarClientException {
        Pair<List<ShardGroupInfo>, Long> pair;
        long startGroupId = 0L;
        ArrayList<ShardGroupInfo> shardGroupInfos = new ArrayList<ShardGroupInfo>();
        do {
            pair = this.listShardGroup(serviceId, startGroupId);
            shardGroupInfos.addAll((Collection)pair.getKey());
        } while ((startGroupId = ((Long)pair.getValue()).longValue()) != 0L);
        return shardGroupInfos;
    }

    public List<ShardGroupInfo> getShardGroup(String serviceId, List<Long> groupIds) throws StarClientException {
        if (groupIds.isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "group id can not be empty.");
        }
        GetShardGroupRequest request = GetShardGroupRequest.newBuilder().setServiceId(serviceId).addAllShardGroupId(groupIds).build();
        GetShardGroupResponse response = this.internalReadRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientReadTimeoutSec, TimeUnit.SECONDS)).getShardGroup(request));
        return response.getShardGroupInfoList();
    }

    public MetaGroupInfo createMetaGroup(String serviceId, CreateMetaGroupInfo info) throws StarClientException {
        CreateMetaGroupRequest request = CreateMetaGroupRequest.newBuilder().setServiceId(serviceId).setCreateMetaGroupInfo(info).build();
        CreateMetaGroupResponse response = this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).createMetaGroup(request));
        return response.getMetaGroupInfo();
    }

    public void deleteMetaGroup(String serviceId, DeleteMetaGroupInfo info) throws StarClientException {
        DeleteMetaGroupRequest request = DeleteMetaGroupRequest.newBuilder().setServiceId(serviceId).setDeleteMetaGroupInfo(info).build();
        this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).deleteMetaGroup(request));
    }

    public void updateMetaGroup(String serviceId, UpdateMetaGroupInfo info) throws StarClientException {
        UpdateMetaGroupRequest request = UpdateMetaGroupRequest.newBuilder().setServiceId(serviceId).setUpdateMetaGroupInfo(info).build();
        this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).updateMetaGroup(request));
    }

    public MetaGroupInfo getMetaGroupInfo(String serviceId, long metaGroupId) throws StarClientException {
        GetMetaGroupRequest request = GetMetaGroupRequest.newBuilder().setServiceId(serviceId).setMetaGroupId(metaGroupId).build();
        GetMetaGroupResponse response = this.internalReadRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientReadTimeoutSec, TimeUnit.SECONDS)).getMetaGroup(request));
        return response.getMetaGroupInfo();
    }

    public List<MetaGroupInfo> listMetaGroup(String serviceId) throws StarClientException {
        ListMetaGroupRequest request = ListMetaGroupRequest.newBuilder().setServiceId(serviceId).build();
        ListMetaGroupResponse response = this.internalReadRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientListTimeoutSec, TimeUnit.SECONDS)).listMetaGroup(request));
        return response.getMetaGroupInfosList();
    }

    public boolean queryMetaGroupStable(String serviceId, long metaGroupId) throws StarClientException {
        return this.queryMetaGroupStable(serviceId, metaGroupId, 0L);
    }

    public boolean queryMetaGroupStable(String serviceId, long metaGroupId, long workerGroupId) throws StarClientException {
        QueryMetaGroupStableRequest.Builder reqBuilder = QueryMetaGroupStableRequest.newBuilder().setServiceId(serviceId).setMetaGroupId(metaGroupId);
        if (workerGroupId != 0L) {
            reqBuilder.setWorkerGroupId(workerGroupId);
        }
        QueryMetaGroupStableResponse response = this.internalReadRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientReadTimeoutSec, TimeUnit.SECONDS)).queryMetaGroupStable(reqBuilder.build()));
        return response.getIsStable();
    }

    public FilePathInfo allocateFilePath(String serviceId, FileStoreType fsType, String suffix) throws StarClientException {
        return this.allocateFilePath(serviceId, fsType, suffix, "");
    }

    public FilePathInfo allocateFilePath(String serviceId, String fsKey, String suffix) throws StarClientException {
        return this.allocateFilePath(serviceId, FS_NOT_SET, suffix, fsKey);
    }

    private FilePathInfo allocateFilePath(String serviceId, FileStoreType fsType, String suffix, String fsKey) throws StarClientException {
        AllocateFilePathRequest request = AllocateFilePathRequest.newBuilder().setServiceId(serviceId).setSuffix(suffix).setFsType(fsType).setFsKey(fsKey).build();
        AllocateFilePathResponse response = this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientReadTimeoutSec, TimeUnit.SECONDS)).allocateFilePath(request));
        return response.getPathInfo();
    }

    public String addFileStore(FileStoreInfo info, String serviceId) throws StarClientException {
        if (info.getFsName().isEmpty()) {
            throw new StarClientException(StatusCode.INVALID_ARGUMENT, "Fs name can not be empty");
        }
        AddFileStoreRequest request = AddFileStoreRequest.newBuilder().setFsInfo(info).setServiceId(serviceId).build();
        AddFileStoreResponse response = this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).addFileStore(request));
        return response.getFsKey();
    }

    public void removeFileStore(String fsKey, String serviceId) throws StarClientException {
        this.removeFileStoreInternal(fsKey, "", serviceId);
    }

    public void removeFileStoreByName(String fsName, String serviceId) throws StarClientException {
        this.removeFileStoreInternal("", fsName, serviceId);
    }

    private void removeFileStoreInternal(String fsKey, String fsName, String serviceId) throws StarClientException {
        RemoveFileStoreRequest request = RemoveFileStoreRequest.newBuilder().setFsName(fsName).setFsKey(fsKey).setServiceId(serviceId).build();
        this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).removeFileStore(request));
    }

    public void updateFileStore(FileStoreInfo info, String serviceId) throws StarClientException {
        UpdateFileStoreRequest request = UpdateFileStoreRequest.newBuilder().setFsInfo(info).setServiceId(serviceId).build();
        this.internalWriteRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientWriteTimeoutSec, TimeUnit.SECONDS)).updateFileStore(request));
    }

    public List<FileStoreInfo> listFileStore(String serviceId) throws StarClientException {
        return this.listFileStore(serviceId, FS_NOT_SET);
    }

    public List<FileStoreInfo> listFileStore(String serviceId, FileStoreType fsType) throws StarClientException {
        ListFileStoreRequest request = ListFileStoreRequest.newBuilder().setServiceId(serviceId).setFsType(fsType).build();
        ListFileStoreResponse response = this.internalReadRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientListTimeoutSec, TimeUnit.SECONDS)).listFileStore(request));
        return response.getFsInfosList();
    }

    public FileStoreInfo getFileStore(String fsKey, String serviceId) throws StarClientException {
        return this.getFileStoreInternal("", fsKey, serviceId);
    }

    public FileStoreInfo getFileStoreByName(String fsName, String serviceId) throws StarClientException {
        return this.getFileStoreInternal(fsName, "", serviceId);
    }

    private FileStoreInfo getFileStoreInternal(String fsName, String fsKey, String serviceId) throws StarClientException {
        GetFileStoreRequest request = GetFileStoreRequest.newBuilder().setServiceId(serviceId).setFsName(fsName).setFsKey(fsKey).build();
        GetFileStoreResponse response = this.internalReadRpcCall(x -> ((StarManagerGrpc.StarManagerBlockingStub)x.withDeadlineAfter((long)this.clientReadTimeoutSec, TimeUnit.SECONDS)).getFileStore(request));
        return response.getFsInfo();
    }

    public String dump() throws StarClientException {
        DumpRequest request = DumpRequest.newBuilder().build();
        DumpResponse response = this.internalReadRpcCall(x -> x.dump(request));
        return response.getLocation();
    }

    private <V extends Message> V internalWriteRpcCall(RpcCallable<V> callable) throws StarClientException {
        return this.internalRpcCall(callable, true, false);
    }

    private <V extends Message> V internalReadRpcCall(RpcCallable<V> callable) throws StarClientException {
        return this.internalRpcCall(callable, false, false);
    }

    private <V extends Message> V internalReadRpcCallWithLeader(RpcCallable<V> callable, boolean useLeader) throws StarClientException {
        return this.internalRpcCall(callable, false, useLeader);
    }

    private <V extends Message> V internalRpcCall(RpcCallable<V> callable, boolean isWrite, boolean useLeader) throws StarClientException {
        Message result;
        try {
            result = useLeader && (isWrite && this.leaderWriteStub != null || !isWrite && this.leaderReadStub != null) ? (Message)callable.call(isWrite ? this.leaderWriteStub : this.leaderReadStub) : (Message)callable.call(isWrite ? this.writeStub : this.readStub);
        }
        catch (Exception exception) {
            throw new StarClientException(StatusCode.GRPC, exception.getMessage());
        }
        try {
            this.handleStatusError(result);
            return (V)result;
        }
        catch (StarClientException exception) {
            if (!useLeader && !isWrite && exception.getCode() == StatusCode.NOT_LEADER) {
                byte[] extraInfo = exception.getExtraInfo();
                if (extraInfo != null && extraInfo.length > 0) {
                    this.updateLeaderInfo(extraInfo);
                }
                if (this.leaderReadStub != null) {
                    return this.internalRpcCall(callable, false, true);
                }
            }
            throw exception;
        }
    }

    private <V> V internalIpcCall(IpcCallable<V> callable) throws StarClientException {
        try {
            return callable.call();
        }
        catch (StarException exception) {
            byte[] extraInfo;
            StarClientException clientException = new StarClientException(exception.toStatus());
            if (clientException.getCode() == StatusCode.NOT_LEADER && (extraInfo = clientException.getExtraInfo()) != null && extraInfo.length > 0) {
                this.updateLeaderInfo(extraInfo);
            }
            throw clientException;
        }
    }

    private void updateLeaderInfo(byte[] info) {
        LeaderInfo leader;
        try {
            leader = LeaderInfo.parseFrom((byte[])info);
        }
        catch (InvalidProtocolBufferException exception) {
            return;
        }
        String newLeader = String.format("%s:%d", leader.getHost(), leader.getPort());
        try (LockCloseable ignored = new LockCloseable((Lock)this.leaderLock);){
            if (!newLeader.equals(this.leaderAddress)) {
                String olderLeaderAddress = this.leaderAddress;
                this.leaderAddress = newLeader;
                this.resetStub(this.leaderAddress, false, true);
                LOG.info("Leader switched from {} to {}", (Object)olderLeaderAddress, (Object)this.leaderAddress);
            }
        }
    }

    private static StarStatus extractStatusFromProtobufMessage(Message msg) {
        Descriptors.FieldDescriptor descriptor = msg.getDescriptorForType().findFieldByName("status");
        if (descriptor == null) {
            return null;
        }
        Object status = msg.getField(descriptor);
        if (!(status instanceof StarStatus)) {
            return null;
        }
        return (StarStatus)status;
    }

    private void handleStatusError(Message msg) throws StarClientException {
        StarStatus status = StarClient.extractStatusFromProtobufMessage(msg);
        if (status == null) {
            return;
        }
        if (status.getStatusCode() == StatusCode.OK) {
            return;
        }
        throw new StarClientException(status);
    }

    public static String allocateFilePath(FilePathInfo fromInfo, int seed) {
        S3FileStoreInfo s3info;
        String fullPath = fromInfo.getFullPath();
        if (fromInfo.getFsInfo().getFsType() == FileStoreType.S3 && (s3info = fromInfo.getFsInfo().getS3FsInfo()).getPartitionedPrefixEnabled()) {
            int modulus = s3info.getNumPartitionedPrefix();
            Preconditions.checkState((boolean)s3info.getPathPrefix().isEmpty());
            Preconditions.checkState((modulus > 0 ? 1 : 0) != 0);
            String commonPrefix = String.format("s3://%s", s3info.getBucket());
            Preconditions.checkState((boolean)fullPath.startsWith(commonPrefix));
            String relativeSuffix = fullPath.substring(commonPrefix.length());
            StringBuilder stringBuilder = new StringBuilder(Integer.toHexString(seed % modulus));
            stringBuilder.reverse();
            fullPath = commonPrefix + "/" + stringBuilder + relativeSuffix;
        }
        return fullPath;
    }

    public void setClientReadTimeoutSec(int sec) {
        this.clientReadTimeoutSec = sec;
    }

    public void setClientListTimeoutSec(int sec) {
        this.clientListTimeoutSec = sec;
    }

    public void setClientWriteTimeoutSec(int sec) {
        this.clientWriteTimeoutSec = sec;
    }

    public void setClientReadMaxRetryCount(double cnt) {
        this.clientReadMaxRetryCount = cnt;
        if (this.defaultServerAddress != null) {
            this.resetStub(this.defaultServerAddress, true, false);
        }
        if (this.leaderAddress != null) {
            this.resetStub(this.leaderAddress, true, true);
        }
    }

    protected static interface IpcCallable<V> {
        public V call() throws StarException;
    }

    protected static interface RpcCallable<V> {
        public V call(StarManagerGrpc.StarManagerBlockingStub var1) throws StarClientException;
    }
}

