/*
 * Decompiled with CFR 0.152.
 */
package com.staros.client;

import com.staros.proto.StarStatus;
import com.staros.proto.StatusCode;

public class StarClientException
extends Exception {
    private final StatusCode code;
    private byte[] extraInfo;

    public StarClientException(StatusCode code, String msg) {
        super(code.toString() + ":" + msg);
        this.code = code;
        this.extraInfo = new byte[0];
    }

    public StarClientException(StarStatus status) {
        this(status.getStatusCode(), status.getErrorMsg());
        this.extraInfo = status.getExtraInfo().toByteArray();
    }

    public StatusCode getCode() {
        return this.code;
    }

    public byte[] getExtraInfo() {
        return this.extraInfo;
    }
}

