/*
 * Decompiled with CFR 0.152.
 */
package com.staros.exception;

import com.staros.exception.ExceptionCode;
import com.staros.proto.StarStatus;
import com.staros.proto.StatusCode;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class StarException
extends RuntimeException {
    private final ExceptionCode code;

    public StarException(ExceptionCode code, String msg) {
        super(msg);
        this.code = code;
    }

    public StarException(ExceptionCode code, String messagePattern, Object ... params) {
        this(code, ParameterizedMessage.format((String)messagePattern, (Object[])params));
    }

    public ExceptionCode getExceptionCode() {
        return this.code;
    }

    public StarStatus toStatus() {
        StatusCode c;
        switch (this.code) {
            case INVALID_ARGUMENT: {
                c = StatusCode.INVALID_ARGUMENT;
                break;
            }
            case NOT_EXIST: {
                c = StatusCode.NOT_EXIST;
                break;
            }
            case ALREADY_EXIST: {
                c = StatusCode.ALREADY_EXIST;
                break;
            }
            case NOT_ALLOWED: {
                c = StatusCode.NOT_ALLOWED;
                break;
            }
            case JOURNAL: {
                c = StatusCode.JOURNAL;
                break;
            }
            case IO: {
                c = StatusCode.IO;
                break;
            }
            case NOT_LEADER: {
                c = StatusCode.NOT_LEADER;
                break;
            }
            case NOT_IMPLEMENTED: {
                c = StatusCode.NOT_IMPLEMENTED;
                break;
            }
            case FAILED_PRECONDITION: {
                c = StatusCode.FAILED_PRECONDITION;
                break;
            }
            default: {
                c = StatusCode.UNKNOWN;
            }
        }
        return StarStatus.newBuilder().setStatusCode(c).setErrorMsg(this.getMessage()).build();
    }
}

