/*
 * Decompiled with CFR 0.152.
 */
package com.staros.section;

import com.google.common.base.Preconditions;
import com.staros.proto.SectionHeader;
import com.staros.proto.SectionType;
import com.staros.stream.ChunkedOutputStream;
import com.staros.util.LockCloseable;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantLock;

public class SectionWriter
implements Closeable {
    private final OutputStream parent;
    private final ReentrantLock lock;
    private boolean closed;
    private OutputStream currentSubStream;

    public SectionWriter(OutputStream out) {
        this.parent = out;
        this.lock = new ReentrantLock();
        this.closed = false;
        this.currentSubStream = null;
    }

    public OutputStream appendSection(SectionType type) throws IOException {
        Preconditions.checkState((type != SectionType.SECTION_DONE ? 1 : 0) != 0);
        try (LockCloseable ignored = new LockCloseable(this.lock);){
            this.disposeCurrentStream();
            SectionWriter.writeSectionHeader(this.parent, type);
            OutputStream outputStream = this.currentSubStream = new BufferedOutputStream(new ChunkedOutputStream(this.parent));
            return outputStream;
        }
    }

    @Override
    public void close() throws IOException {
        try (LockCloseable ignored = new LockCloseable(this.lock);){
            if (this.closed) {
                return;
            }
            this.disposeCurrentStream();
            SectionWriter.writeSectionHeader(this.parent, SectionType.SECTION_DONE);
            this.closed = true;
        }
    }

    private void disposeCurrentStream() throws IOException {
        if (this.currentSubStream != null) {
            this.currentSubStream.close();
            this.currentSubStream = null;
        }
    }

    private static void writeSectionHeader(OutputStream os, SectionType type) throws IOException {
        SectionHeader.newBuilder().setSectionType(type).build().writeDelimitedTo(os);
    }
}

