/*
 * Decompiled with CFR 0.152.
 */
package com.staros.stream;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ChunkedInputStream
extends FilterInputStream {
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(new byte[0]).asReadOnlyBuffer();
    private boolean readEnd = false;
    private ByteBuffer buffer = EMPTY_BYTE_BUFFER;

    public ChunkedInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        if (this.readEnd) {
            return -1;
        }
        if (this.buffer.remaining() == 0) {
            this.readNextAvailable();
            if (this.buffer.remaining() == 0) {
                return -1;
            }
        }
        return 0xFF & this.buffer.get();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int done;
        int todo;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.readEnd) {
            return -1;
        }
        for (done = 0; done < len; done += todo) {
            if (this.buffer.remaining() == 0) {
                this.readNextAvailable();
                if (this.buffer.remaining() == 0) break;
            }
            todo = Math.min(len - done, this.buffer.remaining());
            this.buffer.get(b, off, todo);
            off += todo;
        }
        return done == 0 ? -1 : done;
    }

    private void readNextAvailable() throws IOException {
        int len = this.readIntFromParent();
        if (len == 0) {
            this.readEnd = true;
            this.buffer = EMPTY_BYTE_BUFFER;
            return;
        }
        this.buffer = ByteBuffer.allocate(len);
        int done = 0;
        while (done < len) {
            int n = this.in.read(this.buffer.array(), this.buffer.position(), this.buffer.remaining());
            if (n == -1) {
                throw new EOFException();
            }
            this.buffer.position(done += n);
        }
        this.buffer.flip();
        this.buffer = this.buffer.asReadOnlyBuffer();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private int readIntFromParent() throws IOException {
        int firstByte = this.in.read();
        if (firstByte == -1) {
            throw new EOFException();
        }
        try {
            return CodedInputStream.readRawVarint32((int)firstByte, (InputStream)this.in);
        }
        catch (InvalidProtocolBufferException exception) {
            throw new EOFException();
        }
    }
}

