/*
 * Decompiled with CFR 0.152.
 */
package com.staros.util;

import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class LogRateLimiter {
    private final RateLimiter limiter;
    private final AtomicLong omitCounter;
    private final Logger logger;

    public LogRateLimiter(Logger log, double limits) {
        this.logger = log;
        this.limiter = RateLimiter.create((double)limits);
        this.omitCounter = new AtomicLong(0L);
    }

    public void info(String messagePattern, Object ... params) {
        String msg = ParameterizedMessage.format((String)messagePattern, (Object[])params);
        if (this.limiter.tryAcquire()) {
            long omits = this.omitCounter.getAndSet(0L);
            if (omits == 0L) {
                this.logger.info(msg);
            } else {
                this.logger.info("{}. [{} similar messages omitted]", (Object)msg, (Object)omits);
            }
        } else {
            this.omitCounter.incrementAndGet();
        }
    }
}

