/*
 * Decompiled with CFR 0.152.
 */
package com.staros.util;

import com.staros.exception.ExceptionCode;
import com.staros.exception.StarException;
import com.staros.util.Text;
import com.staros.util.Writable;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ByteWriter
extends DataOutputStream {
    private static final int BUFFER_INIT_SIZE = 256;

    public ByteWriter() {
        super(new ByteArrayOutputStream(256));
    }

    public byte[] getData() {
        return ((ByteArrayOutputStream)this.out).toByteArray();
    }

    public void write(Writable w) throws StarException {
        try {
            w.write(this);
        }
        catch (IOException e) {
            throw new StarException(ExceptionCode.IO, e.getMessage());
        }
    }

    public void writeI(int i) throws StarException {
        try {
            this.writeInt(i);
        }
        catch (IOException e) {
            throw new StarException(ExceptionCode.IO, e.getMessage());
        }
    }

    public void writeL(long l) throws StarException {
        try {
            this.writeLong(l);
        }
        catch (IOException e) {
            throw new StarException(ExceptionCode.IO, e.getMessage());
        }
    }

    public void writeB(byte[] bytes) throws StarException {
        try {
            Text.writeBytes(this, bytes);
        }
        catch (IOException e) {
            throw new StarException(ExceptionCode.IO, e.getMessage());
        }
    }
}

