/*
 * Decompiled with CFR 0.152.
 */
package com.staros.metrics;

import io.prometheus.metrics.core.metrics.Counter;
import io.prometheus.metrics.core.metrics.Gauge;
import io.prometheus.metrics.core.metrics.GaugeWithCallback;
import io.prometheus.metrics.core.metrics.Histogram;
import io.prometheus.metrics.expositionformats.PrometheusTextFormatWriter;
import io.prometheus.metrics.model.registry.Collector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Consumer;

public class MetricsSystem {
    public static final PrometheusRegistry METRIC_REGISTRY = new PrometheusRegistry();

    public static Gauge registerGauge(String name, String helpMsg) {
        return MetricsSystem.registerGauge(name, helpMsg, null);
    }

    public static Gauge registerGauge(String name, String helpMsg, List<String> labels) {
        Gauge.Builder builder = (Gauge.Builder)((Gauge.Builder)Gauge.builder().name(name)).help(helpMsg);
        if (labels != null && !labels.isEmpty()) {
            builder.labelNames(labels.toArray(new String[0]));
        }
        return (Gauge)builder.register(METRIC_REGISTRY);
    }

    public static GaugeWithCallback registerGaugeCallback(String name, String helpMsg, Consumer<GaugeWithCallback.Callback> cb) {
        GaugeWithCallback.Builder builder = ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name(name)).help(helpMsg)).callback(cb);
        return (GaugeWithCallback)builder.register(METRIC_REGISTRY);
    }

    public static Counter registerCounter(String name, String helpMsg) {
        return MetricsSystem.registerCounter(name, helpMsg, null);
    }

    public static Counter registerCounter(String name, String helpMsg, List<String> labels) {
        Counter.Builder builder = (Counter.Builder)Counter.builder().name(name).help(helpMsg);
        if (labels != null && !labels.isEmpty()) {
            builder.labelNames(labels.toArray(new String[0]));
        }
        return (Counter)builder.register(METRIC_REGISTRY);
    }

    public static Histogram registerHistogram(String name, String helpMsg, List<String> labels) {
        Histogram.Builder builder = (Histogram.Builder)((Histogram.Builder)Histogram.builder().name(name)).help(helpMsg);
        if (labels != null && !labels.isEmpty()) {
            builder.labelNames(labels.toArray(new String[0]));
        }
        return (Histogram)builder.register(METRIC_REGISTRY);
    }

    public static void exportMetricsTextFormat(OutputStream out) throws IOException {
        PrometheusTextFormatWriter writer = new PrometheusTextFormatWriter(false);
        writer.write(out, METRIC_REGISTRY.scrape());
    }

    public static void removeCollector(Collector collector) {
        METRIC_REGISTRY.unregister(collector);
    }
}

