/*
 * Decompiled with CFR 0.152.
 */
package com.staros.filestore;

import com.staros.credential.AzBlobCredential;
import com.staros.filestore.AbstractFileStore;
import com.staros.filestore.FileStore;
import com.staros.proto.AzBlobFileStoreInfo;
import com.staros.proto.FileStoreInfo;
import com.staros.proto.FileStoreType;
import com.staros.util.LockCloseable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class AzBlobFileStore
extends AbstractFileStore {
    private String endpoint;
    private AzBlobCredential credential;

    @Override
    public FileStoreType type() {
        return FileStoreType.AZBLOB;
    }

    @Override
    public boolean isValid() {
        if (this.endpoint.isEmpty()) {
            return false;
        }
        assert (!this.locations.isEmpty());
        String path = ((String)this.locations.get(0)).substring("azblob://".length());
        return !path.isEmpty();
    }

    public AzBlobFileStore(FileStoreInfo fsInfo, String endpoint, AzBlobCredential credential) {
        super(fsInfo);
        this.endpoint = endpoint;
        this.credential = credential;
    }

    public AzBlobFileStore(String key, String name, String endpoint, String path, AzBlobCredential credential) {
        super(key, name);
        this.endpoint = endpoint;
        this.credential = credential;
        this.locations.add("azblob://" + path);
    }

    private FileStoreInfo toProtobufInternal(boolean includeSecret) {
        try (LockCloseable lockCloseable = new LockCloseable((Lock)this.lock.readLock());){
            assert (!this.locations.isEmpty());
            AzBlobFileStoreInfo.Builder azblobBuilder = AzBlobFileStoreInfo.newBuilder();
            azblobBuilder.setEndpoint(this.endpoint);
            azblobBuilder.setPath(((String)this.locations.get(0)).substring("azblob://".length()));
            if (includeSecret) {
                azblobBuilder.setCredential(this.credential.toProtobuf());
            }
            FileStoreInfo fileStoreInfo = this.toProtobufBuilder().setFsType(FileStoreType.AZBLOB).setAzblobFsInfo(azblobBuilder).build();
            return fileStoreInfo;
        }
    }

    @Override
    public FileStoreInfo toProtobuf() {
        return this.toProtobufInternal(true);
    }

    @Override
    public FileStoreInfo toDebugProtobuf() {
        return this.toProtobufInternal(false);
    }

    @Override
    public void mergeFrom(FileStore fileStore) {
        super.mergeFrom(fileStore);
    }

    public static FileStore fromProtobuf(FileStoreInfo fsInfo) {
        AzBlobFileStoreInfo azblobInfo = fsInfo.getAzblobFsInfo();
        String endpoint = azblobInfo.getEndpoint();
        String path = azblobInfo.getPath();
        if (fsInfo.getLocationsList().isEmpty()) {
            List<String> locations = Arrays.asList("azblob://" + path);
            fsInfo = fsInfo.toBuilder().addAllLocations(locations).build();
        }
        AzBlobCredential credential = AzBlobCredential.fromProtobuf(azblobInfo.getCredential());
        return new AzBlobFileStore(fsInfo, endpoint, credential);
    }
}

