/*
 * Decompiled with CFR 0.152.
 */
package com.staros.filestore;

import com.staros.filestore.AbstractFileStore;
import com.staros.filestore.FileStore;
import com.staros.proto.FileStoreInfo;
import com.staros.proto.FileStoreType;
import com.staros.proto.HDFSFileStoreInfo;
import com.staros.util.LockCloseable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

public class HDFSFileStore
extends AbstractFileStore {
    @Override
    public FileStoreType type() {
        return FileStoreType.HDFS;
    }

    @Override
    public String rootPath() {
        assert (!this.locations.isEmpty());
        String url = (String)this.locations.get(0);
        if (!url.endsWith("/")) {
            return url + "/";
        }
        return url;
    }

    @Override
    public boolean isValid() {
        assert (!this.locations.isEmpty());
        String url = (String)this.locations.get(0);
        return !url.isEmpty();
    }

    public HDFSFileStore(FileStoreInfo fsInfo) {
        super(fsInfo);
    }

    public HDFSFileStore(String key, String name, String url) {
        super(key, name);
        this.locations.add(url);
    }

    private FileStoreInfo toProtobufInternal(boolean includeSecret) {
        try (LockCloseable lockCloseable = new LockCloseable((Lock)this.lock.readLock());){
            assert (!this.locations.isEmpty());
            HDFSFileStoreInfo.Builder hdfsBuilder = HDFSFileStoreInfo.newBuilder();
            hdfsBuilder.setUrl((String)this.locations.get(0));
            FileStoreInfo fileStoreInfo = this.toProtobufBuilder().setFsType(FileStoreType.HDFS).setHdfsFsInfo(hdfsBuilder).build();
            return fileStoreInfo;
        }
    }

    @Override
    public FileStoreInfo toProtobuf() {
        return this.toProtobufInternal(true);
    }

    @Override
    public FileStoreInfo toDebugProtobuf() {
        return this.toProtobufInternal(false);
    }

    @Override
    public void mergeFrom(FileStore fileStore) {
        super.mergeFrom(fileStore);
    }

    public static FileStore fromProtobuf(FileStoreInfo fsInfo) {
        HDFSFileStoreInfo hdfsInfo = fsInfo.getHdfsFsInfo();
        String url = hdfsInfo.getUrl();
        if (fsInfo.getLocationsList().isEmpty()) {
            ArrayList<String> locations = new ArrayList<String>(Arrays.asList(url));
            fsInfo = fsInfo.toBuilder().addAllLocations(locations).build();
        }
        return new HDFSFileStore(fsInfo);
    }
}

