/*
 * Decompiled with CFR 0.152.
 */
package com.staros.filestore;

import com.staros.credential.AwsCredential;
import com.staros.credential.AwsCredentialMgr;
import com.staros.filestore.AbstractFileStore;
import com.staros.filestore.FileStore;
import com.staros.proto.FileStoreInfo;
import com.staros.proto.FileStoreType;
import com.staros.proto.S3FileStoreInfo;
import com.staros.util.LockCloseable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

public class S3FileStore
extends AbstractFileStore {
    private String region;
    private String endpoint;
    private AwsCredential credential;

    public S3FileStore(String key, String name, String bucket, String region, String endpoint, AwsCredential credential, String pathPrefix) {
        super(key, name);
        this.locations.add("s3://" + Paths.get(bucket, pathPrefix));
        this.region = region;
        this.endpoint = endpoint;
        this.credential = credential;
    }

    public S3FileStore(FileStoreInfo fsInfo, String region, String endpoint, AwsCredential credential) {
        super(fsInfo);
        this.region = region;
        this.endpoint = endpoint;
        this.credential = credential;
    }

    @Override
    public FileStoreType type() {
        return FileStoreType.S3;
    }

    @Override
    public String rootPath() {
        return (String)this.locations.get(0);
    }

    @Override
    public boolean isValid() {
        assert (!this.locations.isEmpty());
        String[] bucketAndPrefix = this.getBucketAndPrefix((String)this.locations.get(0));
        String bucket = bucketAndPrefix[0];
        if (bucket.isEmpty()) {
            return false;
        }
        return this.credential != null;
    }

    private FileStoreInfo toProtobufInternal(boolean includeSecret) {
        try (LockCloseable lockCloseable = new LockCloseable((Lock)this.lock.readLock());){
            assert (!this.locations.isEmpty());
            String[] bucketAndPrefix = this.getBucketAndPrefix((String)this.locations.get(0));
            S3FileStoreInfo.Builder s3fsBuilder = S3FileStoreInfo.newBuilder();
            s3fsBuilder.setBucket(bucketAndPrefix[0]);
            s3fsBuilder.setRegion(this.region);
            s3fsBuilder.setEndpoint(this.endpoint);
            s3fsBuilder.setPathPrefix(bucketAndPrefix[1]);
            if (includeSecret) {
                s3fsBuilder.setCredential(AwsCredentialMgr.toProtobuf(this.credential));
            }
            FileStoreInfo fileStoreInfo = this.toProtobufBuilder().setFsType(FileStoreType.S3).setS3FsInfo(s3fsBuilder).build();
            return fileStoreInfo;
        }
    }

    @Override
    public FileStoreInfo toProtobuf() {
        return this.toProtobufInternal(true);
    }

    @Override
    public FileStoreInfo toDebugProtobuf() {
        return this.toProtobufInternal(false);
    }

    @Override
    public void mergeFrom(FileStore other) {
        assert (other.type() == FileStoreType.S3);
        super.mergeFrom(other);
        S3FileStore s3fs = (S3FileStore)other;
        if (!s3fs.getRegion().isEmpty()) {
            this.region = s3fs.region;
        }
        if (!s3fs.getEndpoint().isEmpty()) {
            this.endpoint = s3fs.endpoint;
        }
        if (s3fs.getCredential() != null) {
            this.credential = s3fs.credential;
        }
    }

    public static FileStore fromProtobuf(FileStoreInfo fsInfo) {
        S3FileStoreInfo s3FsInfo = fsInfo.getS3FsInfo();
        String bucket = s3FsInfo.getBucket();
        String region = s3FsInfo.getRegion();
        String endpoint = s3FsInfo.getEndpoint();
        String pathPrefix = s3FsInfo.getPathPrefix();
        if (fsInfo.getLocationsList().isEmpty()) {
            ArrayList<String> locations = new ArrayList<String>(Arrays.asList("s3://" + Paths.get(bucket, pathPrefix)));
            fsInfo = fsInfo.toBuilder().addAllLocations(locations).build();
        }
        AwsCredential credential = AwsCredentialMgr.fromProtobuf(s3FsInfo.getCredential());
        return new S3FileStore(fsInfo, region, endpoint, credential);
    }

    public String getRegion() {
        return this.region;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public AwsCredential getCredential() {
        return this.credential;
    }

    private String[] getBucketAndPrefix(String location) {
        String path = location.substring("s3://".length());
        int index = path.indexOf(47);
        if (index < 0) {
            return new String[]{path, ""};
        }
        return new String[]{path.substring(0, index), path.substring(index + 1)};
    }
}

