/*
 * Decompiled with CFR 0.152.
 */
package com.staros.schedule;

import com.staros.exception.StarException;
import com.staros.util.LogRateLimiter;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ScheduleRequestContext
implements Comparable<ScheduleRequestContext> {
    private static final Logger LOG = LogManager.getLogger(ScheduleRequestContext.class);
    private static final LogRateLimiter logLimiter = new LogRateLimiter(LOG, 1.0);
    private final String serviceId;
    private final long shardId;
    private final long workerGroupId;
    private final CountDownLatch latch;
    private Collection<Long> workerIds = null;
    private Collection<Long> exclusiveGroupIds = null;
    private StarException exception = null;
    private Runnable runnable = null;

    @Override
    public int compareTo(ScheduleRequestContext rhs) {
        if (rhs == this) {
            return 0;
        }
        if (rhs.shardId != this.shardId) {
            return Long.compare(this.shardId, rhs.shardId);
        }
        if (rhs.workerGroupId != this.workerGroupId) {
            return Long.compare(this.workerGroupId, rhs.workerGroupId);
        }
        return this.serviceId.compareTo(rhs.serviceId);
    }

    public ScheduleRequestContext(String serviceId, long shardId, long wgId, CountDownLatch latch) {
        this.serviceId = serviceId;
        this.shardId = shardId;
        this.workerGroupId = wgId;
        this.latch = latch;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public long getShardId() {
        return this.shardId;
    }

    public long getWorkerGroupId() {
        return this.workerGroupId;
    }

    public void setException(StarException e) {
        if (this.exception == null && e != null) {
            this.exception = e;
        }
    }

    public StarException getException() {
        return this.exception;
    }

    public void setWorkerIds(Collection<Long> workerIds) {
        this.workerIds = workerIds;
    }

    public Collection<Long> getWorkerIds() {
        return this.workerIds;
    }

    public void setExclusiveGroupIds(Collection<Long> groupIds) {
        this.exclusiveGroupIds = groupIds;
    }

    public Collection<Long> getExclusiveGroupIds() {
        return this.exclusiveGroupIds;
    }

    public void reset() {
        this.exception = null;
        this.workerIds = null;
        this.exclusiveGroupIds = null;
        this.runnable = null;
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public boolean isWaited() {
        return this.latch != null;
    }

    public void done() {
        this.done(null);
    }

    public void done(StarException exception) {
        this.setException(exception);
        if (this.latch != null) {
            this.latch.countDown();
        }
        if (this.exception != null && !this.isWaited()) {
            logLimiter.info("{} done with exception: {}", new Object[]{this, exception.getMessage()});
        }
    }

    public void await() throws InterruptedException {
        if (this.latch != null) {
            this.latch.await();
        }
    }

    public String toString() {
        return String.format("ScheduleRequestContext [ ServiceId: %s, ShardId: %d, WorkerGroupId: %d, WaitForResult: %b ]", this.serviceId, this.shardId, this.workerGroupId, this.latch != null);
    }

    public int hashCode() {
        return (int)(this.shardId ^ this.workerGroupId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduleRequestContext rhs = (ScheduleRequestContext)obj;
        return this.shardId == rhs.shardId && this.workerGroupId == rhs.workerGroupId && this.serviceId.equals(rhs.serviceId);
    }
}

