/*
 * Decompiled with CFR 0.152.
 */
package com.staros.service;

import com.staros.proto.ServiceComponentInfo;
import com.staros.proto.ServiceTemplateInfo;
import com.staros.service.ServiceComponent;
import com.staros.util.Text;
import com.staros.util.Writable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ServiceTemplate
implements Writable {
    private final String serviceTemplateName;
    private final List<ServiceComponent> serviceComponents;

    public ServiceTemplate(String serviceTemplateName, List<String> serviceComponentNames) {
        this.serviceTemplateName = serviceTemplateName;
        this.serviceComponents = new ArrayList<ServiceComponent>();
        if (serviceComponentNames != null) {
            for (String name : serviceComponentNames) {
                this.serviceComponents.add(new ServiceComponent(name));
            }
        }
    }

    public String getServiceTemplateName() {
        return this.serviceTemplateName;
    }

    public List<ServiceComponent> getServiceComponents() {
        return this.serviceComponents;
    }

    public ServiceTemplateInfo toProtobuf() {
        ServiceTemplateInfo.Builder builder = ServiceTemplateInfo.newBuilder();
        builder.setServiceTemplateName(this.serviceTemplateName);
        for (ServiceComponent sc : this.serviceComponents) {
            builder.addServiceComponentInfo(sc.toProtobuf());
        }
        return builder.build();
    }

    public static ServiceTemplate fromProtobuf(ServiceTemplateInfo info) {
        String name = info.getServiceTemplateName();
        ArrayList<String> componentNames = new ArrayList<String>();
        List components = info.getServiceComponentInfoList();
        for (ServiceComponentInfo com : components) {
            componentNames.add(com.getServiceComponentName());
        }
        return new ServiceTemplate(name, componentNames);
    }

    public void write(DataOutput out) throws IOException {
        byte[] bytes = this.toProtobuf().toByteArray();
        Text.writeBytes((DataOutput)out, (byte[])bytes);
    }

    public static ServiceTemplate read(DataInput in) throws IOException {
        byte[] bytes = Text.readBytes((DataInput)in);
        ServiceTemplateInfo info = ServiceTemplateInfo.parseFrom((byte[])bytes);
        return ServiceTemplate.fromProtobuf(info);
    }
}

