/*
 * Decompiled with CFR 0.152.
 */
package com.staros.replica;

import com.staros.proto.ReplicaInfo;
import com.staros.proto.ReplicaRole;
import com.staros.proto.WorkerInfo;

public class Replica {
    private final long workerId;
    private ReplicaRole role;

    public Replica(long workerId) {
        this.workerId = workerId;
        this.role = ReplicaRole.PRIMARY;
    }

    public ReplicaRole getRole() {
        return this.role;
    }

    public void setRole(ReplicaRole role) {
        this.role = role;
    }

    public long getWorkerId() {
        return this.workerId;
    }

    public ReplicaInfo toProtobuf() {
        WorkerInfo workerInfo = WorkerInfo.newBuilder().setWorkerId(this.workerId).build();
        ReplicaInfo.Builder builder = ReplicaInfo.newBuilder();
        builder.setWorkerInfo(workerInfo);
        builder.setReplicaRole(this.role);
        return builder.build();
    }

    public static Replica fromProtobuf(ReplicaInfo info) {
        long workerId = info.getWorkerInfo().getWorkerId();
        ReplicaRole role = info.getReplicaRole();
        Replica replica = new Replica(workerId);
        replica.setRole(role);
        return replica;
    }
}

