/*
 * Decompiled with CFR 0.152.
 */
package com.staros.credential;

import com.staros.proto.AzBlobCredentialInfo;

public class AzBlobCredential {
    private String sharedKey;
    private String sasToken;
    private String tenantId;
    private String clientId;
    private String clientSecret;
    private String clientCertificatePath;
    private String authorityHost;

    public AzBlobCredential(String sharedKey, String sasToken, String tenantId, String clientId, String clientSecret, String clientCertificatePath, String authorityHost) {
        this.sharedKey = sharedKey;
        this.sasToken = sasToken;
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.clientCertificatePath = clientCertificatePath;
        this.authorityHost = authorityHost;
    }

    public AzBlobCredentialInfo toProtobuf() {
        AzBlobCredentialInfo.Builder builder = AzBlobCredentialInfo.newBuilder();
        return builder.setSharedKey(this.sharedKey).setSasToken(this.sasToken).setTenantId(this.tenantId).setClientId(this.clientId).setClientSecret(this.clientSecret).setClientCertificatePath(this.clientCertificatePath).setAuthorityHost(this.authorityHost).build();
    }

    public boolean isEmpty() {
        return this.sharedKey.isEmpty() && this.sasToken.isEmpty() && this.tenantId.isEmpty() && this.clientId.isEmpty() && this.clientSecret.isEmpty() && this.clientCertificatePath.isEmpty() && this.authorityHost.isEmpty();
    }

    public static AzBlobCredential fromProtobuf(AzBlobCredentialInfo credentialInfo) {
        String sharedKey = credentialInfo.getSharedKey();
        String sasToken = credentialInfo.getSasToken();
        String tenantId = credentialInfo.getTenantId();
        String clientId = credentialInfo.getClientId();
        String clientSecret = credentialInfo.getClientSecret();
        String clientCertificatePath = credentialInfo.getClientCertificatePath();
        String authorityHost = credentialInfo.getAuthorityHost();
        return new AzBlobCredential(sharedKey, sasToken, tenantId, clientId, clientSecret, clientCertificatePath, authorityHost);
    }
}

