/*
 * Decompiled with CFR 0.152.
 */
package com.staros.util;

import com.staros.exception.StarException;
import com.staros.journal.Journal;
import com.staros.journal.JournalSystem;
import com.staros.journal.StarMgrJournal;

public class IdGenerator {
    public static final int BATCH_ID_INTERVAL = 1000;
    private long nextId;
    private long nextPersistentId;
    private JournalSystem journalSystem;

    public IdGenerator(JournalSystem journalSystem) {
        this.nextPersistentId = this.nextId = 1L;
        this.journalSystem = journalSystem;
    }

    public synchronized long getNextId() throws StarException {
        if (this.nextId >= this.nextPersistentId) {
            this.nextPersistentId += 1000L;
            if (this.journalSystem != null) {
                Journal journal = StarMgrJournal.logSetId(this.nextPersistentId);
                this.journalSystem.write(journal);
            }
        }
        return this.nextId++;
    }

    public synchronized void setNextId(long id) {
        if (id > this.nextPersistentId) {
            this.nextPersistentId = this.nextId = id;
        }
    }

    public synchronized long getNextPersistentId() {
        return this.nextPersistentId;
    }
}

