/*
 * Decompiled with CFR 0.152.
 */
package com.staros.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utils {
    private static final Logger LOG = LogManager.getLogger(Utils.class);

    public static void shutdownExecutorService(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOG.error("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static DigestInputStream getDigestInputStream(InputStream stream, String digestAlgorithm) {
        DigestInputStream digestInput = new DigestInputStream(stream, null);
        digestInput.on(false);
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            digestInput.setMessageDigest(md);
            digestInput.on(true);
        }
        catch (NoSuchAlgorithmException exception) {
            LOG.warn("Fail to get MessageDigest for algorithm:{}, disable checksum for InputStream!", (Object)digestAlgorithm);
        }
        return digestInput;
    }

    public static DigestOutputStream getDigestOutputStream(OutputStream stream, String digestAlgorithm) {
        DigestOutputStream digestOutput = new DigestOutputStream(stream, null);
        digestOutput.on(false);
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            digestOutput.setMessageDigest(md);
            digestOutput.on(true);
        }
        catch (NoSuchAlgorithmException exception) {
            LOG.warn("Fail to get MessageDigest for algorithm:{}, disable checksum for OutputStream!", (Object)digestAlgorithm);
        }
        return digestOutput;
    }

    public static void validateChecksum(MessageDigest digest, ByteString expectedChecksum) throws IOException {
        if (digest == null || expectedChecksum.isEmpty()) {
            return;
        }
        if (!ByteString.copyFrom((byte[])digest.digest()).equals((Object)expectedChecksum)) {
            throw new IOException("checksum mismatch");
        }
    }

    public static ThreadFactory namedThreadFactory(String poolName) {
        return new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build();
    }

    public static void adjustFixedThreadPoolExecutors(ThreadPoolExecutor executor, int nExpectedThreads) {
        int nCurrent = executor.getCorePoolSize();
        if (nExpectedThreads < nCurrent) {
            executor.setCorePoolSize(nExpectedThreads);
            executor.setMaximumPoolSize(nExpectedThreads);
        } else if (nExpectedThreads > nCurrent) {
            executor.setMaximumPoolSize(nExpectedThreads);
            executor.setCorePoolSize(nExpectedThreads);
        }
    }
}

