/*
 * Decompiled with CFR 0.152.
 */
package com.staros.starlet;

import com.staros.proto.AddShardRequest;
import com.staros.proto.AddShardResponse;
import com.staros.proto.RemoveShardRequest;
import com.staros.proto.RemoveShardResponse;
import com.staros.proto.StarStatus;
import com.staros.proto.StarletGrpc;
import com.staros.proto.StarletHeartbeatRequest;
import com.staros.proto.StarletHeartbeatResponse;
import com.staros.proto.StatusCode;
import com.staros.proto.WorkerState;
import com.staros.util.Config;
import com.staros.util.StatusFactory;
import com.staros.worker.Worker;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StarletAgent {
    private static final Logger LOG = LogManager.getLogger(StarletAgent.class);
    private final String starMgrAddress = String.format("%s:%s", Config.STARMGR_IP, Config.STARMGR_RPC_PORT);
    private final AtomicReference<StarletGrpc.StarletBlockingStub> blockingStub = new AtomicReference<Object>(null);
    private ManagedChannel channel = null;
    private Worker worker = null;
    private int heartbeatRetryCount = 0;

    public void setWorker(Worker w) {
        this.worker = w;
    }

    public void disconnectWorker() {
        if (this.channel != null) {
            this.channel.shutdown();
            try {
                this.channel.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                LOG.info("Got exception while waiting channel shutdown.", (Throwable)exception);
            }
            this.channel = null;
        }
    }

    public Pair<Boolean, Boolean> heartbeat() {
        StarStatus status = null;
        try {
            this.prepareConnection();
            StarletHeartbeatRequest request = StarletHeartbeatRequest.newBuilder().setStarMgrLeader(this.starMgrAddress).setServiceId(this.worker.getServiceId()).setWorkerGroupId(this.worker.getGroupId()).setWorkerId(this.worker.getWorkerId()).build();
            StarletHeartbeatResponse response = ((StarletGrpc.StarletBlockingStub)this.blockingStub.get().withDeadlineAfter((long)Config.WORKER_HEARTBEAT_GRPC_RPC_TIME_OUT_SEC, TimeUnit.SECONDS)).starletHeartbeat(request);
            status = response.getStatus();
        }
        catch (StatusRuntimeException exception) {
            LOG.warn("caught GRPC exception when sending heartbeat to worker {}, {}.", (Object)this.worker.getIpPort(), (Object)exception);
            status = this.handleGrpcException(exception);
        }
        catch (Exception e) {
            LOG.warn("caught generic exception when sending heartbeat to worker {}, {}.", (Object)this.worker.getIpPort(), (Object)e);
            status = StatusFactory.getStatus((StatusCode)StatusCode.INTERNAL, (String)e.getMessage());
        }
        boolean changed = false;
        if (status.getStatusCode() != StatusCode.OK) {
            if (this.heartbeatRetryCount < Config.WORKER_HEARTBEAT_RETRY_COUNT) {
                ++this.heartbeatRetryCount;
            } else {
                changed = this.worker.setState(WorkerState.DOWN);
            }
            LOG.warn("sending heartbeat to worker {} failed, {}:{}.", (Object)this.worker.getIpPort(), (Object)status.getStatusCode(), (Object)status.getErrorMsg());
            return Pair.of((Object)false, (Object)changed);
        }
        LOG.debug("sending heartbeat to worker {} succeed.", (Object)this.worker.getIpPort());
        changed = this.worker.setState(WorkerState.ON);
        this.heartbeatRetryCount = 0;
        return Pair.of((Object)true, (Object)changed);
    }

    public boolean addShard(AddShardRequest request) {
        AddShardResponse response = null;
        try {
            this.prepareConnection();
            response = ((StarletGrpc.StarletBlockingStub)this.blockingStub.get().withDeadlineAfter((long)Config.GRPC_RPC_TIME_OUT_SEC, TimeUnit.SECONDS)).addShard(request);
        }
        catch (Exception e) {
            LOG.warn("caught exception when sending add shard to worker {}, {}.", (Object)this.worker.getIpPort(), (Object)e);
            return false;
        }
        StarStatus status = response.getStatus();
        if (status.getStatusCode() != StatusCode.OK) {
            LOG.warn("sending add shard to worker {} failed, {}:{}.", (Object)this.worker.getIpPort(), (Object)status.getStatusCode(), (Object)status.getErrorMsg());
            return false;
        }
        LOG.debug("sending add shard to worker {} succeed.", (Object)this.worker.getIpPort());
        return true;
    }

    public boolean removeShard(RemoveShardRequest request) {
        RemoveShardResponse response = null;
        try {
            this.prepareConnection();
            response = ((StarletGrpc.StarletBlockingStub)this.blockingStub.get().withDeadlineAfter((long)Config.GRPC_RPC_TIME_OUT_SEC, TimeUnit.SECONDS)).removeShard(request);
        }
        catch (Exception e) {
            LOG.warn("caught exception when sending remove shard to worker {}, {}.", (Object)this.worker.getIpPort(), (Object)e);
            return false;
        }
        StarStatus status = response.getStatus();
        if (status.getStatusCode() != StatusCode.OK) {
            LOG.warn("sending remove shard to worker {} failed, {}:{}.", (Object)this.worker.getIpPort(), (Object)status.getStatusCode(), (Object)status.getErrorMsg());
            return false;
        }
        LOG.debug("sending remove shard to worker {} succeed.", (Object)this.worker.getIpPort());
        return true;
    }

    private StarStatus handleGrpcException(StatusRuntimeException exception) {
        switch (exception.getStatus().getCode()) {
            case ABORTED: 
            case CANCELLED: 
            case DEADLINE_EXCEEDED: 
            case INTERNAL: 
            case RESOURCE_EXHAUSTED: 
            case UNAVAILABLE: 
            case UNIMPLEMENTED: 
            case UNKNOWN: {
                this.buildGrpcChannelAndStub();
                break;
            }
        }
        return StatusFactory.getStatus((StatusCode)StatusCode.GRPC, (String)exception.getMessage());
    }

    private void prepareConnection() {
        if (this.blockingStub.get() == null) {
            this.buildGrpcChannelAndStub();
        }
    }

    private void buildGrpcChannelAndStub() {
        ManagedChannel oldChannel = this.channel;
        this.channel = ManagedChannelBuilder.forTarget((String)this.worker.getIpPort()).maxInboundMessageSize(Config.GRPC_CHANNEL_MAX_MESSAGE_SIZE).usePlaintext().build();
        this.blockingStub.set(StarletGrpc.newBlockingStub((Channel)this.channel));
        if (oldChannel != null) {
            oldChannel.shutdown();
        }
    }
}

