/*
 * Decompiled with CFR 0.152.
 */
package com.staros.filestore;

import com.staros.filestore.FileStore;
import com.staros.proto.FilePathInfo;
import com.staros.proto.FileStoreInfo;
import com.staros.proto.FileStoreType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilePath {
    private static final Logger LOG = LogManager.getLogger(FilePath.class);
    public FileStore fs;
    public String suffix;

    public FilePath(FileStore fs, String suffix) {
        this.fs = fs;
        this.suffix = suffix;
    }

    public String fullPath() {
        if (this.fs.rootPath().endsWith("/")) {
            return String.format("%s%s", this.fs.rootPath(), this.suffix);
        }
        return String.format("%s/%s", this.fs.rootPath(), this.suffix);
    }

    public static FilePath fromFullPath(FileStore fs, String fullPath) {
        String suffix = fullPath.substring(fs.rootPath().length());
        if (suffix.startsWith("/")) {
            suffix = suffix.substring(1);
        }
        return new FilePath(fs, suffix);
    }

    public static FilePath fromProtobuf(FilePathInfo path) {
        FileStoreInfo fsInfo = path.getFsInfo();
        FileStoreType fsType = fsInfo.getFsType();
        FileStore fs = FileStore.fromProtobuf(fsInfo);
        return FilePath.fromFullPath(fs, path.getFullPath());
    }

    private FilePathInfo toProtobufInternal(boolean includeSecret) {
        FilePathInfo.Builder builder = FilePathInfo.newBuilder();
        if (includeSecret) {
            builder.setFsInfo(this.fs.toProtobuf());
        } else {
            builder.setFsInfo(this.fs.toDebugProtobuf());
        }
        builder.setFullPath(this.fullPath());
        return builder.build();
    }

    public FilePathInfo toProtobuf() {
        return this.toProtobufInternal(true);
    }

    public FilePathInfo toDebugProtobuf() {
        return this.toProtobufInternal(false);
    }
}

