/*
 * Decompiled with CFR 0.152.
 */
package com.staros.service;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.staros.exception.ExceptionCode;
import com.staros.exception.InvalidArgumentStarException;
import com.staros.exception.NotExistStarException;
import com.staros.exception.StarException;
import com.staros.filestore.FileStore;
import com.staros.filestore.FileStoreMgr;
import com.staros.journal.DummyJournalSystem;
import com.staros.journal.Journal;
import com.staros.journal.JournalSystem;
import com.staros.journal.StarMgrJournal;
import com.staros.proto.FileStoreInfo;
import com.staros.proto.FileStoreType;
import com.staros.proto.SectionType;
import com.staros.proto.ServiceInfo;
import com.staros.proto.ServiceManagerFileStoreMgrHeader;
import com.staros.proto.ServiceManagerImageData;
import com.staros.proto.ServiceManagerImageMetaFooter;
import com.staros.proto.ServiceManagerImageMetaHeader;
import com.staros.proto.ServiceManagerShardManagerHeader;
import com.staros.proto.ServiceState;
import com.staros.proto.ServiceTemplateInfo;
import com.staros.schedule.Scheduler;
import com.staros.section.Section;
import com.staros.section.SectionReader;
import com.staros.section.SectionWriter;
import com.staros.service.Service;
import com.staros.service.ServiceTemplate;
import com.staros.shard.ShardManager;
import com.staros.util.IdGenerator;
import com.staros.util.LockCloseable;
import com.staros.util.LogUtils;
import com.staros.util.Utils;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServiceManager {
    private static final Logger LOG = LogManager.getLogger(ServiceManager.class);
    private final Map<String, ServiceTemplate> serviceTemplates = new HashMap<String, ServiceTemplate>();
    private final Map<String, Service> services = new HashMap<String, Service>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final JournalSystem journalSystem;
    private final IdGenerator idGenerator;
    private Scheduler shardScheduler;

    public ServiceManager() {
        this(new DummyJournalSystem(), new IdGenerator(null));
    }

    public ServiceManager(JournalSystem journalSystem, IdGenerator idGenerator) {
        this.journalSystem = journalSystem;
        this.idGenerator = idGenerator;
    }

    public void registerService(String name, List<String> serviceComponents) throws StarException {
        try (LockCloseable lock = new LockCloseable(this.writeLock());){
            if (this.serviceTemplates.containsKey(name)) {
                throw new StarException(ExceptionCode.ALREADY_EXIST, String.format("service template %s already exist.", name));
            }
            ServiceTemplate serviceTemplate = new ServiceTemplate(name, serviceComponents);
            Journal journal = StarMgrJournal.logRegisterService(serviceTemplate);
            this.journalSystem.write(journal);
            this.serviceTemplates.put(name, serviceTemplate);
            LOG.info("service {} registered.", (Object)name);
        }
    }

    public void deregisterService(String name) throws StarException {
        try (LockCloseable lock = new LockCloseable(this.writeLock());){
            ServiceTemplate serviceTemplate = this.serviceTemplates.get(name);
            if (serviceTemplate == null) {
                throw new StarException(ExceptionCode.NOT_EXIST, String.format("service template %s not exist.", name));
            }
            for (Service service : this.services.values()) {
                if (!service.getServiceTemplateName().equals(name)) continue;
                throw new StarException(ExceptionCode.NOT_ALLOWED, String.format("service template %s has running service.", name));
            }
            Journal journal = StarMgrJournal.logDeregisterService(name);
            this.journalSystem.write(journal);
            this.serviceTemplates.remove(name);
            LOG.info("service {} deregistered.", (Object)name);
        }
    }

    public String bootstrapService(String serviceTemplateName, String serviceName) throws StarException {
        try (LockCloseable lock = new LockCloseable(this.writeLock());){
            Service service2;
            ServiceTemplate serviceTemplate = this.serviceTemplates.get(serviceTemplateName);
            if (serviceTemplate == null) {
                throw new StarException(ExceptionCode.NOT_EXIST, String.format("service template %s not exist.", serviceTemplateName));
            }
            for (Service service2 : this.services.values()) {
                if (!service2.getServiceName().equals(serviceName)) continue;
                throw new StarException(ExceptionCode.ALREADY_EXIST, String.format("service %s already exist.", serviceName));
            }
            String serviceId = UUID.randomUUID().toString();
            service2 = new Service(serviceTemplateName, serviceName, serviceId);
            Journal journal = StarMgrJournal.logBootstrapService(service2);
            this.journalSystem.write(journal);
            this.addService(service2);
            LOG.info("service {} bootstrapped.", (Object)serviceName);
            String string = serviceId;
            return string;
        }
    }

    public void shutdownService(String serviceId) throws StarException {
        try (LockCloseable lock = new LockCloseable(this.writeLock());){
            Service service = this.services.get(serviceId);
            if (service == null) {
                throw new StarException(ExceptionCode.NOT_EXIST, String.format("service %s not exist.", serviceId));
            }
            if (service.setState(ServiceState.SHUTDOWN)) {
                Journal journal = StarMgrJournal.logShutdownService(service);
                this.journalSystem.write(journal);
            }
            LOG.info("service {} shutdown.", (Object)serviceId);
        }
    }

    public ServiceInfo getServiceInfoById(String serviceId) throws StarException {
        try (LockCloseable lock = new LockCloseable(this.readLock());){
            Service service = this.services.get(serviceId);
            if (service == null) {
                throw new StarException(ExceptionCode.NOT_EXIST, String.format("service %s not exist.", serviceId));
            }
            ServiceInfo serviceInfo = service.toProtobuf();
            return serviceInfo;
        }
    }

    /*
     * Exception decompiling
     */
    public ServiceInfo getServiceInfoByName(String serviceName) throws StarException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getServiceTemplateCount() {
        try (LockCloseable lock = new LockCloseable(this.readLock());){
            int n = this.serviceTemplates.size();
            return n;
        }
    }

    public int getServiceCount() {
        try (LockCloseable lock = new LockCloseable(this.readLock());){
            int n = this.services.size();
            return n;
        }
    }

    public boolean existService(String serviceId) {
        return this.services.get(serviceId) != null;
    }

    public Lock readLock() {
        return this.lock.readLock();
    }

    public Lock writeLock() {
        return this.lock.writeLock();
    }

    public void setShardScheduler(Scheduler shardScheduler) {
        this.shardScheduler = shardScheduler;
    }

    private void addService(Service service) {
        assert (this.lock.isWriteLocked());
        String serviceId = service.getServiceId();
        if (this.services.put(serviceId, service) == null) {
            ShardManager shardManager = new ShardManager(serviceId, this.journalSystem, this.idGenerator, this.shardScheduler);
            service.setShardManager(shardManager);
            FileStoreMgr fileStoreMgr = new FileStoreMgr(serviceId, this.journalSystem);
            service.setFileStoreMgr(fileStoreMgr);
        }
    }

    public ShardManager getShardManager(String serviceId) {
        try (LockCloseable lock = new LockCloseable(this.readLock());){
            Service service = this.services.get(serviceId);
            if (service == null) {
                ShardManager shardManager = null;
                return shardManager;
            }
            ShardManager shardManager = service.getShardManager();
            return shardManager;
        }
    }

    public void replayRegisterService(ServiceTemplate serviceTemplate) {
        try (LockCloseable lock = new LockCloseable(this.writeLock());){
            if (this.serviceTemplates.containsKey(serviceTemplate.getServiceTemplateName())) {
                LogUtils.fatal(LOG, "service template {} already exist when replay register service, should not happen!", serviceTemplate.getServiceTemplateName());
            }
            this.serviceTemplates.put(serviceTemplate.getServiceTemplateName(), serviceTemplate);
        }
    }

    public void replayDeregisterService(String name) {
        try (LockCloseable lock = new LockCloseable(this.writeLock());){
            if (!this.serviceTemplates.containsKey(name)) {
                LOG.warn("service template {} not exist when replay deregister service, just ignore.", (Object)name);
                return;
            }
            for (Service service : this.services.values()) {
                if (!service.getServiceTemplateName().equals(name)) continue;
                LogUtils.fatal(LOG, "service template {} has running service when replay deregister service, should not happen!", name);
            }
            this.serviceTemplates.remove(name);
        }
    }

    public void replayBootstrapService(Service service) {
        try (LockCloseable lock = new LockCloseable(this.writeLock());){
            if (!this.serviceTemplates.containsKey(service.getServiceTemplateName())) {
                LogUtils.fatal(LOG, "service template {} not exist when replay bootstrap service, should not happen!", service.getServiceTemplateName());
            }
            if (this.services.containsKey(service.getServiceId())) {
                LogUtils.fatal(LOG, "service {} already exist when replay bootstrap service, should not happen!", service.getServiceId());
            }
            this.addService(service);
        }
    }

    public void replayShutdownService(Service service) {
        try (LockCloseable lock = new LockCloseable(this.writeLock());){
            if (!this.serviceTemplates.containsKey(service.getServiceTemplateName())) {
                LogUtils.fatal(LOG, "service template {} not exist when replay shutdown service, should not happen!", service.getServiceTemplateName());
            }
            if (!this.services.containsKey(service.getServiceId())) {
                LogUtils.fatal(LOG, "service {} not exist when replay shutdown service, should not happen!", service.getServiceId());
            }
            this.addService(service);
        }
    }

    public void replayUpdateFileStore(String serviceId, FileStoreInfo fsInfo) {
        try (LockCloseable ignored = new LockCloseable(this.readLock());){
            Service service = this.services.get(serviceId);
            if (service == null) {
                LogUtils.fatal(LOG, "service {} not exist when replay update file store, should not happen!", serviceId);
            }
            Preconditions.checkNotNull((Object)service);
            FileStoreMgr fsMgr = service.getFileStoreMgr();
            Preconditions.checkNotNull((Object)fsMgr);
            fsMgr.replayUpdateFileStore(fsInfo);
            this.updateShardManagerFileStoreSnapshotNoException(service, fsInfo.getFsKey());
        }
    }

    public void dumpMeta(OutputStream out) throws IOException {
        try (LockCloseable lk = new LockCloseable(this.readLock());){
            LOG.debug("start dump service manager meta data ...");
            ServiceManagerImageMetaHeader header = ServiceManagerImageMetaHeader.newBuilder().setDigestAlgorithm("MD5").setNumServiceTemplate(this.serviceTemplates.size()).setNumService(this.services.size()).build();
            header.writeDelimitedTo(out);
            DigestOutputStream mdStream = Utils.getDigestOutputStream(out, "MD5");
            try (SectionWriter writer = new SectionWriter((OutputStream)mdStream);){
                try (OutputStream stream = writer.appendSection(SectionType.SECTION_SERVICEMGR_TEMPLATE);){
                    this.dumpServiceTemplates(stream);
                }
                stream = writer.appendSection(SectionType.SECTION_SERVICEMGR_SERVICE);
                var9_13 = null;
                try {
                    this.dumpServices(stream);
                }
                catch (Throwable throwable) {
                    var9_13 = throwable;
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        if (var9_13 != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable) {
                                var9_13.addSuppressed(throwable);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
                for (String serviceId : this.services.keySet()) {
                    try (OutputStream stream = writer.appendSection(SectionType.SECTION_SERVICEMGR_SHARDMGR);){
                        this.dumpShardManager(stream, serviceId);
                    }
                    stream = writer.appendSection(SectionType.SECTION_SERVICEMGR_FILESTOREMGR);
                    var11_20 = null;
                    try {
                        this.dumpFileStoreMgr(stream, serviceId);
                    }
                    catch (Throwable throwable) {
                        var11_20 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (stream == null) continue;
                        if (var11_20 != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable) {
                                var11_20.addSuppressed(throwable);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
            }
            mdStream.flush();
            ServiceManagerImageMetaFooter.Builder footerBuilder = ServiceManagerImageMetaFooter.newBuilder();
            if (mdStream.getMessageDigest() != null) {
                footerBuilder.setChecksum(ByteString.copyFrom((byte[])mdStream.getMessageDigest().digest()));
            }
            footerBuilder.build().writeDelimitedTo(out);
            LOG.debug("end dump service manager meta data.");
        }
    }

    public void loadMeta(InputStream in) throws IOException {
        try (LockCloseable lk = new LockCloseable(this.writeLock());){
            LOG.debug("start load service manager meta data ...");
            ServiceManagerImageMetaHeader header = ServiceManagerImageMetaHeader.parseDelimitedFrom((InputStream)in);
            if (header == null) {
                throw new EOFException();
            }
            DigestInputStream mdStream = Utils.getDigestInputStream(in, header.getDigestAlgorithm());
            try (SectionReader reader = new SectionReader((InputStream)mdStream);){
                reader.forEach(x -> this.loadMetaFromSection((Section)x, header));
            }
            LOG.debug("end load service manager meta data.");
        }
    }

    private void loadMetaFromSection(Section section, ServiceManagerImageMetaHeader header) throws IOException {
        switch (section.getHeader().getSectionType()) {
            case SECTION_SERVICEMGR_TEMPLATE: {
                this.loadServiceTemplates(section.getStream(), header.getNumServiceTemplate());
                break;
            }
            case SECTION_SERVICEMGR_SERVICE: {
                this.loadServices(section.getStream(), header.getNumService());
                break;
            }
            case SECTION_SERVICEMGR_SHARDMGR: {
                this.loadShardManager(section.getStream());
                break;
            }
            case SECTION_SERVICEMGR_FILESTOREMGR: {
                this.loadFileStoreMgr(section.getStream());
                break;
            }
            default: {
                LOG.warn("Unknown section type:{} when loadMeta in ServiceManager, ignore it!", (Object)section.getHeader().getSectionType());
            }
        }
    }

    private void dumpServiceTemplates(OutputStream stream) throws IOException {
        ServiceManagerImageData.Builder builder = ServiceManagerImageData.newBuilder();
        this.serviceTemplates.values().forEach(x -> builder.addData(x.toProtobuf().toByteString()));
        builder.build().writeDelimitedTo(stream);
    }

    private void loadServiceTemplates(InputStream stream, int numTemplates) throws IOException {
        ServiceManagerImageData templates = ServiceManagerImageData.parseDelimitedFrom((InputStream)stream);
        if (templates == null) {
            throw new EOFException();
        }
        Preconditions.checkState((numTemplates == templates.getDataCount() ? 1 : 0) != 0);
        for (ByteString bs : templates.getDataList()) {
            ServiceTemplate tmpl = ServiceTemplate.fromProtobuf(ServiceTemplateInfo.parseFrom((ByteString)bs));
            this.serviceTemplates.put(tmpl.getServiceTemplateName(), tmpl);
        }
    }

    private void dumpServices(OutputStream stream) throws IOException {
        ServiceManagerImageData.Builder builder = ServiceManagerImageData.newBuilder();
        this.services.values().forEach(x -> builder.addData(x.toProtobuf().toByteString()));
        builder.build().writeDelimitedTo(stream);
    }

    private void loadServices(InputStream stream, int numServices) throws IOException {
        ServiceManagerImageData svcList = ServiceManagerImageData.parseDelimitedFrom((InputStream)stream);
        if (svcList == null) {
            throw new EOFException();
        }
        Preconditions.checkState((numServices == svcList.getDataCount() ? 1 : 0) != 0);
        for (ByteString bs : svcList.getDataList()) {
            Service svc = Service.fromProtobuf(ServiceInfo.parseFrom((ByteString)bs));
            this.addService(svc);
        }
    }

    private void dumpShardManager(OutputStream stream, String serviceId) throws IOException {
        ServiceManagerShardManagerHeader.newBuilder().setServiceId(serviceId).build().writeDelimitedTo(stream);
        ShardManager manager = this.getShardManager(serviceId);
        manager.dumpMeta(stream);
    }

    private void loadShardManager(InputStream stream) throws IOException {
        ServiceManagerShardManagerHeader header = ServiceManagerShardManagerHeader.parseDelimitedFrom((InputStream)stream);
        if (header == null) {
            throw new EOFException();
        }
        ShardManager manager = this.getShardManager(header.getServiceId());
        manager.loadMeta(stream);
    }

    public Set<String> getServiceIdSet() {
        try (LockCloseable lk = new LockCloseable(this.readLock());){
            HashSet<String> hashSet = new HashSet<String>(this.services.keySet());
            return hashSet;
        }
    }

    public void updateFileStore(String serviceId, FileStoreInfo fsInfo) {
        FileStoreMgr fsMgr = this.getFileStoreMgr(serviceId);
        Preconditions.checkNotNull((Object)fsMgr);
        FileStore fs = FileStore.fromProtobuf(fsInfo);
        Preconditions.checkNotNull((Object)fs);
        if (fs.type() == FileStoreType.INVALID) {
            throw new InvalidArgumentStarException(String.format("invalid file store type %s", fsInfo.getFsType()));
        }
        fsMgr.updateFileStore(fs);
        this.updateShardManagerFileStoreSnapshotNoException(this.services.get(serviceId), fs.key());
    }

    private void updateShardManagerFileStoreSnapshotNoException(Service service, String fsKey) {
        ShardManager shardManager = service.getShardManager();
        if (shardManager != null) {
            try {
                FileStoreMgr fsMgr = service.getFileStoreMgr();
                shardManager.updateDelegatedFileStoreSnapshot(fsMgr.getFileStore(fsKey));
            }
            catch (Throwable throwable) {
                LOG.warn("Fail to update shardManager delegatedFileStoreSnapshot fsKey={}. Error: ", (Object)fsKey, (Object)throwable);
            }
        }
    }

    public void dump(DataOutputStream out) throws IOException {
        try (LockCloseable lk = new LockCloseable(this.readLock());){
            String s;
            for (ServiceTemplate template : this.serviceTemplates.values()) {
                s = JsonFormat.printer().print((MessageOrBuilder)template.toProtobuf()) + "\n";
                out.writeBytes(s);
            }
            for (Service service : this.services.values()) {
                s = JsonFormat.printer().print((MessageOrBuilder)service.toProtobuf()) + "\n";
                out.writeBytes(s);
                service.getShardManager().dump(out);
                service.getFileStoreMgr().dump(out);
            }
        }
    }

    public FileStoreMgr getFileStoreMgr(String serviceId) throws StarException {
        try (LockCloseable lock = new LockCloseable(this.readLock());){
            if (!this.services.containsKey(serviceId)) {
                throw new NotExistStarException(String.format("service %s not exist.", serviceId));
            }
            Service service = this.services.get(serviceId);
            FileStoreMgr fileStoreMgr = service.getFileStoreMgr();
            return fileStoreMgr;
        }
    }

    private void dumpFileStoreMgr(OutputStream stream, String serviceId) throws IOException {
        ServiceManagerFileStoreMgrHeader.newBuilder().setServiceId(serviceId).build().writeDelimitedTo(stream);
        FileStoreMgr fsMgr = this.getFileStoreMgr(serviceId);
        fsMgr.dumpMeta(stream);
    }

    private void loadFileStoreMgr(InputStream stream) throws IOException {
        ServiceManagerFileStoreMgrHeader header = ServiceManagerFileStoreMgrHeader.parseDelimitedFrom((InputStream)stream);
        if (header == null) {
            throw new EOFException();
        }
        FileStoreMgr fsMgr = this.getFileStoreMgr(header.getServiceId());
        fsMgr.loadMeta(stream);
    }
}

