/*
 * Decompiled with CFR 0.152.
 */
package com.staros.util;

import com.staros.util.Config;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

public class LogConfig
extends XmlConfiguration {
    private static String xmlConfTemplate = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\n<Configuration status=\"info\" packages=\"com.staros.util\">\n  <Appenders>\n    <RollingFile name=\"starmgr\" fileName=\"${log_dir}/starmgr.log\" filePattern=\"${log_dir}/starmgr.log.${log_file_pattern}-%i\">\n      <PatternLayout charset=\"UTF-8\">\n        <Pattern>%d{yyyy-MM-dd HH:mm:ss,SSS} %p (%t|%tid) [%C{1}.%M():%L] %m%n</Pattern>\n      </PatternLayout>\n      <Policies>\n        <TimeBasedTriggeringPolicy/>\n        <SizeBasedTriggeringPolicy size=\"100MB\"/>\n      </Policies>\n    </RollingFile>\n  </Appenders>\n  <Loggers>\n    <Root level=\"${log_level}\">\n      <AppenderRef ref=\"starmgr\"/>\n    </Root>\n  </Loggers>\n</Configuration>";
    private static StrSubstitutor strSub;

    public static void initLogging() {
        String newXmlConfTemplate = xmlConfTemplate;
        String logDir = Config.LOG_DIR;
        String logLevel = Config.LOG_LEVEL;
        String logFilePattern = "%d{yyyyMMdd}";
        if (!(logLevel.equalsIgnoreCase("DEBUG") || logLevel.equalsIgnoreCase("INFO") || logLevel.equalsIgnoreCase("WARN") || logLevel.equalsIgnoreCase("ERROR"))) {
            System.out.println("log_level config error, should be DEBUG or INFO or WARN or ERROR.");
            System.exit(-1);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("log_dir", logDir);
        properties.put("log_level", logLevel);
        properties.put("log_file_pattern", logFilePattern);
        strSub = new StrSubstitutor((StrLookup)new Interpolator(properties));
        newXmlConfTemplate = strSub.replace(newXmlConfTemplate);
        ByteArrayInputStream bais = null;
        ConfigurationSource source = null;
        try {
            bais = new ByteArrayInputStream(newXmlConfTemplate.getBytes("UTF-8"));
            source = new ConfigurationSource((InputStream)bais);
        }
        catch (Exception e) {
            System.out.println(String.format("caught exception when config logging, %s.", e));
            System.exit(-1);
        }
        LogConfig config = new LogConfig(source);
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        context.start((Configuration)config);
    }

    public LogConfig(ConfigurationSource configSource) {
        super(LoggerContext.getContext(), configSource);
    }

    public StrSubstitutor getStrSubstitutor() {
        return strSub;
    }
}

