/*
 * Decompiled with CFR 0.152.
 */
package com.staros.manager;

import com.staros.exception.InvalidArgumentStarException;
import com.staros.exception.StarException;
import com.staros.manager.StarManager;
import com.staros.proto.AddFileStoreRequest;
import com.staros.proto.AddFileStoreResponse;
import com.staros.proto.AddWorkerRequest;
import com.staros.proto.AddWorkerResponse;
import com.staros.proto.AllocateFilePathRequest;
import com.staros.proto.AllocateFilePathResponse;
import com.staros.proto.BootstrapServiceRequest;
import com.staros.proto.BootstrapServiceResponse;
import com.staros.proto.CreateMetaGroupInfo;
import com.staros.proto.CreateMetaGroupRequest;
import com.staros.proto.CreateMetaGroupResponse;
import com.staros.proto.CreateShardGroupRequest;
import com.staros.proto.CreateShardGroupResponse;
import com.staros.proto.CreateShardRequest;
import com.staros.proto.CreateShardResponse;
import com.staros.proto.CreateWorkerGroupRequest;
import com.staros.proto.CreateWorkerGroupResponse;
import com.staros.proto.DeleteMetaGroupRequest;
import com.staros.proto.DeleteMetaGroupResponse;
import com.staros.proto.DeleteShardGroupRequest;
import com.staros.proto.DeleteShardGroupResponse;
import com.staros.proto.DeleteShardRequest;
import com.staros.proto.DeleteShardResponse;
import com.staros.proto.DeleteWorkerGroupRequest;
import com.staros.proto.DeleteWorkerGroupResponse;
import com.staros.proto.DeregisterServiceRequest;
import com.staros.proto.DeregisterServiceResponse;
import com.staros.proto.DumpRequest;
import com.staros.proto.DumpResponse;
import com.staros.proto.FilePathInfo;
import com.staros.proto.FileStoreInfo;
import com.staros.proto.FileStoreType;
import com.staros.proto.GetFileStoreRequest;
import com.staros.proto.GetFileStoreResponse;
import com.staros.proto.GetMetaGroupRequest;
import com.staros.proto.GetMetaGroupResponse;
import com.staros.proto.GetServiceRequest;
import com.staros.proto.GetServiceResponse;
import com.staros.proto.GetShardGroupRequest;
import com.staros.proto.GetShardGroupResponse;
import com.staros.proto.GetShardRequest;
import com.staros.proto.GetShardResponse;
import com.staros.proto.GetWorkerRequest;
import com.staros.proto.GetWorkerResponse;
import com.staros.proto.ListFileStoreRequest;
import com.staros.proto.ListFileStoreResponse;
import com.staros.proto.ListMetaGroupRequest;
import com.staros.proto.ListMetaGroupResponse;
import com.staros.proto.ListShardGroupRequest;
import com.staros.proto.ListShardGroupResponse;
import com.staros.proto.ListShardRequest;
import com.staros.proto.ListShardResponse;
import com.staros.proto.ListWorkerGroupRequest;
import com.staros.proto.ListWorkerGroupResponse;
import com.staros.proto.MetaGroupInfo;
import com.staros.proto.QueryMetaGroupStableRequest;
import com.staros.proto.QueryMetaGroupStableResponse;
import com.staros.proto.RegisterServiceRequest;
import com.staros.proto.RegisterServiceResponse;
import com.staros.proto.RemoveFileStoreRequest;
import com.staros.proto.RemoveFileStoreResponse;
import com.staros.proto.RemoveWorkerRequest;
import com.staros.proto.RemoveWorkerResponse;
import com.staros.proto.ServiceComponentInfo;
import com.staros.proto.ServiceInfo;
import com.staros.proto.ServiceTemplateInfo;
import com.staros.proto.ShardGroupInfo;
import com.staros.proto.ShardInfo;
import com.staros.proto.ShardInfoList;
import com.staros.proto.ShutdownServiceRequest;
import com.staros.proto.ShutdownServiceResponse;
import com.staros.proto.StarManagerGrpc;
import com.staros.proto.StarStatus;
import com.staros.proto.StatusCode;
import com.staros.proto.UpdateFileStoreRequest;
import com.staros.proto.UpdateFileStoreResponse;
import com.staros.proto.UpdateMetaGroupInfo;
import com.staros.proto.UpdateMetaGroupRequest;
import com.staros.proto.UpdateMetaGroupResponse;
import com.staros.proto.UpdateShardGroupRequest;
import com.staros.proto.UpdateShardGroupResponse;
import com.staros.proto.UpdateShardRequest;
import com.staros.proto.UpdateShardResponse;
import com.staros.proto.UpdateWorkerGroupRequest;
import com.staros.proto.UpdateWorkerGroupResponse;
import com.staros.proto.WorkerGroupDetailInfo;
import com.staros.proto.WorkerGroupSpec;
import com.staros.proto.WorkerHeartbeatRequest;
import com.staros.proto.WorkerHeartbeatResponse;
import com.staros.proto.WorkerInfo;
import com.staros.util.Config;
import com.staros.util.StatusFactory;
import com.staros.worker.WorkerGroup;
import io.grpc.stub.StreamObserver;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StarManagerService
extends StarManagerGrpc.StarManagerImplBase {
    private static final Logger LOG = LogManager.getLogger(StarManagerService.class);
    private StarManager starManager;

    public StarManagerService(StarManager manager) {
        this.starManager = manager;
    }

    public void registerService(RegisterServiceRequest request, StreamObserver<RegisterServiceResponse> responseObserver) {
        StarStatus status = StatusFactory.getStatus();
        RegisterServiceResponse.Builder response = RegisterServiceResponse.newBuilder();
        ServiceTemplateInfo template = request.getServiceTemplateInfo();
        String serviceTemplateName = template.getServiceTemplateName();
        if (serviceTemplateName.isEmpty()) {
            status = StatusFactory.getStatus((StatusCode)StatusCode.INVALID_ARGUMENT, (String)"empty service template name");
            response.setStatus(status);
        } else {
            ArrayList<String> serviceComponents = new ArrayList<String>();
            for (ServiceComponentInfo info : template.getServiceComponentInfoList()) {
                serviceComponents.add(info.getServiceComponentName());
            }
            try {
                this.starManager.registerService(serviceTemplateName, serviceComponents);
            }
            catch (Throwable e) {
                response.setStatus(this.handleException(e));
            }
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void deregisterService(DeregisterServiceRequest request, StreamObserver<DeregisterServiceResponse> responseObserver) {
        StarStatus status = StatusFactory.getStatus();
        DeregisterServiceResponse.Builder response = DeregisterServiceResponse.newBuilder();
        String serviceTemplateName = request.getServiceTemplateName();
        if (serviceTemplateName.isEmpty()) {
            status = StatusFactory.getStatus((StatusCode)StatusCode.INVALID_ARGUMENT, (String)"empty service template name");
            response.setStatus(status);
        } else {
            try {
                this.starManager.deregisterService(serviceTemplateName);
            }
            catch (Throwable e) {
                response.setStatus(this.handleException(e));
            }
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void bootstrapService(BootstrapServiceRequest request, StreamObserver<BootstrapServiceResponse> responseObserver) {
        StarStatus status = StatusFactory.getStatus();
        BootstrapServiceResponse.Builder response = BootstrapServiceResponse.newBuilder();
        String serviceTemplateName = request.getServiceTemplateName();
        String serviceName = request.getServiceName();
        if (serviceTemplateName.isEmpty() || serviceName.isEmpty()) {
            status = StatusFactory.getStatus((StatusCode)StatusCode.INVALID_ARGUMENT, (String)"empty service template name or service name");
            response.setStatus(status);
        } else {
            try {
                String serviceId = this.starManager.bootstrapService(serviceTemplateName, serviceName);
                response.setServiceId(serviceId);
            }
            catch (Throwable e) {
                response.setStatus(this.handleException(e));
            }
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void shutdownService(ShutdownServiceRequest request, StreamObserver<ShutdownServiceResponse> responseObserver) {
        StarStatus status = StatusFactory.getStatus();
        ShutdownServiceResponse.Builder response = ShutdownServiceResponse.newBuilder();
        String serviceId = request.getServiceId();
        if (serviceId.equals("")) {
            status = StatusFactory.getStatus((StatusCode)StatusCode.INVALID_ARGUMENT, (String)"invalid service id");
            response.setStatus(status);
        } else {
            try {
                this.starManager.shutdownService(serviceId);
            }
            catch (Throwable e) {
                response.setStatus(this.handleException(e));
            }
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void getService(GetServiceRequest request, StreamObserver<GetServiceResponse> responseObserver) {
        StarStatus status = StatusFactory.getStatus();
        GetServiceResponse.Builder response = GetServiceResponse.newBuilder();
        GetServiceRequest.IdentifierCase icase = request.getIdentifierCase();
        switch (icase) {
            case SERVICE_ID: {
                String serviceId = request.getServiceId();
                if (serviceId.isEmpty()) {
                    status = StatusFactory.getStatus((StatusCode)StatusCode.INVALID_ARGUMENT, (String)"invalid service id.");
                    response.setStatus(status);
                    break;
                }
                try {
                    ServiceInfo serviceInfo = this.starManager.getServiceInfoById(serviceId);
                    response.setServiceInfo(serviceInfo);
                }
                catch (Throwable e) {
                    response.setStatus(this.handleException(e));
                }
                break;
            }
            case SERVICE_NAME: {
                String serviceName = request.getServiceName();
                if (serviceName.isEmpty()) {
                    status = StatusFactory.getStatus((StatusCode)StatusCode.INVALID_ARGUMENT, (String)"invalid service name.");
                    response.setStatus(status);
                    break;
                }
                try {
                    ServiceInfo serviceInfo = this.starManager.getServiceInfoByName(serviceName);
                    response.setServiceInfo(serviceInfo);
                }
                catch (Throwable e) {
                    response.setStatus(this.handleException(e));
                }
                break;
            }
            case IDENTIFIER_NOT_SET: {
                status = StatusFactory.getStatus((StatusCode)StatusCode.INVALID_ARGUMENT, (String)"service id or service name not set.");
                response.setStatus(status);
            }
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void createWorkerGroup(CreateWorkerGroupRequest request, StreamObserver<CreateWorkerGroupResponse> responseObserver) {
        CreateWorkerGroupResponse.Builder response = CreateWorkerGroupResponse.newBuilder();
        try {
            long groupId = this.starManager.createWorkerGroup(request.getServiceId(), request.getOwner(), request.getSpec(), request.getLabelsMap(), request.getPropertiesMap());
            WorkerGroup group = this.starManager.getWorkerManager().getWorkerGroup(request.getServiceId(), groupId);
            response.setStatus(StatusFactory.getStatus()).setGroupInfo(group.toProtobuf());
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void listWorkerGroup(ListWorkerGroupRequest request, StreamObserver<ListWorkerGroupResponse> responseObserver) {
        ListWorkerGroupResponse.Builder response = ListWorkerGroupResponse.newBuilder();
        try {
            List<WorkerGroupDetailInfo> groups = this.starManager.listWorkerGroups(request.getServiceId(), request.getGroupIdsList(), request.getFilterLabelsMap(), request.getIncludeWorkersInfo());
            response.setStatus(StatusFactory.getStatus()).addAllGroupsInfo(groups);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void updateWorkerGroup(UpdateWorkerGroupRequest request, StreamObserver<UpdateWorkerGroupResponse> responseObserver) {
        UpdateWorkerGroupResponse.Builder respBuilder = UpdateWorkerGroupResponse.newBuilder();
        try {
            WorkerGroupSpec spec = null;
            if (request.hasSpec()) {
                spec = request.getSpec();
            }
            long groupId = request.getGroupId();
            this.starManager.updateWorkerGroup(request.getServiceId(), request.getGroupId(), spec, request.getLabelsMap(), request.getPropertiesMap());
            WorkerGroup group = this.starManager.getWorkerManager().getWorkerGroup(request.getServiceId(), groupId);
            respBuilder.setStatus(StatusFactory.getStatus()).setGroupInfo(group.toProtobuf());
        }
        catch (Throwable e) {
            respBuilder.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)respBuilder.build());
        responseObserver.onCompleted();
    }

    public void deleteWorkerGroup(DeleteWorkerGroupRequest request, StreamObserver<DeleteWorkerGroupResponse> responseObserver) {
        StarStatus status = StatusFactory.getStatus();
        try {
            this.starManager.deleteWorkerGroup(request.getServiceId(), request.getGroupId());
        }
        catch (Throwable e) {
            status = this.handleException(e);
        }
        responseObserver.onNext((Object)DeleteWorkerGroupResponse.newBuilder().setStatus(status).build());
        responseObserver.onCompleted();
    }

    public void addWorker(AddWorkerRequest request, StreamObserver<AddWorkerResponse> responseObserver) {
        AddWorkerResponse.Builder response = AddWorkerResponse.newBuilder();
        String serviceId = request.getServiceId();
        long groupId = request.getGroupId();
        String workerAddress = request.getIpPort();
        StarStatus status = this.validateWorkerAddress(workerAddress);
        if (status.getStatusCode() == StatusCode.OK) {
            try {
                this.checkWorkerGroupId(groupId);
                long workerId = this.starManager.addWorker(serviceId, groupId, workerAddress);
                response.setWorkerId(workerId);
            }
            catch (Throwable e) {
                response.setStatus(this.handleException(e));
            }
        } else {
            LOG.warn("Invalid worker address: {}", (Object)workerAddress);
            response.setStatus(status);
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void removeWorker(RemoveWorkerRequest request, StreamObserver<RemoveWorkerResponse> responseObserver) {
        RemoveWorkerResponse.Builder response = RemoveWorkerResponse.newBuilder();
        String serviceId = request.getServiceId();
        long groupId = request.getGroupId();
        long workerId = request.getWorkerId();
        try {
            this.checkWorkerGroupId(groupId);
            this.starManager.removeWorker(serviceId, groupId, workerId);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void getWorker(GetWorkerRequest request, StreamObserver<GetWorkerResponse> responseObserver) {
        StarStatus status = StatusFactory.getStatus();
        GetWorkerResponse.Builder response = GetWorkerResponse.newBuilder();
        String serviceId = request.getServiceId();
        GetWorkerRequest.IdentifierCase icase = request.getIdentifierCase();
        switch (icase) {
            case WORKER_ID: {
                long workerId = request.getWorkerId();
                if (workerId == 0L) {
                    status = StatusFactory.getStatus((StatusCode)StatusCode.INVALID_ARGUMENT, (String)"invalid worker id.");
                    response.setStatus(status);
                    break;
                }
                try {
                    WorkerInfo workerInfo = this.starManager.getWorkerInfo(serviceId, workerId);
                    response.setWorkerInfo(workerInfo);
                }
                catch (Throwable e) {
                    response.setStatus(this.handleException(e));
                }
                break;
            }
            case IP_PORT: {
                String ipPort = request.getIpPort();
                if (ipPort.isEmpty()) {
                    status = StatusFactory.getStatus((StatusCode)StatusCode.INVALID_ARGUMENT, (String)"invalid worker ip port.");
                    response.setStatus(status);
                    break;
                }
                try {
                    WorkerInfo workerInfo = this.starManager.getWorkerInfo(serviceId, ipPort);
                    response.setWorkerInfo(workerInfo);
                }
                catch (Throwable e) {
                    response.setStatus(this.handleException(e));
                }
                break;
            }
            case IDENTIFIER_NOT_SET: {
                status = StatusFactory.getStatus((StatusCode)StatusCode.INVALID_ARGUMENT, (String)"worker id or worker ip port not set.");
                response.setStatus(status);
            }
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void createShard(CreateShardRequest request, StreamObserver<CreateShardResponse> responseObserver) {
        LOG.debug("receive create shard request, {}", (Object)request);
        CreateShardResponse.Builder response = CreateShardResponse.newBuilder();
        String serviceId = request.getServiceId();
        List createShardInfos = request.getCreateShardInfosList();
        try {
            List<ShardInfo> shardInfos = this.starManager.createShard(serviceId, createShardInfos);
            response.addAllShardInfo(shardInfos);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void deleteShard(DeleteShardRequest request, StreamObserver<DeleteShardResponse> responseObserver) {
        LOG.debug("receive delete shard request, {}", (Object)request);
        DeleteShardResponse.Builder response = DeleteShardResponse.newBuilder();
        String serviceId = request.getServiceId();
        List shardIds = request.getShardIdList();
        try {
            this.starManager.deleteShard(serviceId, shardIds);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void updateShard(UpdateShardRequest request, StreamObserver<UpdateShardResponse> responseObserver) {
        UpdateShardResponse.Builder response = UpdateShardResponse.newBuilder();
        String serviceId = request.getServiceId();
        List updateShardInfos = request.getUpdateShardInfosList();
        try {
            this.starManager.updateShard(serviceId, updateShardInfos);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void getShard(GetShardRequest request, StreamObserver<GetShardResponse> responseObserver) {
        LOG.debug("receive get shard request, {}", (Object)request);
        GetShardResponse.Builder response = GetShardResponse.newBuilder();
        String serviceId = request.getServiceId();
        List shardIds = request.getShardIdList();
        try {
            List<ShardInfo> shardInfos = this.starManager.getShardInfo(serviceId, shardIds, request.getWorkerGroupId());
            response.addAllShardInfo(shardInfos);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void listShard(ListShardRequest request, StreamObserver<ListShardResponse> responseObserver) {
        LOG.debug("receive list shard request, {}", (Object)request);
        ListShardResponse.Builder response = ListShardResponse.newBuilder();
        String serviceId = request.getServiceId();
        List groupIds = request.getGroupIdsList();
        try {
            List<ShardInfoList> shardInfoLists = this.starManager.listShardInfo(serviceId, groupIds, request.getWorkerGroupId(), request.getWithoutReplicaInfo());
            response.addAllShardInfoLists(shardInfoLists);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void createShardGroup(CreateShardGroupRequest request, StreamObserver<CreateShardGroupResponse> responseObserver) {
        LOG.debug("receive create shard group request, {}", (Object)request);
        CreateShardGroupResponse.Builder response = CreateShardGroupResponse.newBuilder();
        String serviceId = request.getServiceId();
        List createShardGroupInfos = request.getCreateShardGroupInfosList();
        try {
            List<ShardGroupInfo> shardGroupInfos = this.starManager.createShardGroup(serviceId, createShardGroupInfos);
            response.addAllShardGroupInfos(shardGroupInfos);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void deleteShardGroup(DeleteShardGroupRequest request, StreamObserver<DeleteShardGroupResponse> responseObserver) {
        LOG.debug("receive delete shard group request, {}", (Object)request);
        DeleteShardGroupResponse.Builder response = DeleteShardGroupResponse.newBuilder();
        try {
            this.starManager.deleteShardGroup(request.getServiceId(), request.getDeleteInfo().getGroupIdsList(), request.getDeleteInfo().getCascadeDeleteShard());
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void updateShardGroup(UpdateShardGroupRequest request, StreamObserver<UpdateShardGroupResponse> responseObserver) {
        UpdateShardGroupResponse.Builder response = UpdateShardGroupResponse.newBuilder();
        String serviceId = request.getServiceId();
        List updateShardGroupInfos = request.getUpdateShardGroupInfosList();
        try {
            this.starManager.updateShardGroup(serviceId, updateShardGroupInfos);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void listShardGroup(ListShardGroupRequest request, StreamObserver<ListShardGroupResponse> responseObserver) {
        LOG.debug("receive list shard group request, {}", (Object)request);
        ListShardGroupResponse.Builder response = ListShardGroupResponse.newBuilder();
        String serviceId = request.getServiceId();
        boolean includeAnonymousGroup = request.getIncludeAnonymousGroup();
        long startGroupId = request.getStartGroupId();
        try {
            Pair<List<ShardGroupInfo>, Long> pair = this.starManager.listShardGroupInfo(serviceId, includeAnonymousGroup, startGroupId);
            response.addAllShardGroupInfos((Iterable)pair.getKey());
            response.setNextGroupId(((Long)pair.getValue()).longValue());
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void getShardGroup(GetShardGroupRequest request, StreamObserver<GetShardGroupResponse> responseObserver) {
        LOG.debug("receive get shard group request, {}", (Object)request);
        GetShardGroupResponse.Builder response = GetShardGroupResponse.newBuilder();
        String serviceId = request.getServiceId();
        List shardGroupIds = request.getShardGroupIdList();
        try {
            List<ShardGroupInfo> shardGroupInfos = this.starManager.getShardGroupInfo(serviceId, shardGroupIds);
            response.addAllShardGroupInfo(shardGroupInfos);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void createMetaGroup(CreateMetaGroupRequest request, StreamObserver<CreateMetaGroupResponse> responseObserver) {
        LOG.debug("receive create meta group request, {}", (Object)request);
        CreateMetaGroupResponse.Builder response = CreateMetaGroupResponse.newBuilder();
        String serviceId = request.getServiceId();
        CreateMetaGroupInfo createMetaGroupInfo = request.getCreateMetaGroupInfo();
        try {
            response.setMetaGroupInfo(this.starManager.createMetaGroup(serviceId, createMetaGroupInfo));
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void deleteMetaGroup(DeleteMetaGroupRequest request, StreamObserver<DeleteMetaGroupResponse> responseObserver) {
        LOG.debug("receive delete meta group request, {}", (Object)request);
        DeleteMetaGroupResponse.Builder response = DeleteMetaGroupResponse.newBuilder();
        String serviceId = request.getServiceId();
        long metaGroupId = request.getDeleteMetaGroupInfo().getMetaGroupId();
        try {
            this.starManager.deleteMetaGroup(serviceId, metaGroupId);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void updateMetaGroup(UpdateMetaGroupRequest request, StreamObserver<UpdateMetaGroupResponse> responseObserver) {
        LOG.debug("receive update meta group request, {}", (Object)request);
        UpdateMetaGroupResponse.Builder response = UpdateMetaGroupResponse.newBuilder();
        String serviceId = request.getServiceId();
        UpdateMetaGroupInfo updateMetaGroupInfo = request.getUpdateMetaGroupInfo();
        try {
            this.starManager.updateMetaGroup(serviceId, updateMetaGroupInfo);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void getMetaGroup(GetMetaGroupRequest request, StreamObserver<GetMetaGroupResponse> responseObserver) {
        LOG.debug("receive get meta group request, {}", (Object)request);
        GetMetaGroupResponse.Builder response = GetMetaGroupResponse.newBuilder();
        String serviceId = request.getServiceId();
        long metaGroupId = request.getMetaGroupId();
        try {
            response.setMetaGroupInfo(this.starManager.getMetaGroupInfo(serviceId, metaGroupId));
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void listMetaGroup(ListMetaGroupRequest request, StreamObserver<ListMetaGroupResponse> responseObserver) {
        LOG.debug("receive list meta group request, {}", (Object)request);
        ListMetaGroupResponse.Builder response = ListMetaGroupResponse.newBuilder();
        String serviceId = request.getServiceId();
        try {
            List<MetaGroupInfo> metaGroupInfos = this.starManager.listMetaGroupInfo(serviceId);
            response.addAllMetaGroupInfos(metaGroupInfos);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void queryMetaGroupStable(QueryMetaGroupStableRequest request, StreamObserver<QueryMetaGroupStableResponse> responseObserver) {
        QueryMetaGroupStableResponse.Builder response = QueryMetaGroupStableResponse.newBuilder();
        try {
            boolean isStable = this.starManager.queryMetaGroupStable(request.getServiceId(), request.getMetaGroupId(), request.getWorkerGroupId());
            response.setIsStable(isStable);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void workerHeartbeat(WorkerHeartbeatRequest request, StreamObserver<WorkerHeartbeatResponse> responseObserver) {
        LOG.debug("receive worker heartbeat request, {}", (Object)request);
        WorkerHeartbeatResponse.Builder response = WorkerHeartbeatResponse.newBuilder();
        String serviceId = request.getServiceId();
        long workerId = request.getWorkerId();
        long startTime = request.getStartTime();
        Map workerProperties = request.getWorkerPropertiesMap();
        List shardIds = request.getShardIdsList();
        List shardReportInfos = request.getShardReportInfosList();
        try {
            this.starManager.processWorkerHeartbeat(serviceId, workerId, startTime, workerProperties, shardIds, shardReportInfos);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void allocateFilePath(AllocateFilePathRequest request, StreamObserver<AllocateFilePathResponse> responseObserver) {
        LOG.debug("receive allocate file path request {}", (Object)request);
        AllocateFilePathResponse.Builder response = AllocateFilePathResponse.newBuilder();
        String serviceId = request.getServiceId();
        FileStoreType fsType = request.getFsType();
        String suffix = request.getSuffix();
        String fsKey = request.getFsKey();
        try {
            FilePathInfo pathInfo = this.starManager.allocateFilePath(serviceId, fsType, suffix, fsKey);
            response.setPathInfo(pathInfo);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void addFileStore(AddFileStoreRequest request, StreamObserver<AddFileStoreResponse> responseObserver) {
        LOG.debug("receive add file store request, {}", (Object)request);
        AddFileStoreResponse.Builder response = AddFileStoreResponse.newBuilder();
        FileStoreInfo fsInfo = request.getFsInfo();
        String serviceId = request.getServiceId();
        try {
            String fsKey = this.starManager.addFileStore(serviceId, fsInfo);
            response.setFsKey(fsKey);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void removeFileStore(RemoveFileStoreRequest request, StreamObserver<RemoveFileStoreResponse> responseObserver) {
        LOG.debug("receive remove file store request {}", (Object)request);
        RemoveFileStoreResponse.Builder response = RemoveFileStoreResponse.newBuilder();
        String fsName = request.getFsName();
        String fsKey = request.getFsKey();
        String serviceId = request.getServiceId();
        try {
            this.starManager.removeFileStore(serviceId, fsKey, fsName);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void listFileStore(ListFileStoreRequest request, StreamObserver<ListFileStoreResponse> responseObserver) {
        LOG.debug("receive list file store request {}", (Object)request);
        ListFileStoreResponse.Builder response = ListFileStoreResponse.newBuilder();
        try {
            List<FileStoreInfo> fsInfos = this.starManager.listFileStore(request.getServiceId(), request.getFsType());
            response.addAllFsInfos(fsInfos);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void updateFileStore(UpdateFileStoreRequest request, StreamObserver<UpdateFileStoreResponse> responseObserver) {
        LOG.debug("receive update storage request, {}", (Object)request);
        UpdateFileStoreResponse.Builder response = UpdateFileStoreResponse.newBuilder();
        FileStoreInfo fsInfo = request.getFsInfo();
        String serviceId = request.getServiceId();
        try {
            this.starManager.updateFileStore(serviceId, fsInfo);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void getFileStore(GetFileStoreRequest request, StreamObserver<GetFileStoreResponse> responseObserver) {
        GetFileStoreResponse.Builder response = GetFileStoreResponse.newBuilder();
        String serviceId = request.getServiceId();
        String fsName = request.getFsName();
        String fsKey = request.getFsKey();
        try {
            FileStoreInfo fsInfo = this.starManager.getFileStore(serviceId, fsName, fsKey);
            response.setFsInfo(fsInfo);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void dump(DumpRequest request, StreamObserver<DumpResponse> responseObserver) {
        StarStatus status = StatusFactory.getStatus();
        DumpResponse.Builder response = DumpResponse.newBuilder();
        try {
            String location = this.starManager.dump();
            response.setLocation(location);
        }
        catch (Throwable e) {
            response.setStatus(this.handleException(e));
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    private StarStatus validateWorkerAddress(String workerAddress) {
        StarStatus status = StatusFactory.getStatus((StatusCode)StatusCode.INVALID_ARGUMENT, (String)"invalid host port");
        String[] array = workerAddress.split(":");
        if (array.length != 2 || array[0].isEmpty() || array[1].isEmpty()) {
            return status;
        }
        int port = Integer.parseInt(array[1]);
        InetSocketAddress address = new InetSocketAddress(array[0], port);
        if (port <= 0 || address.isUnresolved()) {
            return status;
        }
        return StatusFactory.getStatus();
    }

    private void checkWorkerGroupId(long groupId) {
        if (groupId == 0L && !Config.ENABLE_ZERO_WORKER_GROUP_COMPATIBILITY) {
            throw new InvalidArgumentStarException("Worker group id not set!");
        }
    }

    private StarStatus handleException(Throwable throwable) {
        if (throwable instanceof StarException) {
            return ((StarException)throwable).toStatus();
        }
        return StatusFactory.getStatus((StatusCode)StatusCode.INTERNAL, (String)throwable.getMessage());
    }
}

