/*
 * Decompiled with CFR 0.152.
 */
package com.staros.credential;

import com.staros.credential.AwsCredential;
import com.staros.proto.AwsCredentialType;
import com.staros.proto.AwsSimpleCredentialInfo;

public class AwsSimpleCredential
implements AwsCredential {
    private String accessKey;
    private String accessKeySecret;
    private boolean encrypted;

    public AwsSimpleCredential(String accessKey, String accessKeySecret) {
        this.accessKey = accessKey;
        this.accessKeySecret = accessKeySecret;
        this.encrypted = false;
    }

    public AwsSimpleCredential(String accessKey, String accessKeySecret, boolean encrypted) {
        this.accessKey = accessKey;
        this.accessKeySecret = accessKeySecret;
        this.encrypted = encrypted;
    }

    @Override
    public AwsCredentialType type() {
        return AwsCredentialType.SIMPLE;
    }

    public AwsSimpleCredentialInfo toProtobuf() {
        AwsSimpleCredentialInfo.Builder builder = AwsSimpleCredentialInfo.newBuilder();
        builder.setAccessKey(this.accessKey);
        builder.setAccessKeySecret(this.accessKeySecret);
        builder.setEncrypted(this.encrypted);
        return builder.build();
    }

    public static AwsSimpleCredential fromProtobuf(AwsSimpleCredentialInfo credentialInfo) {
        String ak = credentialInfo.getAccessKey();
        String sk = credentialInfo.getAccessKeySecret();
        boolean encrypted = credentialInfo.getEncrypted();
        return new AwsSimpleCredential(ak, sk, encrypted);
    }
}

