/*
 * Decompiled with CFR 0.152.
 */
package com.staros.provisioner;

import com.staros.provisioner.StarProvisionServer;
import com.staros.util.Config;
import com.staros.util.LogConfig;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StarProvisionServerMain {
    private static final Logger LOG = LogManager.getLogger(StarProvisionServerMain.class);

    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length >= 1) {
            String confFile = args[0];
            new Config().init(confFile);
        }
        LogConfig.initLogging();
        if (args.length >= 2) {
            LOG.info("Use BUILTIN_PROVISION_SERVER_DATA_DIR = {} ...", (Object)args[1]);
            Config.BUILTIN_PROVISION_SERVER_DATA_DIR = args[1];
        }
        int port = Config.STARMGR_RPC_PORT;
        ServerBuilder builder = ServerBuilder.forPort((int)port);
        StarProvisionServer provisionServer = new StarProvisionServer();
        StarProvisionServer.getServices(provisionServer).forEach(arg_0 -> ((ServerBuilder)builder).addService(arg_0));
        Server server = builder.build();
        String msg = "Starting StarProvisionServer on port " + port + " ...";
        System.err.println(msg);
        LOG.info(msg);
        server.start();
        server.awaitTermination();
    }
}

