/*
 * Decompiled with CFR 0.152.
 */
package com.staros.replica;

import com.staros.proto.ReplicaInfo;
import com.staros.proto.ReplicaRole;
import com.staros.proto.ReplicaState;
import com.staros.proto.WorkerInfo;

public class Replica {
    private final long workerId;
    private ReplicaRole role;
    private ReplicaState replicaState;
    private long replicaStateTimestamp;

    public Replica(long workerId) {
        this.workerId = workerId;
        this.role = ReplicaRole.PRIMARY;
        this.replicaState = ReplicaState.REPLICA_OK;
        this.replicaStateTimestamp = System.currentTimeMillis();
    }

    public Replica(long workerId, ReplicaState state, long replicaStateTimestamp) {
        this.workerId = workerId;
        this.role = ReplicaRole.PRIMARY;
        this.replicaState = state;
        this.replicaStateTimestamp = replicaStateTimestamp;
    }

    public ReplicaRole getRole() {
        return this.role;
    }

    public void setRole(ReplicaRole role) {
        this.role = role;
    }

    public long getWorkerId() {
        return this.workerId;
    }

    public ReplicaState getState() {
        return this.replicaState;
    }

    public void setReplicaState(ReplicaState state) {
        if (this.replicaState == state) {
            return;
        }
        this.replicaState = state;
        this.replicaStateTimestamp = System.currentTimeMillis();
    }

    public boolean stateTimedOut(long timeoutMs) {
        return this.replicaStateTimestamp + timeoutMs < System.currentTimeMillis();
    }

    public ReplicaInfo toProtobuf() {
        ReplicaInfo.Builder builder = ReplicaInfo.newBuilder().setWorkerInfo(WorkerInfo.newBuilder().setWorkerId(this.workerId).build()).setReplicaRole(this.role).setReplicaState(this.replicaState).setReplicaStateTimestamp(this.replicaStateTimestamp);
        return builder.build();
    }

    public static Replica fromProtobuf(ReplicaInfo info) {
        Replica replica = new Replica(info.getWorkerInfo().getWorkerId(), info.getReplicaState(), info.getReplicaStateTimestamp());
        replica.setRole(info.getReplicaRole());
        return replica;
    }
}

