/*
 * Decompiled with CFR 0.152.
 */
package com.staros.shard;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.staros.filecache.FileCache;
import com.staros.filestore.FilePath;
import com.staros.filestore.FileStore;
import com.staros.proto.AddShardInfo;
import com.staros.proto.FileStoreInfo;
import com.staros.proto.ReplicaInfo;
import com.staros.proto.ReplicaState;
import com.staros.proto.ShardInfo;
import com.staros.proto.ShardState;
import com.staros.replica.Replica;
import com.staros.util.LockCloseable;
import com.staros.util.Text;
import com.staros.util.Writable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Shard
implements Writable {
    private static final Logger LOG = LogManager.getLogger(Shard.class);
    private final String serviceId;
    private List<Long> groupIds;
    private final long shardId;
    private ShardState state;
    private FilePath filePath;
    private FileCache fileCache;
    @Deprecated
    private int expectedReplicaNum;
    private ImmutableList<Replica> replicas;
    private Map<String, String> properties;
    private final ReentrantReadWriteLock lock;

    public Shard(String serviceId, List<Long> groupIds, long shardId) {
        this(serviceId, groupIds, shardId, null, null);
    }

    public Shard(String serviceId, List<Long> groupIds, long shardId, FilePath filePath, FileCache fileCache) {
        this.serviceId = serviceId;
        this.groupIds = Collections.unmodifiableList(new ArrayList<Long>(groupIds));
        this.shardId = shardId;
        this.state = ShardState.NORMAL;
        this.filePath = filePath;
        this.fileCache = fileCache;
        this.expectedReplicaNum = 1;
        this.replicas = ImmutableList.of();
        this.properties = new HashMap<String, String>();
        this.lock = new ReentrantReadWriteLock();
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public List<Long> getGroupIds() {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            List<Long> list = this.groupIds;
            return list;
        }
    }

    public long getShardId() {
        return this.shardId;
    }

    public boolean joinGroup(long groupId) {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.writeLock());){
            if (this.groupIds.contains(groupId)) {
                boolean bl = false;
                return bl;
            }
            ArrayList<Long> newGroup = new ArrayList<Long>(this.groupIds);
            newGroup.add(groupId);
            this.groupIds = Collections.unmodifiableList(newGroup);
            boolean bl = true;
            return bl;
        }
    }

    public boolean quitGroup(long groupId) {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.writeLock());){
            if (!this.groupIds.contains(groupId)) {
                boolean bl = false;
                return bl;
            }
            ArrayList<Long> newGroup = new ArrayList<Long>(this.groupIds);
            newGroup.remove(groupId);
            this.groupIds = Collections.unmodifiableList(newGroup);
            boolean bl = true;
            return bl;
        }
    }

    public ShardState getState() {
        return this.state;
    }

    public void setState(ShardState state) {
        this.state = state;
    }

    public FilePath getFilePath() {
        return this.filePath;
    }

    public void setFileCacheEnable(boolean enableCache) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            this.fileCache.setFileCacheEnable(enableCache);
        }
    }

    public void setFilePath(FilePath path) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            this.filePath = path;
        }
    }

    public FileCache getFileCache() {
        return this.fileCache;
    }

    public void setReplicas(List<Replica> replicas) {
        this.replicas = ImmutableList.copyOf(replicas);
    }

    public List<Long> getReplicaWorkerIds() {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            List<Long> list = this.replicas.stream().map(Replica::getWorkerId).collect(Collectors.toList());
            return list;
        }
    }

    public int getReplicaSize() {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            int n = this.replicas.size();
            return n;
        }
    }

    public ImmutableList<Replica> getReplica() {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            ImmutableList<Replica> immutableList = this.replicas;
            return immutableList;
        }
    }

    @Deprecated
    public int getExpectedReplicaNum() {
        return this.expectedReplicaNum;
    }

    @Deprecated
    public void setExpectedReplicaNum(int expectedReplicaNum) {
        this.expectedReplicaNum = expectedReplicaNum;
    }

    public boolean hasReplica(long workerId) {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            boolean bl = this.replicas.stream().anyMatch(x -> x.getWorkerId() == workerId);
            return bl;
        }
    }

    public boolean addReplica(long workerId) {
        return this.addReplica(workerId, ReplicaState.REPLICA_OK);
    }

    public boolean addReplica(long workerId, ReplicaState state) {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.writeLock());){
            if (this.replicas.stream().anyMatch(x -> x.getWorkerId() == workerId)) {
                boolean bl = false;
                return bl;
            }
            this.replicas = ImmutableList.builder().addAll(this.replicas).add((Object)new Replica(workerId, state, System.currentTimeMillis())).build();
            boolean bl = true;
            return bl;
        }
    }

    public boolean removeReplica(long workerId) {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.writeLock());){
            if (this.replicas.stream().noneMatch(x -> x.getWorkerId() == workerId)) {
                boolean bl = false;
                return bl;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            this.replicas.forEach(x -> {
                if (x.getWorkerId() != workerId) {
                    builder.add(x);
                }
            });
            this.replicas = builder.build();
            boolean bl = true;
            return bl;
        }
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public ShardInfo toProtobufInternal(boolean includeSecret, boolean withoutReplicaInfo) {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            ShardInfo.Builder builder = ShardInfo.newBuilder();
            builder.setServiceId(this.serviceId);
            builder.addAllGroupIds(this.groupIds);
            builder.setShardId(this.shardId);
            builder.setShardState(this.state);
            if (this.filePath != null) {
                if (includeSecret) {
                    builder.setFilePath(this.filePath.toProtobuf());
                } else {
                    builder.setFilePath(this.filePath.toDebugProtobuf());
                }
            }
            if (this.fileCache != null) {
                builder.setFileCache(this.fileCache.toProtobuf());
            }
            if (!withoutReplicaInfo) {
                for (Replica replica : this.replicas) {
                    builder.addReplicaInfo(replica.toProtobuf());
                }
            }
            builder.putAllShardProperties(this.properties);
            builder.setExpectedReplicaNum(this.expectedReplicaNum);
            builder.setHashCode(this.hashCode());
            UnmodifiableIterator unmodifiableIterator = builder.build();
            return unmodifiableIterator;
        }
    }

    public ShardInfo toProtobuf() {
        return this.toProtobufInternal(true, false);
    }

    public ShardInfo toDebugProtobuf() {
        return this.toProtobufInternal(false, false);
    }

    public ShardInfo toProtobuf(boolean withoutReplicaInfo) {
        return this.toProtobufInternal(true, withoutReplicaInfo);
    }

    public AddShardInfo getAddShardInfo() {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            AddShardInfo addShardInfo = AddShardInfo.newBuilder().setShardId(this.shardId).setFileCacheInfo(this.fileCache.toProtobuf()).setFilePathInfo(this.filePath.toProtobuf()).putAllShardProperties(this.properties).setHashCode(this.hashCode()).build();
            return addShardInfo;
        }
    }

    public boolean updateFileStore(FileStoreInfo fsInfo) {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.writeLock());){
            FileStore fileStore = this.filePath.fs;
            if (!fsInfo.getFsKey().equals(fileStore.key())) {
                boolean bl = false;
                return bl;
            }
            long version = fsInfo.getVersion();
            if (fileStore.getVersion() < version) {
                this.filePath.fs = FileStore.fromProtobuf(fsInfo);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static Shard fromProtobuf(ShardInfo info) {
        String serviceId = info.getServiceId();
        List groupIds = info.getGroupIdsList();
        long shardId = info.getShardId();
        FilePath path = null;
        if (info.hasFilePath()) {
            path = FilePath.fromProtobuf(info.getFilePath());
        }
        FileCache cache = null;
        if (info.hasFileCache()) {
            cache = FileCache.fromProtobuf(info.getFileCache());
        }
        Shard shard = new Shard(serviceId, groupIds, shardId, path, cache);
        shard.setState(info.getShardState());
        List replicaInfos = info.getReplicaInfoList();
        ArrayList<Replica> replicas = new ArrayList<Replica>(replicaInfos.size());
        for (ReplicaInfo replicaInfo : replicaInfos) {
            replicas.add(Replica.fromProtobuf(replicaInfo));
        }
        shard.setReplicas(replicas);
        Map properties = info.getShardPropertiesMap();
        shard.setProperties(properties);
        int replicaNum = info.getExpectedReplicaNum() == 0 ? 1 : info.getExpectedReplicaNum();
        shard.setExpectedReplicaNum(replicaNum);
        return shard;
    }

    public void write(DataOutput out) throws IOException {
        byte[] bytes = this.toProtobuf().toByteArray();
        Text.writeBytes((DataOutput)out, (byte[])bytes);
    }

    public static Shard read(DataInput in) throws IOException {
        byte[] bytes = Text.readBytes((DataInput)in);
        ShardInfo info = ShardInfo.parseFrom((byte[])bytes);
        return Shard.fromProtobuf(info);
    }

    public int hashCode() {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            Long fsVersion = 0L;
            if (this.filePath != null && this.filePath.fs != null) {
                fsVersion = this.filePath.fs.getVersion();
            }
            boolean enableCache = false;
            if (this.fileCache != null) {
                enableCache = this.fileCache.getFileCacheEnable();
            }
            int n = Objects.hash(fsVersion, enableCache);
            return n;
        }
    }
}

