/*
 * Decompiled with CFR 0.152.
 */
package com.staros.worker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.staros.exception.AlreadyExistsStarException;
import com.staros.exception.InvalidArgumentStarException;
import com.staros.exception.StarException;
import com.staros.proto.WorkerGroupDetailInfo;
import com.staros.proto.WorkerGroupSpec;
import com.staros.proto.WorkerGroupState;
import com.staros.util.LockCloseable;
import com.staros.util.Text;
import com.staros.util.Writable;
import com.staros.worker.Worker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkerGroup
implements Writable {
    private static final Logger LOG = LogManager.getLogger(WorkerGroup.class);
    private static final String BUILTIN_OWNER = "OwnByStarManager";
    private static final WorkerGroupSpec BUILTIN_SPEC = WorkerGroupSpec.newBuilder().setSize("L").build();
    private final String serviceId;
    private final long groupId;
    private final String owner;
    private WorkerGroupSpec spec;
    private WorkerGroupState state;
    private Map<String, String> labels;
    private Map<String, String> properties;
    private int replicaNumber;
    private final Map<Long, Worker> workers;
    private final ReentrantReadWriteLock readWriteLock;

    public WorkerGroup(String serviceId, long groupId) {
        this(serviceId, groupId, BUILTIN_OWNER, BUILTIN_SPEC, null, null, 1);
    }

    public WorkerGroup(String serviceId, long groupId, String owner, WorkerGroupSpec spec, Map<String, String> labels, Map<String, String> properties, int replicaNumber) {
        this.serviceId = serviceId;
        this.groupId = groupId;
        this.owner = owner;
        this.spec = WorkerGroupSpec.newBuilder((WorkerGroupSpec)spec).build();
        this.labels = labels == null ? ImmutableMap.of() : ImmutableMap.copyOf(labels);
        this.properties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
        this.replicaNumber = replicaNumber;
        this.state = WorkerGroupState.PENDING;
        this.workers = new HashMap<Long, Worker>();
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public String getOwner() {
        return this.owner;
    }

    public WorkerGroupSpec getSpec() {
        return this.spec;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public int getReplicaNumber() {
        return this.replicaNumber;
    }

    public WorkerGroupState getState() {
        return this.state;
    }

    public void updateState(WorkerGroupState state) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.readWriteLock.writeLock());){
            this.state = state;
        }
    }

    public void updateSpec(WorkerGroupSpec spec) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.readWriteLock.writeLock());){
            this.spec = WorkerGroupSpec.newBuilder((WorkerGroupSpec)spec).build();
            this.state = WorkerGroupState.PENDING;
        }
    }

    public void setLabels(Map<String, String> labels) {
        if (labels == null) {
            return;
        }
        try (LockCloseable ignored = new LockCloseable((Lock)this.readWriteLock.writeLock());){
            this.labels = ImmutableMap.copyOf(labels);
        }
    }

    public void setProperties(Map<String, String> properties) {
        if (properties == null) {
            return;
        }
        try (LockCloseable ignored = new LockCloseable((Lock)this.readWriteLock.writeLock());){
            this.properties = ImmutableMap.copyOf(properties);
        }
    }

    public void setReplicaNumber(int rn) throws StarException {
        if (rn <= 0) {
            throw new InvalidArgumentStarException("worker group {} replica number should be larger than 0, now is {}.", new Object[]{this.groupId, rn});
        }
        this.replicaNumber = rn;
    }

    public void addWorker(Worker worker) throws StarException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.readWriteLock.writeLock());){
            this.checkWorkerNoLock(worker);
            if (this.workers.containsKey(worker.getWorkerId())) {
                throw new AlreadyExistsStarException("worker {}({}) already exist in worker group.", new Object[]{worker.getWorkerId(), worker.getIpPort()});
            }
            this.workers.put(worker.getWorkerId(), worker);
        }
    }

    public boolean removeWorker(Worker worker) throws StarException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.readWriteLock.writeLock());){
            if (!this.workers.containsKey(worker.getWorkerId())) {
                boolean bl = false;
                return bl;
            }
            this.checkWorkerNoLock(worker);
            this.workers.remove(worker.getWorkerId());
            boolean bl = true;
            return bl;
        }
    }

    public boolean updateWorker(Worker worker) throws StarException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.readWriteLock.writeLock());){
            if (!this.workers.containsKey(worker.getWorkerId())) {
                boolean bl = false;
                return bl;
            }
            this.checkWorkerNoLock(worker);
            boolean bl = this.workers.get(worker.getWorkerId()).update(worker);
            return bl;
        }
    }

    public List<Long> getAllWorkerIds(boolean onlyAlive) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.readWriteLock.readLock());){
            if (onlyAlive) {
                List<Long> list = this.workers.values().stream().filter(Worker::isAlive).map(Worker::getWorkerId).collect(Collectors.toList());
                return list;
            }
            ArrayList<Long> arrayList = new ArrayList<Long>(this.workers.keySet());
            return arrayList;
        }
    }

    public int getWorkerCount() {
        try (LockCloseable ignored = new LockCloseable((Lock)this.readWriteLock.readLock());){
            int n = this.workers.size();
            return n;
        }
    }

    public Worker getWorker(long workerId) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.readWriteLock.readLock());){
            Worker worker = this.workers.get(workerId);
            return worker;
        }
    }

    private void checkWorkerNoLock(Worker worker) throws IllegalStateException {
        Preconditions.checkState((boolean)worker.getServiceId().equals(this.serviceId), (Object)String.format("worker's service id %s not match service id %s in worker group.", worker.getServiceId(), this.serviceId));
        Preconditions.checkState((worker.getGroupId() == this.groupId ? 1 : 0) != 0, (Object)String.format("worker's group id %d not match group id %d in worker group.", worker.getGroupId(), this.groupId));
    }

    public WorkerGroupDetailInfo toProtobuf() {
        try (LockCloseable ignored = new LockCloseable((Lock)this.readWriteLock.readLock());){
            WorkerGroupDetailInfo workerGroupDetailInfo = WorkerGroupDetailInfo.newBuilder().setServiceId(this.serviceId).setGroupId(this.groupId).setOwner(this.owner).setSpec(this.spec).putAllLabels(this.labels).putAllProperties(this.properties).setState(this.state).setReplicaNumber(this.replicaNumber).build();
            return workerGroupDetailInfo;
        }
    }

    public static WorkerGroup fromProtobuf(WorkerGroupDetailInfo info) {
        int replicaNumber = info.getReplicaNumber() == 0 ? 1 : info.getReplicaNumber();
        WorkerGroup group = new WorkerGroup(info.getServiceId(), info.getGroupId(), info.getOwner(), info.getSpec(), info.getLabelsMap(), info.getPropertiesMap(), replicaNumber);
        group.updateState(info.getState());
        return group;
    }

    public void write(DataOutput out) throws IOException {
        byte[] bytes = this.toProtobuf().toByteArray();
        Text.writeBytes((DataOutput)out, (byte[])bytes);
    }

    public static WorkerGroup read(DataInput in) throws IOException {
        byte[] bytes = Text.readBytes((DataInput)in);
        WorkerGroupDetailInfo info = WorkerGroupDetailInfo.parseFrom((byte[])bytes);
        return WorkerGroup.fromProtobuf(info);
    }
}

