/*
 * Decompiled with CFR 0.152.
 */
package com.staros.credential;

import com.staros.proto.ADLS2CredentialInfo;

public class ADLS2Credential {
    private String sharedKey;
    private String sasToken;
    private String tenantId;
    private String clientId;
    private String clientSecret;
    private String clientCertificatePath;
    private String authorityHost;

    public ADLS2Credential(String sharedKey, String sasToken, String tenantId, String clientId, String clientSecret, String clientCertificatePath, String authorityHost) {
        this.sharedKey = sharedKey;
        this.sasToken = sasToken;
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.clientCertificatePath = clientCertificatePath;
        this.authorityHost = authorityHost;
    }

    public ADLS2CredentialInfo toProtobuf() {
        ADLS2CredentialInfo.Builder builder = ADLS2CredentialInfo.newBuilder();
        return builder.setSharedKey(this.sharedKey).setSasToken(this.sasToken).setTenantId(this.tenantId).setClientId(this.clientId).setClientSecret(this.clientSecret).setClientCertificatePath(this.clientCertificatePath).setAuthorityHost(this.authorityHost).build();
    }

    public boolean isEmpty() {
        return this.sharedKey.isEmpty() && this.sasToken.isEmpty() && this.tenantId.isEmpty() && this.clientId.isEmpty() && this.clientSecret.isEmpty() && this.clientCertificatePath.isEmpty() && this.authorityHost.isEmpty();
    }

    public static ADLS2Credential fromProtobuf(ADLS2CredentialInfo credentialInfo) {
        String sharedKey = credentialInfo.getSharedKey();
        String sasToken = credentialInfo.getSasToken();
        String tenantId = credentialInfo.getTenantId();
        String clientId = credentialInfo.getClientId();
        String clientSecret = credentialInfo.getClientSecret();
        String clientCertificatePath = credentialInfo.getClientCertificatePath();
        String authorityHost = credentialInfo.getAuthorityHost();
        return new ADLS2Credential(sharedKey, sasToken, tenantId, clientId, clientSecret, clientCertificatePath, authorityHost);
    }
}

