/*
 * Decompiled with CFR 0.152.
 */
package com.staros.shard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.staros.exception.ExceptionCode;
import com.staros.exception.InternalErrorStarException;
import com.staros.exception.NotExistStarException;
import com.staros.exception.StarException;
import com.staros.filecache.FileCache;
import com.staros.filestore.DelegatedFileStore;
import com.staros.filestore.FilePath;
import com.staros.filestore.FileStore;
import com.staros.filestore.FileStoreMgr;
import com.staros.journal.Journal;
import com.staros.journal.JournalSystem;
import com.staros.journal.StarMgrJournal;
import com.staros.metrics.MetricsSystem;
import com.staros.proto.CacheEnableState;
import com.staros.proto.CreateMetaGroupInfo;
import com.staros.proto.CreateShardGroupInfo;
import com.staros.proto.CreateShardInfo;
import com.staros.proto.CreateShardJournalInfo;
import com.staros.proto.DeleteMetaGroupInfo;
import com.staros.proto.DeleteShardGroupInfo;
import com.staros.proto.MetaGroupInfo;
import com.staros.proto.MetaGroupJournalInfo;
import com.staros.proto.PlacementPolicy;
import com.staros.proto.PlacementPreference;
import com.staros.proto.PlacementRelationship;
import com.staros.proto.ReplicaState;
import com.staros.proto.ReplicaUpdateInfo;
import com.staros.proto.SectionType;
import com.staros.proto.ShardGroupInfo;
import com.staros.proto.ShardInfo;
import com.staros.proto.ShardManagerImageMetaFooter;
import com.staros.proto.ShardManagerImageMetaHeader;
import com.staros.proto.UpdateMetaGroupInfo;
import com.staros.proto.UpdateShardGroupInfo;
import com.staros.proto.UpdateShardInfo;
import com.staros.replica.Replica;
import com.staros.schedule.Scheduler;
import com.staros.section.Section;
import com.staros.section.SectionReader;
import com.staros.section.SectionWriter;
import com.staros.shard.MetaGroup;
import com.staros.shard.Shard;
import com.staros.shard.ShardGroup;
import com.staros.util.Config;
import com.staros.util.IdGenerator;
import com.staros.util.LockCloseable;
import com.staros.util.LogUtils;
import com.staros.util.Utils;
import io.prometheus.metrics.core.datapoints.GaugeDataPoint;
import io.prometheus.metrics.core.metrics.Gauge;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShardManager {
    private static final Logger LOG = LogManager.getLogger(ShardManager.class);
    private final String serviceId;
    private final Map<Long, Shard> shards;
    private final Map<Long, ShardGroup> shardGroups;
    private final Map<Long, MetaGroup> metaGroups;
    private final ReentrantReadWriteLock lock;
    private final JournalSystem journalSystem;
    private final IdGenerator idGenerator;
    private final Scheduler shardScheduler;
    private final Map<String, DelegatedFileStore> shardFileStoreSnapshot;
    private static final Gauge METRIC_TOTAL_SHARD = MetricsSystem.registerGauge((String)"starmgr_num_shards", (String)"total number of shards in starmgr", (List)Lists.newArrayList((Object[])new String[]{"serviceId"}));
    private static final Gauge METRIC_TOTAL_SHARDGROUP = MetricsSystem.registerGauge((String)"starmgr_num_shard_groups", (String)"total number of shard groups in starmgr", (List)Lists.newArrayList((Object[])new String[]{"serviceId"}));
    private final GaugeDataPoint totalShardGauge;
    private final GaugeDataPoint totalShardGroupGauge;
    private static final Map<ShardReplicaOp, BiFunction<Shard, Long, Boolean>> shardReplicaBinFuncMap = new ImmutableMap.Builder().put((Object)ShardReplicaOp.ADD, (shard, workerId) -> shard.addReplica((long)workerId, ReplicaState.REPLICA_OK)).put((Object)ShardReplicaOp.ADD_TEMP, Shard::addTempReplica).put((Object)ShardReplicaOp.DELETE, Shard::removeReplica).put((Object)ShardReplicaOp.SCALE_OUT, Shard::scaleOutReplica).put((Object)ShardReplicaOp.SCALE_OUT_TEMP, Shard::scaleOutTempReplica).put((Object)ShardReplicaOp.SCALE_IN, Shard::scaleInReplica).put((Object)ShardReplicaOp.SCALE_OUT_DONE, Shard::scaleOutReplicaDone).put((Object)ShardReplicaOp.TEMP_TO_NORMAL, Shard::convertTempReplicaToNormal).build();

    public ShardManager(String serviceId, JournalSystem journalSystem, IdGenerator idGenerator, Scheduler shardScheduler) {
        this.serviceId = serviceId;
        this.shards = new ConcurrentHashMap<Long, Shard>();
        this.shardGroups = new HashMap<Long, ShardGroup>();
        this.metaGroups = new HashMap<Long, MetaGroup>();
        this.lock = new ReentrantReadWriteLock();
        this.journalSystem = journalSystem;
        this.idGenerator = idGenerator;
        this.shardScheduler = shardScheduler;
        this.shardFileStoreSnapshot = new HashMap<String, DelegatedFileStore>();
        this.totalShardGauge = (GaugeDataPoint)METRIC_TOTAL_SHARD.labelValues(new String[]{serviceId});
        this.totalShardGroupGauge = (GaugeDataPoint)METRIC_TOTAL_SHARDGROUP.labelValues(new String[]{serviceId});
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            ShardGroup shardGroup = new ShardGroup(serviceId, 0L);
            this.operateShardGroupInternal(0L, shardGroup, true);
        }
    }

    public String getServiceId() {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            String string = this.serviceId;
            return string;
        }
    }

    public List<ShardGroupInfo> createShardGroup(List<CreateShardGroupInfo> createShardGroupInfos) throws StarException {
        if (createShardGroupInfos.isEmpty()) {
            throw new StarException(ExceptionCode.INVALID_ARGUMENT, "shard group info can not be empty.");
        }
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            ArrayList<ShardGroup> shardGroupsToCreate = new ArrayList<ShardGroup>(createShardGroupInfos.size());
            for (CreateShardGroupInfo info : createShardGroupInfos) {
                ShardGroup shardGroup = new ShardGroup(this.serviceId, this.idGenerator.getNextId(), info.getPolicy(), false, 0L, info.getLabelsMap(), info.getPropertiesMap());
                shardGroupsToCreate.add(shardGroup);
            }
            ArrayList<ShardGroupInfo> shardGroupInfos = new ArrayList<ShardGroupInfo>(shardGroupsToCreate.size());
            Journal journal = StarMgrJournal.logCreateShardGroup(this.serviceId, shardGroupsToCreate);
            this.journalSystem.write(journal);
            Utils.executeNoExceptionOrDie(() -> {
                for (ShardGroup shardGroup : shardGroupsToCreate) {
                    this.operateShardGroupInternal(shardGroup.getGroupId(), shardGroup, true);
                    shardGroupInfos.add(shardGroup.toProtobuf());
                }
            });
            ArrayList<ShardGroupInfo> arrayList = shardGroupInfos;
            return arrayList;
        }
    }

    public void deleteShardGroup(List<Long> groupIds, boolean deleteShards) throws StarException {
        this.deleteShardGroupInternal(groupIds, deleteShards, false);
    }

    private void deleteShardGroupInternal(List<Long> groupIds, boolean deleteShards, boolean isReplay) throws StarException {
        if (groupIds.isEmpty()) {
            throw new StarException(ExceptionCode.INVALID_ARGUMENT, "shard group id can not be empty.");
        }
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            ArrayList<ShardGroup> groupsToDelete = new ArrayList<ShardGroup>(groupIds.size());
            for (Long groupId : groupIds) {
                if (groupId == 0L) {
                    throw new StarException(ExceptionCode.INVALID_ARGUMENT, String.format("default shard group %d can not be deleted in service %s.", groupId, this.serviceId));
                }
                ShardGroup shardGroup = this.shardGroups.get(groupId);
                if (shardGroup == null) continue;
                groupsToDelete.add(shardGroup);
            }
            if (!isReplay) {
                List groupIdsToDelete = groupsToDelete.stream().map(ShardGroup::getGroupId).collect(Collectors.toList());
                DeleteShardGroupInfo info = DeleteShardGroupInfo.newBuilder().addAllGroupIds(groupIdsToDelete).setCascadeDeleteShard(deleteShards).build();
                Journal journal = StarMgrJournal.logDeleteShardGroup(this.serviceId, info);
                this.journalSystem.write(journal);
            }
            Utils.executeNoExceptionOrDie(() -> {
                for (ShardGroup shardGroup : groupsToDelete) {
                    this.operateShardGroupInternal(shardGroup.getGroupId(), null, false);
                    List<Long> shardIds = shardGroup.getShardIds();
                    if (deleteShards) {
                        for (long id : shardIds) {
                            Shard shard = this.shards.get(id);
                            if (shard == null) continue;
                            this.removeShardInternalNoLock(this.shards.get(id));
                        }
                        continue;
                    }
                    for (long id : shardIds) {
                        this.shards.get(id).quitGroup(shardGroup.getGroupId());
                    }
                }
            });
        }
    }

    public void updateShardGroup(List<UpdateShardGroupInfo> updateShardGroupInfos) throws StarException {
        block18: {
            try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
                ArrayList<ShardGroup> shardGroupsToUpdate = new ArrayList<ShardGroup>();
                ArrayList allShardsToUpdate = new ArrayList();
                for (UpdateShardGroupInfo updateShardGroupInfo : updateShardGroupInfos) {
                    ShardGroup shardGroup;
                    if (updateShardGroupInfo.getEnableCache() == CacheEnableState.NOT_SET || (shardGroup = this.shardGroups.get(updateShardGroupInfo.getGroupId())) == null) continue;
                    List<Long> shardIds = shardGroup.getShardIds();
                    ArrayList<Shard> shardsToUpdate = new ArrayList<Shard>(shardIds.size());
                    for (Long shardId : shardIds) {
                        Shard shard = this.shards.get(shardId);
                        if (shard == null) continue;
                        if (updateShardGroupInfo.getEnableCache() == CacheEnableState.ENABLED && !shard.getFileCache().getFileCacheEnable()) {
                            shard.setFileCacheEnable(true);
                            shardsToUpdate.add(shard);
                            continue;
                        }
                        if (updateShardGroupInfo.getEnableCache() != CacheEnableState.DISABLED || !shard.getFileCache().getFileCacheEnable()) continue;
                        shard.setFileCacheEnable(false);
                        shardsToUpdate.add(shard);
                    }
                    if (shardsToUpdate.isEmpty()) continue;
                    allShardsToUpdate.addAll(shardsToUpdate);
                    shardGroupsToUpdate.add(shardGroup);
                }
                if (shardGroupsToUpdate.isEmpty()) break block18;
                try {
                    Journal journal = StarMgrJournal.logUpdateShardGroup(this.serviceId, shardGroupsToUpdate);
                    this.journalSystem.write(journal);
                }
                catch (StarException e) {
                    Iterator iterator = allShardsToUpdate.iterator();
                    while (iterator.hasNext()) {
                        Shard shard;
                        shard.setFileCacheEnable(!(shard = (Shard)iterator.next()).getFileCache().getFileCacheEnable());
                    }
                    throw e;
                }
            }
        }
    }

    public Pair<List<ShardGroupInfo>, Long> listShardGroupInfo(boolean includeAnonymousGroup, long startGroupId) throws StarException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            ArrayList<ShardGroupInfo> shardGroupInfos = new ArrayList<ShardGroupInfo>();
            TreeMap<Long, ShardGroup> sortedShardGroups = new TreeMap<Long, ShardGroup>(this.shardGroups);
            SortedMap<Long, ShardGroup> truncatedSortedShardGroups = sortedShardGroups.tailMap(startGroupId);
            long nextGroupId = 0L;
            long lastGroupId = 0L;
            for (ShardGroup shardGroup : truncatedSortedShardGroups.values()) {
                if (!includeAnonymousGroup && shardGroup.isAnonymous()) continue;
                if (shardGroupInfos.size() >= Config.LIST_SHARD_GROUP_BATCH_SIZE) {
                    nextGroupId = lastGroupId + 1L;
                    break;
                }
                lastGroupId = shardGroup.getGroupId();
                shardGroupInfos.add(shardGroup.toProtobuf());
            }
            Pair pair = Pair.of(shardGroupInfos, (Object)nextGroupId);
            return pair;
        }
    }

    public List<ShardGroupInfo> getShardGroupInfo(List<Long> shardGroupIds) throws StarException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            ArrayList<ShardGroupInfo> shardGroupInfos = new ArrayList<ShardGroupInfo>(shardGroupIds.size());
            for (Long shardGroupId : shardGroupIds) {
                ShardGroup shardGroup = this.shardGroups.get(shardGroupId);
                if (shardGroup == null) {
                    throw new StarException(ExceptionCode.NOT_EXIST, String.format("shard group %d not exist", shardGroupId));
                }
                shardGroupInfos.add(shardGroup.toProtobuf());
            }
            ArrayList<ShardGroupInfo> arrayList = shardGroupInfos;
            return arrayList;
        }
    }

    private Shard addShardInternalNoLock(Shard shard) {
        assert (shard != null);
        FilePath path = shard.getFilePath();
        if (path != null && path.fs != null) {
            FileStore fs = this.setOrUpdateFileStoreSnapshotInternal(path.fs);
            FilePath newPath = new FilePath(fs, path.suffix);
            shard.setFilePath(newPath);
        }
        Shard old = this.shards.put(shard.getShardId(), shard);
        this.totalShardGauge.set((double)this.shards.size());
        for (Long groupId : shard.getGroupIds()) {
            ShardGroup shardGroup = this.shardGroups.get(groupId);
            assert (shardGroup != null);
            shardGroup.addShardId(shard.getShardId());
        }
        return old;
    }

    private Shard removeShardInternalNoLock(Shard shard) {
        assert (shard != null);
        Shard old = this.shards.remove(shard.getShardId());
        this.totalShardGauge.set((double)this.shards.size());
        for (Long groupId : shard.getGroupIds()) {
            ShardGroup shardGroup = this.shardGroups.get(groupId);
            if (shardGroup == null) continue;
            shardGroup.removeShardId(shard.getShardId());
            if (!shardGroup.isAnonymous() || shardGroup.getMetaGroupId() != 0L || shardGroup.getShardIds().size() >= 2) continue;
            for (long id : shardGroup.getShardIds()) {
                this.shards.get(id).quitGroup(shardGroup.getGroupId());
            }
            this.operateShardGroupInternal(shardGroup.getGroupId(), null, false);
        }
        return old;
    }

    private void commitCreateShard(List<Shard> shardList, List<ShardGroup> anonymousShardGroups) {
        for (ShardGroup anonymousShardGroup : anonymousShardGroups) {
            this.operateShardGroupInternal(anonymousShardGroup.getGroupId(), anonymousShardGroup, true);
        }
        for (Shard shard : shardList) {
            this.addShardInternalNoLock(shard);
        }
        for (ShardGroup anonymousShardGroup : anonymousShardGroups) {
            for (Long sid : anonymousShardGroup.getShardIds()) {
                this.shards.get(sid).joinGroup(anonymousShardGroup.getGroupId());
            }
        }
    }

    private void checkPlacementPreference(PlacementPreference preference) throws StarException {
        if (preference.getPlacementPolicy() != PlacementPolicy.PACK) {
            throw new StarException(ExceptionCode.INVALID_ARGUMENT, String.format("shard placement preference does not support %s policy in service %s.", preference.getPlacementPolicy().name(), this.serviceId));
        }
        if (preference.getPlacementRelationship() != PlacementRelationship.WITH_SHARD) {
            throw new StarException(ExceptionCode.INVALID_ARGUMENT, String.format("shard placement preference does not support %s relationship in service %s.", preference.getPlacementRelationship().name(), this.serviceId));
        }
        long targetId = preference.getRelationshipTargetId();
        Shard targetShard = this.shards.get(targetId);
        if (targetShard == null) {
            throw new StarException(ExceptionCode.NOT_EXIST, String.format("shard placement preference target id %d not exist in service %s.", targetId, this.serviceId));
        }
        Preconditions.checkState((preference.getPlacementPolicy() == PlacementPolicy.PACK ? 1 : 0) != 0);
    }

    public List<ShardInfo> createShard(List<CreateShardInfo> createShardInfos, FileStoreMgr fsMgr) throws StarException {
        ArrayList<Shard> shardsToCreate = new ArrayList<Shard>(createShardInfos.size());
        ArrayListMultimap shardsToSchedule = ArrayListMultimap.create();
        LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());
        Object object = null;
        try {
            ArrayList<ShardGroup> anonymousShardGroups = new ArrayList<ShardGroup>();
            for (CreateShardInfo createShardInfo : createShardInfos) {
                FilePath path;
                FileStore fs;
                long shardId = createShardInfo.getShardId();
                if (shardId == 0L) {
                    shardId = this.idGenerator.getNextId();
                }
                if (this.shards.containsKey(shardId)) {
                    throw new StarException(ExceptionCode.ALREADY_EXIST, String.format("shard %d already exist in service %s.", shardId, this.serviceId));
                }
                Preconditions.checkArgument((createShardInfo.getReplicaCount() == 0 || createShardInfo.getReplicaCount() == 1 ? 1 : 0) != 0, (Object)"replica count in createShard request is deprecated");
                int shardReplicaNum = 1;
                List groupIds = createShardInfo.getGroupIdsList();
                for (Long groupId : groupIds) {
                    int replicaNum;
                    ShardGroup group = this.shardGroups.get(groupId);
                    if (group == null) {
                        throw new StarException(ExceptionCode.NOT_EXIST, String.format("shard group %d not exist in service %s.", groupId, this.serviceId));
                    }
                    if (group.getPlacementPolicy() != PlacementPolicy.PACK || (replicaNum = this.getFirstShardReplicaNumFromGroup(group, -1)) == -1 || shardReplicaNum == replicaNum) continue;
                    throw new StarException(ExceptionCode.INVALID_ARGUMENT, String.format("Inconsistent shard replica num:%d when join a PACK shard group:%d.", shardReplicaNum, groupId));
                }
                if (!createShardInfo.getPlacementPreferencesList().isEmpty()) {
                    if (createShardInfo.getPlacementPreferencesList().size() != 1) {
                        throw new StarException(ExceptionCode.INVALID_ARGUMENT, String.format("shard placement preference does not support multiple in service %s.", this.serviceId));
                    }
                    PlacementPreference preference = (PlacementPreference)createShardInfo.getPlacementPreferencesList().get(0);
                    this.checkPlacementPreference(preference);
                    ShardGroup anonymousShardGroup = new ShardGroup(this.serviceId, this.idGenerator.getNextId(), preference.getPlacementPolicy(), true, 0L);
                    anonymousShardGroup.addShardId(preference.getRelationshipTargetId());
                    anonymousShardGroup.addShardId(shardId);
                    anonymousShardGroups.add(anonymousShardGroup);
                }
                if (!createShardInfo.hasPathInfo()) {
                    fs = fsMgr.allocFileStore("");
                    path = new FilePath(fs, String.format("%s/%s", this.serviceId, ""));
                } else {
                    fs = fsMgr.getFileStore(createShardInfo.getPathInfo().getFsInfo().getFsKey());
                    if (fs == null) {
                        throw new StarException(ExceptionCode.NOT_EXIST, String.format("file store with key '%s' not exist", createShardInfo.getPathInfo().getFsInfo().getFsKey()));
                    }
                    path = FilePath.fromFullPath(fs, createShardInfo.getPathInfo().getFullPath());
                }
                FileCache cache = FileCache.fromProtobuf(createShardInfo.getCacheInfo());
                Shard shard = new Shard(this.serviceId, groupIds, shardId, path, cache);
                Map shardProperties = createShardInfo.getShardPropertiesMap();
                shard.setProperties(shardProperties);
                shardsToCreate.add(shard);
                long workerGroupId = createShardInfo.getScheduleToWorkerGroup();
                if (workerGroupId == 0L && !Config.ENABLE_ZERO_WORKER_GROUP_COMPATIBILITY) continue;
                shardsToSchedule.put((Object)workerGroupId, (Object)shardId);
            }
            CreateShardJournalInfo.Builder builder = CreateShardJournalInfo.newBuilder();
            for (Shard shard : shardsToCreate) {
                builder.addShardInfos(shard.toProtobuf());
            }
            for (ShardGroup anonymousShardGroup : anonymousShardGroups) {
                builder.addShardGroupInfos(anonymousShardGroup.toProtobuf());
            }
            Journal journal = StarMgrJournal.logCreateShard(this.serviceId, builder.build());
            this.journalSystem.write(journal);
            Utils.executeNoExceptionOrDie(() -> this.commitCreateShard(shardsToCreate, anonymousShardGroups));
        }
        catch (Throwable anonymousShardGroups) {
            object = anonymousShardGroups;
            throw anonymousShardGroups;
        }
        finally {
            if (ignored != null) {
                if (object != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable anonymousShardGroups) {
                        ((Throwable)object).addSuppressed(anonymousShardGroups);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        List<Long> shardIds = shardsToCreate.stream().map(Shard::getShardId).collect(Collectors.toList());
        if (Config.SCHEDULER_TRIGGER_SCHEDULE_WHEN_CREATE_SHARD) {
            object = shardsToSchedule.asMap().keySet().iterator();
            while (object.hasNext()) {
                long workerGroupId = (Long)object.next();
                ArrayList<Long> arrayList = new ArrayList<Long>(shardsToSchedule.get((Object)workerGroupId));
                try {
                    this.shardScheduler.scheduleAddToGroup(this.serviceId, arrayList, workerGroupId);
                }
                catch (StarException e) {
                    LOG.warn("Fail to schedule new created shards to default workerGroup for service: {}, ignore the error for now. Error:{}", (Object)this.serviceId, (Object)e.getMessage());
                }
            }
        }
        return this.getShardInfo(shardIds);
    }

    public void deleteShard(List<Long> shardIds) throws StarException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            ArrayList<Shard> shardsToDelete = new ArrayList<Shard>(shardIds.size());
            for (Long shardId : shardIds) {
                Shard shard = this.shards.get(shardId);
                if (shard == null) continue;
                shardsToDelete.add(shard);
            }
            Journal journal = StarMgrJournal.logDeleteShard(this.serviceId, shardIds);
            this.journalSystem.write(journal);
            Utils.executeNoExceptionOrDie(() -> {
                for (Shard shard : shardsToDelete) {
                    Shard old = this.removeShardInternalNoLock(shard);
                    assert (old != null);
                }
            });
        }
    }

    public void updateShard(List<UpdateShardInfo> updateShardInfos) throws StarException {
        block17: {
            try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
                Shard shard;
                ArrayList<Shard> shardsToUpdate = new ArrayList<Shard>();
                for (UpdateShardInfo updateShardInfo : updateShardInfos) {
                    if (updateShardInfo.getEnableCache() == CacheEnableState.NOT_SET || (shard = this.shards.get(updateShardInfo.getShardId())) == null) continue;
                    if (updateShardInfo.getEnableCache() == CacheEnableState.ENABLED && !shard.getFileCache().getFileCacheEnable()) {
                        shard.setFileCacheEnable(true);
                        shardsToUpdate.add(shard);
                        continue;
                    }
                    if (updateShardInfo.getEnableCache() != CacheEnableState.DISABLED || !shard.getFileCache().getFileCacheEnable()) continue;
                    shard.setFileCacheEnable(false);
                    shardsToUpdate.add(shard);
                }
                if (shardsToUpdate.isEmpty()) break block17;
                try {
                    Journal journal = StarMgrJournal.logUpdateShard(this.serviceId, shardsToUpdate);
                    this.journalSystem.write(journal);
                }
                catch (StarException e) {
                    Iterator iterator = shardsToUpdate.iterator();
                    while (iterator.hasNext()) {
                        shard.setFileCacheEnable(!(shard = (Shard)iterator.next()).getFileCache().getFileCacheEnable());
                    }
                    throw e;
                }
            }
        }
    }

    public List<ShardInfo> getShardInfo(List<Long> shardIds) throws StarException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            ArrayList<ShardInfo> shardInfos = new ArrayList<ShardInfo>(shardIds.size());
            for (Long shardId : shardIds) {
                Shard shard = this.shards.get(shardId);
                if (shard == null) {
                    throw new StarException(ExceptionCode.NOT_EXIST, String.format("shard %d not exist.", shardId));
                }
                shardInfos.add(shard.toProtobuf());
            }
            ArrayList<ShardInfo> arrayList = shardInfos;
            return arrayList;
        }
    }

    public List<List<ShardInfo>> listShardInfo(List<Long> groupIds, boolean withoutReplicaInfo) throws StarException {
        if (groupIds.isEmpty()) {
            throw new StarException(ExceptionCode.INVALID_ARGUMENT, "shard group id can not be empty.");
        }
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            ArrayList shardInfos = new ArrayList(groupIds.size());
            for (Long groupId : groupIds) {
                ShardGroup shardGroup = this.shardGroups.get(groupId);
                if (shardGroup == null) {
                    throw new StarException(ExceptionCode.NOT_EXIST, String.format("shard group %d not exist.", groupId));
                }
                ArrayList<ShardInfo> infos = new ArrayList<ShardInfo>(shardGroup.getShardIds().size());
                for (Long shardId : shardGroup.getShardIds()) {
                    Shard shard = this.shards.get(shardId);
                    infos.add(shard.toProtobuf(withoutReplicaInfo));
                }
                shardInfos.add(infos);
            }
            ArrayList arrayList = shardInfos;
            return arrayList;
        }
    }

    public Shard getShard(long shardId) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            Shard shard = this.shards.get(shardId);
            return shard;
        }
    }

    public ShardGroup getShardGroup(long groupId) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            ShardGroup shardGroup = this.shardGroups.get(groupId);
            return shardGroup;
        }
    }

    public MetaGroup getMetaGroup(long groupId) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            MetaGroup metaGroup = this.metaGroups.get(groupId);
            return metaGroup;
        }
    }

    public List<Long> getAllShardIds() {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            ArrayList<Long> arrayList = new ArrayList<Long>(this.shards.keySet());
            return arrayList;
        }
    }

    public Iterator<Map.Entry<Long, Shard>> getShardIterator() {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            Iterator<Map.Entry<Long, Shard>> iterator = this.shards.entrySet().iterator();
            return iterator;
        }
    }

    public List<Long> getAllShardGroupIds() {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            ArrayList<Long> arrayList = new ArrayList<Long>(this.shardGroups.keySet());
            return arrayList;
        }
    }

    public List<Long> getAllMetaGroupIds() {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            ArrayList<Long> arrayList = new ArrayList<Long>(this.metaGroups.keySet());
            return arrayList;
        }
    }

    private int verifyShardGroupInfoForMetaGroup(List<Long> shardGroupIds, int expectSize) throws StarException {
        for (Long shardGroupId : shardGroupIds) {
            ShardGroup shardGroup = this.shardGroups.get(shardGroupId);
            if (shardGroup == null) {
                throw new StarException(ExceptionCode.INVALID_ARGUMENT, String.format("shard group %d not exist.", shardGroupId));
            }
            if (expectSize == -1) {
                expectSize = shardGroup.getShardIds().size();
            }
            if (expectSize == shardGroup.getShardIds().size()) continue;
            throw new StarException(ExceptionCode.INVALID_ARGUMENT, String.format("shard size mismatch, expect %d, has %d.", expectSize, shardGroup.getShardIds().size()));
        }
        return expectSize;
    }

    public MetaGroupInfo createMetaGroup(CreateMetaGroupInfo createMetaGroupInfo) throws StarException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            ArrayList<ShardGroup> anonymousShardGroups;
            long metaGroupId = createMetaGroupInfo.getMetaGroupId() == 0L ? this.idGenerator.getNextId() : createMetaGroupInfo.getMetaGroupId();
            if (this.metaGroups.containsKey(metaGroupId)) {
                throw new StarException(ExceptionCode.ALREADY_EXIST, String.format("meta group %d already exists.", metaGroupId));
            }
            PlacementPolicy placementPolicy = createMetaGroupInfo.getPlacementPolicy();
            if (placementPolicy != PlacementPolicy.PACK) {
                throw new StarException(ExceptionCode.INVALID_ARGUMENT, String.format("meta group placement policy %s not allowed.", placementPolicy.name()));
            }
            List shardGroupIds = createMetaGroupInfo.getShardGroupIdsList();
            if (!shardGroupIds.isEmpty()) {
                int size = this.verifyShardGroupInfoForMetaGroup(shardGroupIds, -1);
                anonymousShardGroups = this.prepareAnonymousShardGroup(metaGroupId, size, placementPolicy, null);
                this.validateShardReplicaNumInGroup(placementPolicy, anonymousShardGroups, shardGroupIds);
            } else {
                anonymousShardGroups = new ArrayList();
            }
            List<Long> anonymousShardGroupIds = anonymousShardGroups.stream().map(ShardGroup::getGroupId).collect(Collectors.toList());
            MetaGroup metaGroup = new MetaGroup(this.serviceId, metaGroupId, anonymousShardGroupIds, createMetaGroupInfo.getPlacementPolicy());
            MetaGroupJournalInfo journalInfo = MetaGroupJournalInfo.newBuilder().setMetaGroupInfo(metaGroup.toProtobuf()).setCreateInfo(createMetaGroupInfo).build();
            Journal journal = StarMgrJournal.logCreateMetaGroup(this.serviceId, journalInfo);
            this.journalSystem.write(journal);
            Utils.executeNoExceptionOrDie(() -> {
                this.commitAnonymousShardGroup(metaGroup, anonymousShardGroups, shardGroupIds);
                this.metaGroups.put(metaGroupId, metaGroup);
            });
            MetaGroupInfo metaGroupInfo = metaGroup.toProtobuf();
            return metaGroupInfo;
        }
    }

    private void validateShardReplicaNumInGroup(PlacementPolicy policy, List<ShardGroup> targetGroups, List<Long> groupIds) {
        if (policy != PlacementPolicy.PACK) {
            return;
        }
        int INVALID_REPLICA_NUM = -1;
        ArrayList<Integer> expectReplicaNum = new ArrayList<Integer>(targetGroups.size());
        targetGroups.forEach(x -> {
            int replicaNum = this.getFirstShardReplicaNumFromGroup((ShardGroup)x, -1);
            expectReplicaNum.add(replicaNum);
        });
        for (long gid : groupIds) {
            ShardGroup group = this.shardGroups.get(gid);
            Preconditions.checkNotNull((Object)group);
            int pos = 0;
            for (long sid : group.getShardIds()) {
                Shard shard = this.shards.get(sid);
                Preconditions.checkNotNull((Object)shard);
                int replicaNum = shard.getExpectedReplicaNum();
                if ((Integer)expectReplicaNum.get(pos) == -1) {
                    expectReplicaNum.add(pos, replicaNum);
                } else if ((Integer)expectReplicaNum.get(pos) != replicaNum) {
                    throw new StarException(ExceptionCode.INVALID_ARGUMENT, String.format("shard:%d replicaNum: %d, target group expected replica num: %d", sid, replicaNum, expectReplicaNum.get(pos)));
                }
                ++pos;
            }
        }
    }

    @Deprecated
    private int getFirstShardReplicaNumFromGroup(ShardGroup group, int valueIfEmpty) {
        int result = valueIfEmpty;
        for (long shardId : group.getShardIds()) {
            if (!this.shards.containsKey(shardId)) continue;
            result = this.shards.get(shardId).getExpectedReplicaNum();
            break;
        }
        return result;
    }

    public void deleteMetaGroup(long metaGroupId) throws StarException {
        this.deleteMetaGroupInternal(metaGroupId, false);
    }

    public void deleteMetaGroupInternal(long metaGroupId, boolean isReplay) throws StarException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            MetaGroup metaGroup = this.metaGroups.get(metaGroupId);
            if (metaGroup == null) {
                return;
            }
            if (!isReplay) {
                DeleteMetaGroupInfo deleteInfo = DeleteMetaGroupInfo.newBuilder().setMetaGroupId(metaGroupId).build();
                MetaGroupJournalInfo journalInfo = MetaGroupJournalInfo.newBuilder().setDeleteInfo(deleteInfo).build();
                Journal journal = StarMgrJournal.logDeleteMetaGroup(this.serviceId, journalInfo);
                this.journalSystem.write(journal);
            }
            Utils.executeNoExceptionOrDie(() -> {
                List<Long> anonymousShardGroupIds = metaGroup.getShardGroupIds();
                for (Long groupId : anonymousShardGroupIds) {
                    ShardGroup shardGroup = this.shardGroups.get(groupId);
                    assert (shardGroup != null);
                    for (Long shardId : shardGroup.getShardIds()) {
                        Shard shard = this.shards.get(shardId);
                        assert (shard != null);
                        boolean v = shard.quitGroup(groupId);
                        assert (v);
                    }
                }
                for (Long groupId : anonymousShardGroupIds) {
                    ShardGroup old = this.operateShardGroupInternal(groupId, null, false);
                    assert (old != null);
                }
                MetaGroup old = this.metaGroups.remove(metaGroupId);
                assert (old != null);
            });
        }
    }

    private List<ShardGroup> prepareAnonymousShardGroup(long metaGroupId, int anonymousGroupSize, PlacementPolicy placementPolicy, List<Long> anonymousShardGroupIds) throws StarException {
        if (anonymousGroupSize == 0) {
            throw new StarException(ExceptionCode.INVALID_ARGUMENT, "anonymous shard group size can not be 0.");
        }
        ArrayList<ShardGroup> anonymousShardGroups = new ArrayList<ShardGroup>();
        for (int i = 0; i < anonymousGroupSize; ++i) {
            long groupId = anonymousShardGroupIds != null ? anonymousShardGroupIds.get(i).longValue() : this.idGenerator.getNextId();
            ShardGroup anonymousShardGroup = new ShardGroup(this.serviceId, groupId, placementPolicy, true, metaGroupId);
            anonymousShardGroups.add(anonymousShardGroup);
        }
        return anonymousShardGroups;
    }

    private void commitAnonymousShardGroup(MetaGroup metaGroup, List<ShardGroup> anonymousShardGroups, List<Long> shardGroupIds) {
        HashMap<Long, ShardGroup> updateShardList = new HashMap<Long, ShardGroup>();
        List shardGroupList = shardGroupIds.stream().map(this.shardGroups::get).collect(Collectors.toList());
        for (int pos = 0; pos < anonymousShardGroups.size(); ++pos) {
            ArrayList<Long> batchShardIds = new ArrayList<Long>(shardGroupList.size());
            for (ShardGroup group : shardGroupList) {
                batchShardIds.add(group.getShardIds().get(pos));
            }
            ShardGroup anonShardGroup = anonymousShardGroups.get(pos);
            List<Long> addedShardIds = anonShardGroup.batchAddShardId(batchShardIds);
            for (long id : addedShardIds) {
                updateShardList.put(id, anonShardGroup);
            }
        }
        for (Map.Entry entry : updateShardList.entrySet()) {
            Shard shard = this.shards.get(entry.getKey());
            shard.joinGroup(((ShardGroup)entry.getValue()).getGroupId());
        }
        for (ShardGroup shardGroup : anonymousShardGroups) {
            this.operateShardGroupInternal(shardGroup.getGroupId(), shardGroup, true);
        }
        List<Long> anonymousShardGroupIds = anonymousShardGroups.stream().map(ShardGroup::getGroupId).collect(Collectors.toList());
        metaGroup.setShardGroupIds(anonymousShardGroupIds);
    }

    private MetaGroup verifyAndGetMetaGroup(long metaGroupId) throws StarException {
        if (metaGroupId == 0L) {
            throw new StarException(ExceptionCode.INVALID_ARGUMENT, "meta group id not set.");
        }
        MetaGroup metaGroup = this.metaGroups.get(metaGroupId);
        if (metaGroup == null) {
            throw new StarException(ExceptionCode.NOT_EXIST, String.format("meta group id %d not exist.", metaGroupId));
        }
        return metaGroup;
    }

    private Pair<MetaGroup, MetaGroup> verifyUpdateMetaGroupInfo(UpdateMetaGroupInfo updateMetaGroupInfo) throws StarException {
        MetaGroup src = null;
        MetaGroup dst = null;
        UpdateMetaGroupInfo.InfoCase icase = updateMetaGroupInfo.getInfoCase();
        switch (icase) {
            case JOIN_INFO: {
                dst = this.verifyAndGetMetaGroup(updateMetaGroupInfo.getJoinInfo().getMetaGroupId());
                break;
            }
            case QUIT_INFO: {
                src = this.verifyAndGetMetaGroup(updateMetaGroupInfo.getQuitInfo().getMetaGroupId());
                break;
            }
            case TRANSFER_INFO: {
                src = this.verifyAndGetMetaGroup(updateMetaGroupInfo.getTransferInfo().getSrcMetaGroupId());
                dst = this.verifyAndGetMetaGroup(updateMetaGroupInfo.getTransferInfo().getDstMetaGroupId());
                break;
            }
            case INFO_NOT_SET: {
                throw new StarException(ExceptionCode.INVALID_ARGUMENT, "update meta group info type not set.");
            }
        }
        return Pair.of(src, dst);
    }

    public void updateMetaGroup(UpdateMetaGroupInfo updateMetaGroupInfo) throws StarException {
        this.updateMetaGroupInternal(updateMetaGroupInfo, false, null);
    }

    private void updateMetaGroupInternal(UpdateMetaGroupInfo updateMetaGroupInfo, boolean isReplay, List<Long> anonymousShardGroupIdsForReplay) throws StarException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            Pair<MetaGroup, MetaGroup> pair = this.verifyUpdateMetaGroupInfo(updateMetaGroupInfo);
            MetaGroup src = (MetaGroup)pair.getKey();
            MetaGroup dst = (MetaGroup)pair.getValue();
            List shardGroupIds = updateMetaGroupInfo.getShardGroupIdsList();
            if (shardGroupIds.isEmpty()) {
                throw new StarException(ExceptionCode.INVALID_ARGUMENT, "empty shard group list.");
            }
            if (src != null) {
                this.verifyShardGroupInfoForMetaGroup(shardGroupIds, src.getShardGroupIds().size());
            }
            int dstSize = -1;
            if (dst != null) {
                int expectSize = -1;
                if (!dst.getShardGroupIds().isEmpty()) {
                    expectSize = dst.getShardGroupIds().size();
                }
                dstSize = this.verifyShardGroupInfoForMetaGroup(shardGroupIds, expectSize);
            }
            ArrayList<ShardGroup> anonymousShardGroups = new ArrayList();
            if (dst != null) {
                if (dst.getShardGroupIds().isEmpty()) {
                    anonymousShardGroups = this.prepareAnonymousShardGroup(dst.getMetaGroupId(), dstSize, dst.getPlacementPolicy(), anonymousShardGroupIdsForReplay);
                } else {
                    for (Long groupId : dst.getShardGroupIds()) {
                        anonymousShardGroups.add(this.shardGroups.get(groupId));
                    }
                }
                this.validateShardReplicaNumInGroup(dst.getPlacementPolicy(), anonymousShardGroups, shardGroupIds);
            }
            if (!isReplay) {
                MetaGroupJournalInfo.Builder journalInfoBuilder = MetaGroupJournalInfo.newBuilder();
                if (dst != null) {
                    MetaGroupInfo.Builder infoBuilder = MetaGroupInfo.newBuilder().mergeFrom(dst.toProtobuf());
                    if (dst.getShardGroupIds().isEmpty()) {
                        List anonymousShardGroupIds = anonymousShardGroups.stream().map(ShardGroup::getGroupId).collect(Collectors.toList());
                        infoBuilder.addAllShardGroupIds(anonymousShardGroupIds);
                    }
                    journalInfoBuilder.setMetaGroupInfo(infoBuilder.build());
                }
                journalInfoBuilder.setUpdateInfo(updateMetaGroupInfo);
                Journal journal = StarMgrJournal.logUpdateMetaGroup(this.serviceId, journalInfoBuilder.build());
                this.journalSystem.write(journal);
            }
            ArrayList finalAnonymousShardGroups = anonymousShardGroups;
            Utils.executeNoExceptionOrDie(() -> {
                if (src != null) {
                    for (Long shardGroupId : shardGroupIds) {
                        ShardGroup shardGroup = this.shardGroups.get(shardGroupId);
                        int idx = 0;
                        for (Long shardId : shardGroup.getShardIds()) {
                            ShardGroup anonymousShardGroup = this.shardGroups.get(src.getShardGroupIds().get(idx));
                            boolean v1 = anonymousShardGroup.removeShardId(shardId);
                            assert (v1);
                            Shard shard = this.shards.get(shardId);
                            boolean v2 = shard.quitGroup(anonymousShardGroup.getGroupId());
                            assert (v2);
                            ++idx;
                        }
                    }
                    this.tryDeleteMetaGroupAfterUpdate(updateMetaGroupInfo, src);
                }
                if (dst != null) {
                    this.commitAnonymousShardGroup(dst, finalAnonymousShardGroups, shardGroupIds);
                }
            });
        }
    }

    private void tryDeleteMetaGroupAfterUpdate(UpdateMetaGroupInfo updateMetaGroupInfo, MetaGroup metaGroup) {
        boolean deleteIfEmpty = false;
        switch (updateMetaGroupInfo.getInfoCase()) {
            case QUIT_INFO: {
                deleteIfEmpty = updateMetaGroupInfo.getQuitInfo().getDeleteMetaGroupIfEmpty();
                break;
            }
            case TRANSFER_INFO: {
                deleteIfEmpty = updateMetaGroupInfo.getTransferInfo().getDeleteSrcMetaGroupIfEmpty();
            }
        }
        if (!deleteIfEmpty) {
            return;
        }
        List<Long> anonymousShardGroupIds = metaGroup.getShardGroupIds();
        for (Long groupId : anonymousShardGroupIds) {
            ShardGroup shardGroup = this.shardGroups.get(groupId);
            assert (shardGroup != null);
            if (shardGroup.getShardIds().isEmpty()) continue;
            return;
        }
        this.deleteMetaGroupInternal(metaGroup.getMetaGroupId(), true);
    }

    public MetaGroupInfo getMetaGroupInfo(long metaGroupId) throws StarException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            MetaGroup metaGroup = this.metaGroups.get(metaGroupId);
            if (metaGroup == null) {
                throw new NotExistStarException("meta group {} not exist.", new Object[]{metaGroupId});
            }
            MetaGroupInfo metaGroupInfo = metaGroup.toProtobuf();
            return metaGroupInfo;
        }
    }

    public List<MetaGroupInfo> listMetaGroupInfo() throws StarException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            ArrayList<MetaGroupInfo> metaGroupInfos = new ArrayList<MetaGroupInfo>();
            for (MetaGroup metaGroup : this.metaGroups.values()) {
                metaGroupInfos.add(metaGroup.toProtobuf());
            }
            ArrayList<MetaGroupInfo> arrayList = metaGroupInfos;
            return arrayList;
        }
    }

    public boolean isMetaGroupStable(long metaGroupId, List<Long> workerIds) throws StarException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            MetaGroup metaGroup = this.metaGroups.get(metaGroupId);
            if (metaGroup == null) {
                throw new NotExistStarException("meta group {} not exist.", new Object[]{metaGroupId});
            }
            if (metaGroup.getPlacementPolicy() != PlacementPolicy.PACK) {
                boolean bl = true;
                return bl;
            }
            if (workerIds.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            for (long groupId : metaGroup.getShardGroupIds()) {
                if (this.isShardGroupStableInternal(metaGroupId, groupId, workerIds)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private boolean isShardGroupStableInternal(long metaGroupId, long groupId, List<Long> workerIds) throws StarException {
        ShardGroup group = this.shardGroups.get(groupId);
        if (group == null) {
            throw new InternalErrorStarException("meta group:{} internal state error, subgroup: {}!", new Object[]{metaGroupId, groupId});
        }
        if (group.getPlacementPolicy() != PlacementPolicy.PACK) {
            throw new InternalErrorStarException("meta group:{} internal state error, subgroup: {}!", new Object[]{metaGroupId, groupId});
        }
        List<Long> compareList = null;
        for (long shardId : group.getShardIds()) {
            Shard shard = this.shards.get(shardId);
            if (shard == null) {
                throw new InternalErrorStarException("meta group:{} internal state error, sub-shard: {}!", new Object[]{metaGroupId, shardId});
            }
            List<Long> replicaList = shard.getReplicaWorkerIds();
            replicaList.retainAll(workerIds);
            replicaList.sort(null);
            if (compareList == null) {
                compareList = replicaList;
                continue;
            }
            if (compareList.equals(replicaList)) continue;
            return false;
        }
        return true;
    }

    public void scheduleShardsBelongToWorker(long workerId) {
        List<Long> shardIds;
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            shardIds = this.shards.entrySet().stream().filter(x -> ((Shard)x.getValue()).hasReplica(workerId)).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        if (!shardIds.isEmpty()) {
            this.shardScheduler.scheduleAsyncAddToWorker(this.serviceId, shardIds, workerId);
        }
    }

    public void addShardReplicas(List<Long> shardIds, long workerId, boolean isTemp) {
        ShardReplicaOp op = isTemp ? ShardReplicaOp.ADD_TEMP : ShardReplicaOp.ADD;
        this.updateShardReplicaInfoInternal(shardIds, workerId, op);
    }

    public void removeShardReplicas(List<Long> shardIds, long workerId) {
        this.updateShardReplicaInfoInternal(shardIds, workerId, ShardReplicaOp.DELETE);
    }

    public void scaleInShardReplicas(List<Long> shardIds, long workerId) {
        this.updateShardReplicaInfoInternal(shardIds, workerId, ShardReplicaOp.SCALE_IN);
    }

    public void scaleOutShardReplicas(List<Long> shardIds, long workerId, boolean isTemp) {
        ShardReplicaOp op = isTemp ? ShardReplicaOp.SCALE_OUT_TEMP : ShardReplicaOp.SCALE_OUT;
        this.updateShardReplicaInfoInternal(shardIds, workerId, op);
    }

    public void scaleOutShardReplicasDone(List<Long> shardIds, long workerId) {
        this.updateShardReplicaInfoInternal(shardIds, workerId, ShardReplicaOp.SCALE_OUT_DONE);
    }

    public void convertTempShardReplicaToNormal(List<Long> shardIds, long workerId) {
        this.updateShardReplicaInfoInternal(shardIds, workerId, ShardReplicaOp.TEMP_TO_NORMAL);
    }

    private void updateShardReplicaInfoInternal(List<Long> shardIds, long workerId, ShardReplicaOp op) {
        if (shardIds.isEmpty()) {
            return;
        }
        BiFunction<Shard, Long, Boolean> biFunc = shardReplicaBinFuncMap.get((Object)op);
        Preconditions.checkNotNull(biFunc, (Object)("Unknown ShardReplicaOp op: " + (Object)((Object)op)));
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            ArrayList<Shard> shardsToUpdate = new ArrayList<Shard>();
            ArrayList<Long> missingIds = new ArrayList<Long>();
            for (Long shardId : shardIds) {
                Shard shard = this.shards.get(shardId);
                if (shard == null) {
                    missingIds.add(shardId);
                    continue;
                }
                if (!biFunc.apply(shard, workerId).booleanValue()) continue;
                shardsToUpdate.add(shard);
            }
            if (!shardsToUpdate.isEmpty()) {
                try {
                    Journal journal = StarMgrJournal.logUpdateShard(this.serviceId, shardsToUpdate);
                    this.journalSystem.writeAsync(journal);
                }
                catch (StarException e) {
                    List shardIdsToPrint = shardsToUpdate.stream().map(Shard::getShardId).collect(Collectors.toList());
                    LOG.error("log shard info after schedule failed, {}. shards:{}, service:{}.", (Object)e.getMessage(), shardIdsToPrint, (Object)this.serviceId);
                }
            }
            if (!missingIds.isEmpty()) {
                LOG.warn("shard {} not exist when update shard info from shard scheduler!", missingIds);
            }
        }
    }

    public void validateWorkerReportedReplicas(List<Long> shardIds, long workerId) {
        if (shardIds.isEmpty()) {
            return;
        }
        ArrayList<Long> missingIds = new ArrayList<Long>();
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            shardIds.forEach(x -> {
                Shard shard = this.shards.get(x);
                if (shard == null || !shard.hasReplica(workerId)) {
                    missingIds.add((Long)x);
                }
            });
        }
        if (!missingIds.isEmpty()) {
            LOG.debug("shard {} not exist or have outdated info when update shard info from worker heartbeat, schedule remove from worker {}.", missingIds, (Object)workerId);
            this.shardScheduler.scheduleAsyncRemoveFromWorker(this.serviceId, missingIds, workerId);
        }
    }

    public void replayCreateShard(CreateShardJournalInfo info) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            ArrayList<Shard> shardList = new ArrayList<Shard>();
            for (ShardInfo shardInfo : info.getShardInfosList()) {
                Shard shard = Shard.fromProtobuf(shardInfo);
                shardList.add(shard);
            }
            ArrayList<ShardGroup> anonymousShardGroups = new ArrayList<ShardGroup>();
            for (ShardGroupInfo shardGroupInfo : info.getShardGroupInfosList()) {
                ShardGroup shardGroup = ShardGroup.fromProtobuf(shardGroupInfo);
                anonymousShardGroups.add(shardGroup);
            }
            this.commitCreateShard(shardList, anonymousShardGroups);
        }
    }

    public void replayDeleteShard(List<Long> shardIds) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            for (Long shardId : shardIds) {
                Shard shard = this.shards.get(shardId);
                if (shard == null) {
                    LOG.warn("shard {} not exist when replay delete shard, just ignore.", (Object)shardId);
                    continue;
                }
                Shard old = this.removeShardInternalNoLock(shard);
                assert (old != null);
            }
        }
    }

    public void replayUpdateShard(List<Shard> shardList) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            for (Shard shard : shardList) {
                Shard old = this.addShardInternalNoLock(shard);
                if (old != null) continue;
                LogUtils.fatal(LOG, "shard {} not exist when replay update shard, should not happen!", shard.getShardId());
            }
        }
    }

    public void replayCreateShardGroup(List<ShardGroup> groups) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            for (ShardGroup shardGroup : groups) {
                ShardGroup old = this.operateShardGroupInternal(shardGroup.getGroupId(), shardGroup, true);
                if (old == null) continue;
                LogUtils.fatal(LOG, "shard group {} already exist when replay create shard group, should not happen!", shardGroup.getGroupId());
            }
        }
    }

    public void replayDeleteShardGroup(DeleteShardGroupInfo info) {
        this.deleteShardGroupInternal(info.getGroupIdsList(), info.getCascadeDeleteShard(), true);
    }

    public void replayUpdateShardGroup(List<ShardGroup> groupList) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            for (ShardGroup shardGroup : groupList) {
                ShardGroup old = this.shardGroups.put(shardGroup.getGroupId(), shardGroup);
                if (old != null) continue;
                LogUtils.fatal(LOG, "shard group {} not exist when replay update shard group, should not happen!", shardGroup.getGroupId());
            }
        }
    }

    public void replayCreateMetaGroup(MetaGroupJournalInfo info) throws StarException {
        CreateMetaGroupInfo createMetaGroupInfo = info.getCreateInfo();
        MetaGroup metaGroup = MetaGroup.fromProtobuf(info.getMetaGroupInfo());
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            long metaGroupId = metaGroup.getMetaGroupId();
            if (this.metaGroups.containsKey(metaGroupId)) {
                throw new StarException(ExceptionCode.ALREADY_EXIST, String.format("meta group %d already exists.", metaGroupId));
            }
            List<ShardGroup> anonymousShardGroups = new ArrayList<ShardGroup>();
            List shardGroupIds = createMetaGroupInfo.getShardGroupIdsList();
            if (!shardGroupIds.isEmpty()) {
                int size = this.verifyShardGroupInfoForMetaGroup(shardGroupIds, -1);
                anonymousShardGroups = this.prepareAnonymousShardGroup(metaGroupId, size, metaGroup.getPlacementPolicy(), metaGroup.getShardGroupIds());
            }
            this.commitAnonymousShardGroup(metaGroup, anonymousShardGroups, shardGroupIds);
            this.metaGroups.put(metaGroupId, metaGroup);
        }
    }

    public void replayDeleteMetaGroup(MetaGroupJournalInfo info) throws StarException {
        long metaGroupId = info.getDeleteInfo().getMetaGroupId();
        this.deleteMetaGroupInternal(metaGroupId, true);
    }

    public void replayUpdateMetaGroup(MetaGroupJournalInfo info) throws StarException {
        UpdateMetaGroupInfo updateMetaGroupInfo = info.getUpdateInfo();
        MetaGroup dstMetaGroup = MetaGroup.fromProtobuf(info.getMetaGroupInfo());
        this.updateMetaGroupInternal(updateMetaGroupInfo, true, dstMetaGroup.getShardGroupIds());
    }

    public int getShardCount() {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            int n = this.shards.size();
            return n;
        }
    }

    public int getShardGroupCount() {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            int n = this.shardGroups.size();
            return n;
        }
    }

    public int getMetaGroupCount() {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            int n = this.metaGroups.size();
            return n;
        }
    }

    public void overrideShards(Map<Long, Shard> shards) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            this.shardGroups.clear();
            for (Shard shard : shards.values()) {
                for (Long groupId : shard.getGroupIds()) {
                    ShardGroup shardGroup = this.shardGroups.get(groupId);
                    if (shardGroup == null) {
                        shardGroup = new ShardGroup(this.serviceId, groupId);
                        this.operateShardGroupInternal(shardGroup.getGroupId(), shardGroup, true);
                    }
                    shardGroup.addShardId(shard.getShardId());
                }
            }
            this.shards.clear();
            this.shards.putAll(shards);
            this.totalShardGauge.set((double)shards.size());
        }
    }

    public void dumpMeta(OutputStream out) throws IOException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.readLock());){
            LOG.debug("start dump shard manager meta data ...");
            ShardManagerImageMetaHeader header = ShardManagerImageMetaHeader.newBuilder().setDigestAlgorithm("MD5").setNumShard(this.shards.size()).setNumShardGroup(this.shardGroups.size()).setNumMetaGroup(this.metaGroups.size()).build();
            header.writeDelimitedTo(out);
            DigestOutputStream mdStream = Utils.getDigestOutputStream(out, "MD5");
            try (SectionWriter writer = new SectionWriter((OutputStream)mdStream);){
                try (OutputStream stream = writer.appendSection(SectionType.SECTION_SHARDMGR_META_GROUP);){
                    this.dumpMetaGroups(stream);
                }
                stream = writer.appendSection(SectionType.SECTION_SHARDMGR_SHARD_GROUP);
                var9_13 = null;
                try {
                    this.dumpShardGroups(stream);
                }
                catch (Throwable throwable) {
                    var9_13 = throwable;
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        if (var9_13 != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable) {
                                var9_13.addSuppressed(throwable);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
                stream = writer.appendSection(SectionType.SECTION_SHARDMGR_SHARD);
                var9_13 = null;
                try {
                    this.dumpShards(stream);
                }
                catch (Throwable throwable) {
                    var9_13 = throwable;
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        if (var9_13 != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable) {
                                var9_13.addSuppressed(throwable);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
            }
            mdStream.flush();
            ShardManagerImageMetaFooter.Builder footerBuilder = ShardManagerImageMetaFooter.newBuilder();
            if (mdStream.getMessageDigest() != null) {
                footerBuilder.setChecksum(ByteString.copyFrom((byte[])mdStream.getMessageDigest().digest()));
            }
            footerBuilder.build().writeDelimitedTo(out);
            LOG.debug("end dump shard manager meta data.");
        }
    }

    public void loadMeta(InputStream in) throws IOException {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            LOG.debug("start load shard manager meta data ...");
            ShardManagerImageMetaHeader header = ShardManagerImageMetaHeader.parseDelimitedFrom((InputStream)in);
            if (header == null) {
                throw new EOFException();
            }
            DigestInputStream digestInput = Utils.getDigestInputStream(in, header.getDigestAlgorithm());
            try (SectionReader reader = new SectionReader((InputStream)digestInput);){
                reader.forEach(x -> this.loadShardManagerSection((Section)x, header));
            }
            ShardManagerImageMetaFooter footer = ShardManagerImageMetaFooter.parseDelimitedFrom((InputStream)in);
            if (footer == null) {
                throw new EOFException();
            }
            Utils.validateChecksum(digestInput.getMessageDigest(), footer.getChecksum());
            LOG.debug("end load shard manager meta data.");
        }
    }

    private void loadShardManagerSection(Section section, ShardManagerImageMetaHeader header) throws IOException {
        switch (section.getHeader().getSectionType()) {
            case SECTION_SHARDMGR_SHARD: {
                this.loadShards(section.getStream(), header.getNumShard());
                break;
            }
            case SECTION_SHARDMGR_SHARD_GROUP: {
                this.loadShardGroups(section.getStream(), header.getNumShardGroup());
                break;
            }
            case SECTION_SHARDMGR_META_GROUP: {
                this.loadMetaGroups(section.getStream(), header.getNumMetaGroup());
                break;
            }
            default: {
                LOG.warn("Unknown section type:{} when loadMeta in ShardManager, ignore it!", (Object)section.getHeader().getSectionType());
            }
        }
    }

    private void dumpMetaGroups(OutputStream stream) throws IOException {
        for (MetaGroup mg : this.metaGroups.values()) {
            mg.toProtobuf().writeDelimitedTo(stream);
        }
    }

    private void loadMetaGroups(InputStream stream, int numMetaGroup) throws IOException {
        for (int i = 0; i < numMetaGroup; ++i) {
            MetaGroupInfo info = MetaGroupInfo.parseDelimitedFrom((InputStream)stream);
            if (info == null) {
                throw new EOFException();
            }
            MetaGroup metaGroup = MetaGroup.fromProtobuf(info);
            this.metaGroups.put(metaGroup.getMetaGroupId(), metaGroup);
        }
    }

    private void dumpShardGroups(OutputStream stream) throws IOException {
        for (ShardGroup group : this.shardGroups.values()) {
            group.toProtobuf().writeDelimitedTo(stream);
        }
    }

    private void loadShardGroups(InputStream stream, int numShardGroup) throws IOException {
        for (int i = 0; i < numShardGroup; ++i) {
            ShardGroupInfo info = ShardGroupInfo.parseDelimitedFrom((InputStream)stream);
            if (info == null) {
                throw new EOFException();
            }
            ShardGroup shardGroup = ShardGroup.fromProtobuf(info);
            this.operateShardGroupInternal(shardGroup.getGroupId(), shardGroup, true);
        }
    }

    private void dumpShards(OutputStream stream) throws IOException {
        for (Shard shard : this.shards.values()) {
            shard.toProtobuf().writeDelimitedTo(stream);
        }
    }

    private void loadShards(InputStream stream, int numShard) throws IOException {
        for (int i = 0; i < numShard; ++i) {
            ShardInfo info = ShardInfo.parseDelimitedFrom((InputStream)stream);
            if (info == null) {
                throw new EOFException();
            }
            Shard shard = Shard.fromProtobuf(info);
            Shard old = this.addShardInternalNoLock(shard);
            assert (old == null);
        }
    }

    public void updateDelegatedFileStoreSnapshot(FileStore fileStore) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            this.setOrUpdateFileStoreSnapshotInternal(fileStore);
        }
    }

    public void replaceDelegatedFileStoreSnapshot(FileStore fileStore) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
            this.setOrReplaceFileStoreSnapshotInternal(fileStore);
        }
    }

    private FileStore setOrUpdateFileStoreSnapshotInternal(FileStore fileStore) {
        DelegatedFileStore fs = this.shardFileStoreSnapshot.get(fileStore.key());
        if (fs == null) {
            DelegatedFileStore copy = new DelegatedFileStore(FileStore.fromProtobuf(fileStore.toProtobuf()));
            this.shardFileStoreSnapshot.put(fileStore.key(), copy);
            return this.shardFileStoreSnapshot.get(fileStore.key());
        }
        if (fileStore.type() != fs.type()) {
            LOG.warn("Unexpected fileStore type mismatch. fsKey: {}, fsType:{} != fsType:{}", (Object)fileStore.key(), (Object)fs.type(), (Object)fileStore.type());
            return fileStore;
        }
        if (fs.getVersion() < fileStore.getVersion()) {
            fs.swapDelegation(fileStore.toProtobuf());
        }
        return fs;
    }

    private FileStore setOrReplaceFileStoreSnapshotInternal(FileStore fileStore) {
        DelegatedFileStore fs = this.shardFileStoreSnapshot.get(fileStore.key());
        if (fs == null) {
            DelegatedFileStore copy = new DelegatedFileStore(FileStore.fromProtobuf(fileStore.toProtobuf()));
            this.shardFileStoreSnapshot.put(fileStore.key(), copy);
            return this.shardFileStoreSnapshot.get(fileStore.key());
        }
        if (fs.getVersion() < fileStore.getVersion()) {
            fs.swapDelegation(fileStore.toProtobuf());
        }
        return fs;
    }

    public void updateShardReplicaInfo(long workerId, List<ReplicaUpdateInfo> replicaUpdateInfos) {
        List<Long> shardIds = replicaUpdateInfos.stream().map(ReplicaUpdateInfo::getShardId).collect(Collectors.toList());
        this.updateShardReplicaInfoInternal(shardIds, workerId, ShardReplicaOp.SCALE_OUT_DONE);
    }

    public void dump(DataOutputStream out) throws IOException {
        List<Long> metaGroupIds = this.getAllMetaGroupIds();
        for (long groupId : metaGroupIds) {
            MetaGroup metaGroup = this.getMetaGroup(groupId);
            if (metaGroup == null) continue;
            String s = JsonFormat.printer().print((MessageOrBuilder)metaGroup.toProtobuf()) + "\n";
            out.writeBytes(s);
        }
        List<Long> shardGroupIds = this.getAllShardGroupIds();
        for (long groupId : shardGroupIds) {
            ShardGroup shardGroup = this.getShardGroup(groupId);
            if (shardGroup == null) continue;
            String s = JsonFormat.printer().print((MessageOrBuilder)shardGroup.toProtobuf()) + "\n";
            out.writeBytes(s);
        }
        List<Long> shardIds = this.getAllShardIds();
        for (long shardId : shardIds) {
            Shard shard = this.getShard(shardId);
            if (shard == null) continue;
            String s = JsonFormat.printer().print((MessageOrBuilder)shard.toDebugProtobuf()) + "\n";
            out.writeBytes(s);
        }
    }

    private ShardGroup operateShardGroupInternal(long shardGroupId, ShardGroup shardGroup, boolean isAdd) {
        Preconditions.checkState((boolean)this.lock.isWriteLockedByCurrentThread());
        ShardGroup prev = null;
        prev = isAdd ? this.shardGroups.put(shardGroupId, shardGroup) : this.shardGroups.remove(shardGroupId);
        this.totalShardGroupGauge.set((double)this.shardGroups.size());
        return prev;
    }

    public void removeShardGroupReplicas(Long shardGroupId) throws StarException {
        block16: {
            try (LockCloseable ignored = new LockCloseable((Lock)this.lock.writeLock());){
                ShardGroup shardGroup = this.getShardGroup(shardGroupId);
                List<Long> shardIds = shardGroup.getShardIds();
                ArrayList<Shard> shardsToUpdate = new ArrayList<Shard>();
                HashMap<Long, ImmutableList<Replica>> originReplicasInfo = new HashMap<Long, ImmutableList<Replica>>();
                for (Long shardId : shardIds) {
                    Shard shard = this.getShard(shardId);
                    originReplicasInfo.put(shardId, shard.getReplica());
                    shard.setReplicas(new ArrayList<Replica>());
                    shardsToUpdate.add(shard);
                }
                if (shardsToUpdate.isEmpty()) break block16;
                try {
                    Journal journal = StarMgrJournal.logUpdateShard(this.serviceId, shardsToUpdate);
                    this.journalSystem.write(journal);
                }
                catch (StarException e) {
                    for (Shard shard : shardsToUpdate) {
                        shard.setReplicas((List)originReplicasInfo.get(shard.getShardId()));
                    }
                    throw e;
                }
            }
        }
    }

    private static enum ShardReplicaOp {
        ADD,
        ADD_TEMP,
        DELETE,
        SCALE_OUT,
        SCALE_OUT_TEMP,
        SCALE_IN,
        SCALE_OUT_DONE,
        TEMP_TO_NORMAL;

    }
}

