/*
 * Decompiled with CFR 0.152.
 */
package com.staros.shard;

import com.staros.proto.PlacementPolicy;
import com.staros.proto.ShardGroupInfo;
import com.staros.util.LockCloseable;
import com.staros.util.Text;
import com.staros.util.Writable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public class ShardGroup
implements Writable {
    private static final long SET_INDEX_THRESHOLD = 4096L;
    private final String serviceId;
    private final long groupId;
    private final PlacementPolicy policy;
    private List<Long> shardIds;
    private Set<Long> shardIdSet;
    private final boolean anonymous;
    private final long metaGroupId;
    private final Map<String, String> labels;
    private final Map<String, String> properties;
    private final ReentrantReadWriteLock lock;

    public ShardGroup(String serviceId, long groupId) {
        this(serviceId, groupId, PlacementPolicy.NONE, false, 0L);
    }

    public ShardGroup(String serviceId, long groupId, PlacementPolicy policy, boolean anonymous, long metaGroupId) {
        this(serviceId, groupId, policy, anonymous, metaGroupId, null, null);
    }

    public ShardGroup(String serviceId, long groupId, PlacementPolicy policy, boolean anonymous, long metaGroupId, Map<String, String> labels, Map<String, String> properties) {
        this.serviceId = serviceId;
        this.groupId = groupId;
        this.policy = policy;
        this.shardIds = Collections.unmodifiableList(new ArrayList());
        this.shardIdSet = null;
        this.anonymous = anonymous;
        this.metaGroupId = metaGroupId;
        this.labels = new HashMap<String, String>();
        this.properties = new HashMap<String, String>();
        this.lock = new ReentrantReadWriteLock();
        if (labels != null) {
            this.labels.putAll(labels);
        }
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public ShardGroup(ShardGroupInfo info) {
        this(info.getServiceId(), info.getGroupId(), info.getPolicy(), info.getAnonymous(), info.getMetaGroupId(), info.getLabelsMap(), info.getPropertiesMap());
        this.shardIds = Collections.unmodifiableList(new ArrayList(info.getShardIdsList()));
        this.mayBuildShardIdSet();
    }

    private void mayBuildShardIdSet() {
        if ((long)this.shardIds.size() > 4096L) {
            this.shardIdSet = new HashSet<Long>(this.shardIds);
        }
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public long getGroupId() {
        return this.groupId;
    }

    private boolean contains(long shardId) {
        if (this.shardIdSet != null) {
            return this.shardIdSet.contains(shardId);
        }
        return this.shardIds.contains(shardId);
    }

    public boolean addShardId(long shardId) {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.writeLock());){
            if (this.contains(shardId)) {
                boolean bl = false;
                return bl;
            }
            ArrayList<Long> newList = new ArrayList<Long>(this.shardIds);
            newList.add(shardId);
            this.shardIds = Collections.unmodifiableList(newList);
            if (this.shardIdSet != null) {
                this.shardIdSet.add(shardId);
            } else {
                this.mayBuildShardIdSet();
            }
            boolean bl = true;
            return bl;
        }
    }

    public List<Long> batchAddShardId(List<Long> addShardIds) {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.writeLock());){
            List<Long> todoShardIds = this.shardIdSet != null ? addShardIds.stream().filter(x -> !this.shardIdSet.contains(x)).collect(Collectors.toList()) : addShardIds.stream().filter(x -> !this.shardIds.contains(x)).collect(Collectors.toList());
            if (!todoShardIds.isEmpty()) {
                ArrayList<Long> newList = new ArrayList<Long>(this.shardIds.size() + todoShardIds.size());
                newList.addAll(this.shardIds);
                newList.addAll(todoShardIds);
                this.shardIds = Collections.unmodifiableList(newList);
                if (this.shardIdSet != null) {
                    this.shardIdSet.addAll(todoShardIds);
                } else {
                    this.mayBuildShardIdSet();
                }
            }
            List<Long> list = todoShardIds;
            return list;
        }
    }

    public boolean removeShardId(long shardId) {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.writeLock());){
            if (!this.contains(shardId)) {
                boolean bl = false;
                return bl;
            }
            ArrayList<Long> newList = new ArrayList<Long>(this.shardIds);
            newList.remove(shardId);
            this.shardIds = Collections.unmodifiableList(newList);
            if (this.shardIdSet != null) {
                this.shardIdSet.remove(shardId);
            }
            boolean bl = true;
            return bl;
        }
    }

    public List<Long> getShardIds() {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            List<Long> list = this.shardIds;
            return list;
        }
    }

    public PlacementPolicy getPlacementPolicy() {
        return this.policy;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public long getMetaGroupId() {
        return this.metaGroupId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String propKey) {
        return this.properties.get(propKey);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getLabel(String labelKey) {
        return this.labels.get(labelKey);
    }

    public ShardGroupInfo toProtobuf() {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            ShardGroupInfo info;
            ShardGroupInfo shardGroupInfo = info = ShardGroupInfo.newBuilder().setServiceId(this.serviceId).setGroupId(this.groupId).addAllShardIds(this.shardIds).setPolicy(this.policy).setAnonymous(this.anonymous).setMetaGroupId(this.metaGroupId).putAllLabels(this.labels).putAllProperties(this.properties).build();
            return shardGroupInfo;
        }
    }

    public static ShardGroup fromProtobuf(ShardGroupInfo info) {
        return new ShardGroup(info);
    }

    public void write(DataOutput out) throws IOException {
        byte[] bytes = this.toProtobuf().toByteArray();
        Text.writeBytes((DataOutput)out, (byte[])bytes);
    }

    public static ShardGroup read(DataInput in) throws IOException {
        byte[] bytes = Text.readBytes((DataInput)in);
        ShardGroupInfo info = ShardGroupInfo.parseFrom((byte[])bytes);
        return ShardGroup.fromProtobuf(info);
    }
}

