/*
 * Decompiled with CFR 0.152.
 */
package com.staros.provisioner;

import com.staros.exception.StarException;
import com.staros.proto.DeleteResourceRequest;
import com.staros.proto.DeleteResourceResponse;
import com.staros.proto.GetResourceRequest;
import com.staros.proto.GetResourceResponse;
import com.staros.proto.NodeInfo;
import com.staros.proto.ProvisionResourceRequest;
import com.staros.proto.ProvisionResourceResponse;
import com.staros.proto.ResourceProvisionerGrpc;
import com.staros.proto.ScaleResourceRequest;
import com.staros.proto.ScaleResourceResponse;
import com.staros.proto.Status;
import com.staros.provisioner.StarProvisionServer;
import io.grpc.stub.StreamObserver;
import java.util.List;

public class StarProvisionService
extends ResourceProvisionerGrpc.ResourceProvisionerImplBase {
    private final StarProvisionServer server;

    public StarProvisionService(StarProvisionServer server) {
        this.server = server;
    }

    public void provisionResource(ProvisionResourceRequest request, StreamObserver<ProvisionResourceResponse> responseObserver) {
        ProvisionResourceResponse.Builder builder = ProvisionResourceResponse.newBuilder();
        try {
            List<NodeInfo> info = this.server.processProvisionResourceRequest(request.getName(), request.getNumOfNodes());
            builder.addAllInfos(info);
        }
        catch (StarException exception) {
            builder.setStatus(Status.newBuilder().setCode(exception.getExceptionCode().ordinal()).setMessage(exception.getMessage()).build());
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void deleteResource(DeleteResourceRequest request, StreamObserver<DeleteResourceResponse> responseObserver) {
        DeleteResourceResponse.Builder builder = DeleteResourceResponse.newBuilder();
        try {
            this.server.processDeleteResourceRequest(request.getName());
        }
        catch (StarException exception) {
            builder.setStatus(Status.newBuilder().setCode(exception.getExceptionCode().ordinal()).setMessage(exception.getMessage()).build());
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void getResource(GetResourceRequest request, StreamObserver<GetResourceResponse> responseObserver) {
        GetResourceResponse.Builder builder = GetResourceResponse.newBuilder();
        try {
            List<NodeInfo> hosts = this.server.processGetResourceRequest(request.getName());
            builder.addAllInfos(hosts);
        }
        catch (StarException exception) {
            builder.setStatus(Status.newBuilder().setCode(exception.getExceptionCode().ordinal()).setMessage(exception.getMessage()).build());
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void scaleResource(ScaleResourceRequest request, StreamObserver<ScaleResourceResponse> responseObserver) {
        ScaleResourceResponse.Builder builder = ScaleResourceResponse.newBuilder();
        try {
            List<NodeInfo> hosts = this.server.processScaleResourceRequest(request.getName(), request.getNumOfNodes());
            builder.addAllInfos(hosts);
        }
        catch (StarException exception) {
            builder.setStatus(Status.newBuilder().setCode(exception.getExceptionCode().ordinal()).setMessage(exception.getMessage()).build());
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }
}

