/*
 * Decompiled with CFR 0.152.
 */
package com.staros.shard;

import com.staros.proto.MetaGroupInfo;
import com.staros.proto.PlacementPolicy;
import com.staros.util.LockCloseable;
import com.staros.util.Text;
import com.staros.util.Writable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MetaGroup
implements Writable {
    private final String serviceId;
    private final long metaGroupId;
    private List<Long> shardGroupIds;
    private final PlacementPolicy placementPolicy;
    private final ReentrantReadWriteLock lock;

    public MetaGroup(String serviceId, long metaGroupId, List<Long> shardGroupIds, PlacementPolicy placementPolicy) {
        this.serviceId = serviceId;
        this.metaGroupId = metaGroupId;
        this.shardGroupIds = Collections.unmodifiableList(new ArrayList<Long>(shardGroupIds));
        this.placementPolicy = placementPolicy;
        this.lock = new ReentrantReadWriteLock();
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public long getMetaGroupId() {
        return this.metaGroupId;
    }

    public void setShardGroupIds(List<Long> shardGroupIds) {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.writeLock());){
            this.shardGroupIds = Collections.unmodifiableList(new ArrayList<Long>(shardGroupIds));
        }
    }

    public List<Long> getShardGroupIds() {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            List<Long> list = this.shardGroupIds;
            return list;
        }
    }

    public PlacementPolicy getPlacementPolicy() {
        return this.placementPolicy;
    }

    public MetaGroupInfo toProtobuf() {
        try (LockCloseable ignore = new LockCloseable((Lock)this.lock.readLock());){
            MetaGroupInfo info;
            MetaGroupInfo metaGroupInfo = info = MetaGroupInfo.newBuilder().setServiceId(this.serviceId).setMetaGroupId(this.metaGroupId).addAllShardGroupIds(this.shardGroupIds).setPlacementPolicy(this.placementPolicy).build();
            return metaGroupInfo;
        }
    }

    public static MetaGroup fromProtobuf(MetaGroupInfo info) {
        return new MetaGroup(info.getServiceId(), info.getMetaGroupId(), info.getShardGroupIdsList(), info.getPlacementPolicy());
    }

    public void write(DataOutput out) throws IOException {
        byte[] bytes = this.toProtobuf().toByteArray();
        Text.writeBytes((DataOutput)out, (byte[])bytes);
    }

    public static MetaGroup read(DataInput in) throws IOException {
        byte[] bytes = Text.readBytes((DataInput)in);
        MetaGroupInfo info = MetaGroupInfo.parseFrom((byte[])bytes);
        return MetaGroup.fromProtobuf(info);
    }
}

