/*
 * Decompiled with CFR 0.152.
 */
package com.staros.worker;

import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.staros.exception.InvalidArgumentStarException;
import com.staros.exception.NotExistStarException;
import com.staros.proto.DeleteResourceRequest;
import com.staros.proto.DeleteResourceResponse;
import com.staros.proto.NodeInfo;
import com.staros.proto.ProvisionResourceRequest;
import com.staros.proto.ProvisionResourceResponse;
import com.staros.proto.ResourceProvisionerGrpc;
import com.staros.proto.ScaleResourceRequest;
import com.staros.proto.ScaleResourceResponse;
import com.staros.proto.Status;
import com.staros.proto.WorkerGroupSpec;
import com.staros.proto.WorkerGroupState;
import com.staros.util.Config;
import com.staros.worker.ResourceManager;
import com.staros.worker.WorkerGroup;
import com.staros.worker.WorkerManager;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultResourceManager
implements ResourceManager {
    private static final Logger LOG = LogManager.getLogger(DefaultResourceManager.class);
    private static final String defaultResourceFile = "default_worker_group_spec.json";
    private final WorkerManager workerManager;
    private final ResourceProvisionerGrpc.ResourceProvisionerBlockingStub blockingStub;
    private final ManagedChannel channel;
    private final Map<String, Map<String, String>> specMap;

    public DefaultResourceManager(WorkerManager workerManager, String rpcServerAddress) {
        this.workerManager = workerManager;
        if (rpcServerAddress.isEmpty()) {
            throw new InvalidArgumentStarException("Empty provision service address!");
        }
        String resourceFile = Config.RESOURCE_MANAGER_WORKER_GROUP_SPEC_RESOURCE_FILE;
        if (resourceFile.isEmpty()) {
            resourceFile = defaultResourceFile;
        }
        try {
            LOG.info("Load resource file:{} for worker group spec definition.", (Object)resourceFile);
            String jsonString = Resources.toString((URL)Resources.getResource((String)resourceFile), (Charset)StandardCharsets.UTF_8);
            this.specMap = (Map)new Gson().fromJson(jsonString, new TypeToken<Map<String, Map<String, String>>>(){}.getType());
        }
        catch (IOException exception) {
            LOG.warn("Fail to load resource file: {}", (Object)resourceFile, (Object)exception);
            throw new InvalidArgumentStarException("Invalid resource file:{} content!", new Object[]{resourceFile});
        }
        LOG.info("Using {} as resource provision server!", (Object)rpcServerAddress);
        this.channel = ManagedChannelBuilder.forTarget((String)rpcServerAddress).maxInboundMessageSize(Config.GRPC_CHANNEL_MAX_MESSAGE_SIZE).usePlaintext().build();
        this.blockingStub = ResourceProvisionerGrpc.newBlockingStub((Channel)this.channel);
    }

    @Override
    public void provisionResource(String serviceId, long groupId, WorkerGroupSpec spec, String owner) {
        Map<String, String> sizeConfig = this.getSpecDetails(spec);
        int numOfNodes = Integer.parseInt(sizeConfig.get("num_of_nodes"));
        ProvisionResourceRequest request = ProvisionResourceRequest.newBuilder().setName(String.valueOf(groupId)).setNumOfNodes(numOfNodes).setCpus(sizeConfig.get("cpus")).setMemories(sizeConfig.get("memories")).setImage(sizeConfig.get("image")).build();
        try {
            ProvisionResourceResponse response = this.blockingStub.provisionResource(request);
            Status status = response.getStatus();
            if (status.getCode() != 0) {
                LOG.error("provisionResource RPC fails for request service:{}, group:{},  error with code:{}, message:{}", (Object)serviceId, (Object)groupId, (Object)status.getCode(), (Object)status.getMessage());
                return;
            }
            List nodes = response.getInfosList();
            this.workerManager.addWorkers(serviceId, groupId, nodes.stream().map(NodeInfo::getHost).collect(Collectors.toList()));
            WorkerGroup group = this.workerManager.getWorkerGroupNoException(serviceId, groupId);
            if (group != null) {
                group.updateState(WorkerGroupState.READY);
            }
        }
        catch (Exception exception) {
            LOG.warn("Fail to send provisioning request for service:{}, group:{}. Error:", (Object)serviceId, (Object)groupId, (Object)exception);
        }
    }

    @Override
    public void alterResourceSpec(String serviceId, long groupId, WorkerGroupSpec spec) {
        Map<String, String> sizeConfig = this.getSpecDetails(spec);
        int numOfNodes = Integer.parseInt(sizeConfig.get("num_of_nodes"));
        ScaleResourceRequest request = ScaleResourceRequest.newBuilder().setName(String.valueOf(groupId)).setNumOfNodes(numOfNodes).setCpus(sizeConfig.get("cpus")).setMemories(sizeConfig.get("memories")).setImage(sizeConfig.get("image")).build();
        try {
            Object node2;
            ScaleResourceResponse response = this.blockingStub.scaleResource(request);
            Status status = response.getStatus();
            if (status.getCode() != 0) {
                LOG.error("ScaleResource RPC fails for request service:{}, group:{},  error with code:{}, message:{}", (Object)serviceId, (Object)groupId, (Object)status.getCode(), (Object)status.getMessage());
                return;
            }
            List nodes = response.getInfosList();
            for (Object node2 : nodes) {
                try {
                    this.workerManager.getWorkerInfo(node2.getHost());
                }
                catch (NotExistStarException exception) {
                    this.workerManager.addWorker(serviceId, groupId, node2.getHost());
                }
            }
            List hosts = nodes.stream().map(NodeInfo::getHost).collect(Collectors.toList());
            node2 = this.workerManager.getWorkerGroup(serviceId, groupId).getAllWorkerIds(false).iterator();
            while (node2.hasNext()) {
                long id = (Long)node2.next();
                if (hosts.contains(this.workerManager.getWorker(id).getIpPort())) continue;
                this.workerManager.removeWorker(serviceId, groupId, id);
            }
            WorkerGroup group = this.workerManager.getWorkerGroupNoException(serviceId, groupId);
            if (group != null) {
                group.updateState(WorkerGroupState.READY);
            }
        }
        catch (Exception exception) {
            LOG.warn("Fail to send provisioning request for service:{}, group:{}. Error:", (Object)serviceId, (Object)groupId, (Object)exception);
        }
    }

    @Override
    public void releaseResource(String serviceId, long groupId) {
        DeleteResourceRequest request = DeleteResourceRequest.newBuilder().setName(String.valueOf(groupId)).build();
        try {
            DeleteResourceResponse response = this.blockingStub.deleteResource(request);
            Status status = response.getStatus();
            if (status.getCode() != 0) {
                LOG.error("releaseResource RPC fails for request service:{}, group:{},  error with code:{}, message:{}", (Object)serviceId, (Object)groupId, (Object)status.getCode(), (Object)status.getMessage());
            } else {
                LOG.info("releaseResource RPC success for request, service:{}, group:{}", (Object)serviceId, (Object)groupId);
            }
        }
        catch (Exception exception) {
            LOG.warn("Fail to send provisioning request for service:{}, group:{}. Error:", (Object)serviceId, (Object)groupId, (Object)exception);
        }
    }

    @Override
    public boolean isValidSpec(WorkerGroupSpec spec) {
        return this.specMap.containsKey(spec.getSize());
    }

    private Map<String, String> getSpecDetails(WorkerGroupSpec spec) {
        if (!this.isValidSpec(spec)) {
            throw new InvalidArgumentStarException("Unsupported workerGroup spec: {}", new Object[]{spec.getSize()});
        }
        return this.specMap.get(spec.getSize());
    }

    @Override
    public void stop() {
        this.channel.shutdown();
        try {
            this.channel.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            LOG.info("Excepted while waiting for channel shutdown.", (Throwable)exception);
        }
    }
}

