/*
 * Decompiled with CFR 0.152.
 */
package com.staros.journal;

import com.staros.exception.StarException;
import com.staros.journal.Journal;
import com.staros.journal.JournalSystem;
import com.staros.metrics.MetricsSystem;
import io.prometheus.metrics.core.metrics.Counter;
import java.util.concurrent.Future;

public class DelegateJournalSystem
implements JournalSystem {
    private static final Counter METRIC_JOURNAL_WRITE_COUNT = MetricsSystem.registerCounter((String)"starmgr_journal_write_ops", (String)"counter write iops of starmgr journal records");
    private static final Counter METRIC_JOURNAL_WRITE_BYTES = MetricsSystem.registerCounter((String)"starmgr_journal_write_bytes", (String)"number of numbers written to starmgr journal, unit: byte");
    private static final Counter METRIC_JOURNAL_WRITE_ASYNC_COUNT = MetricsSystem.registerCounter((String)"starmgr_journal_write_async_ops", (String)"counter async write iops of starmgr journal records");
    private static final Counter METRIC_JOURNAL_WRITE_ASYNC_BYTES = MetricsSystem.registerCounter((String)"starmgr_journal_write_async_bytes", (String)"number of numbers written to starmgr journal in async mode, unit: byte");
    private final JournalSystem innerJournalSystem;

    public DelegateJournalSystem(JournalSystem journalSystem) {
        this.innerJournalSystem = journalSystem;
    }

    @Override
    public void write(Journal journal) throws StarException {
        this.innerJournalSystem.write(journal);
        METRIC_JOURNAL_WRITE_COUNT.inc();
        METRIC_JOURNAL_WRITE_BYTES.inc(journal.size());
    }

    @Override
    public Future<Boolean> writeAsync(Journal journal) throws StarException {
        Future<Boolean> future = this.innerJournalSystem.writeAsync(journal);
        METRIC_JOURNAL_WRITE_ASYNC_COUNT.inc();
        METRIC_JOURNAL_WRITE_ASYNC_BYTES.inc(journal.size());
        return future;
    }

    @Override
    public void replayTo(long journalId) throws StarException {
        this.innerJournalSystem.replayTo(journalId);
    }

    @Override
    public void setReplayId(long replayId) {
        this.innerJournalSystem.setReplayId(replayId);
    }

    @Override
    public long getReplayId() {
        return this.innerJournalSystem.getReplayId();
    }

    @Override
    public void onBecomeLeader() {
        this.innerJournalSystem.onBecomeLeader();
    }

    @Override
    public void onBecomeFollower() {
        this.innerJournalSystem.onBecomeFollower();
    }
}

