/*
 * Decompiled with CFR 0.152.
 */
package com.staros.filestore;

import com.google.common.base.Preconditions;
import com.staros.credential.ADLS2Credential;
import com.staros.filestore.AbstractFileStore;
import com.staros.filestore.FileStore;
import com.staros.proto.ADLS2FileStoreInfo;
import com.staros.proto.FileStoreInfo;
import com.staros.proto.FileStoreType;
import com.staros.util.LockCloseable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class ADLS2FileStore
extends AbstractFileStore {
    private String endpoint;
    private ADLS2Credential credential;

    @Override
    public FileStoreType type() {
        return FileStoreType.ADLS2;
    }

    @Override
    public boolean isValid() {
        if (this.endpoint.isEmpty()) {
            return false;
        }
        assert (!this.locations.isEmpty());
        String path = ((String)this.locations.get(0)).substring("adls2://".length());
        return !path.isEmpty();
    }

    public ADLS2FileStore(FileStoreInfo fsInfo, String endpoint, ADLS2Credential credential) {
        super(fsInfo);
        this.endpoint = endpoint;
        this.credential = credential;
    }

    public ADLS2FileStore(String key, String name, String endpoint, String path, ADLS2Credential credential) {
        super(key, name);
        this.endpoint = endpoint;
        this.credential = credential;
        this.locations.add("adls2://" + path);
    }

    private FileStoreInfo toProtobufInternal(boolean includeSecret) {
        try (LockCloseable lockCloseable = new LockCloseable((Lock)this.lock.readLock());){
            assert (!this.locations.isEmpty());
            ADLS2FileStoreInfo.Builder adls2Builder = ADLS2FileStoreInfo.newBuilder();
            adls2Builder.setEndpoint(this.endpoint);
            adls2Builder.setPath(((String)this.locations.get(0)).substring("adls2://".length()));
            if (includeSecret) {
                adls2Builder.setCredential(this.credential.toProtobuf());
            }
            FileStoreInfo fileStoreInfo = this.toProtobufBuilder().setFsType(FileStoreType.ADLS2).setAdls2FsInfo(adls2Builder).build();
            return fileStoreInfo;
        }
    }

    @Override
    public FileStoreInfo toProtobuf() {
        return this.toProtobufInternal(true);
    }

    @Override
    public FileStoreInfo toDebugProtobuf() {
        return this.toProtobufInternal(false);
    }

    @Override
    public void mergeFrom(FileStore fileStore) {
        Preconditions.checkArgument((boolean)(fileStore instanceof ADLS2FileStore));
        super.mergeFrom(fileStore);
        ADLS2FileStore otherStore = (ADLS2FileStore)fileStore;
        if (!otherStore.endpoint.isEmpty()) {
            this.endpoint = otherStore.endpoint;
        }
        if (!otherStore.credential.isEmpty()) {
            this.credential = otherStore.credential;
        }
    }

    public static FileStore fromProtobuf(FileStoreInfo fsInfo) {
        ADLS2FileStoreInfo adls2Info = fsInfo.getAdls2FsInfo();
        String endpoint = adls2Info.getEndpoint();
        String path = adls2Info.getPath();
        if (fsInfo.getLocationsList().isEmpty()) {
            List<String> locations = Arrays.asList("adls2://" + path);
            fsInfo = fsInfo.toBuilder().addAllLocations(locations).build();
        }
        ADLS2Credential credential = ADLS2Credential.fromProtobuf(adls2Info.getCredential());
        return new ADLS2FileStore(fsInfo, endpoint, credential);
    }
}

