/*
 * Decompiled with CFR 0.152.
 */
package com.staros.filestore;

import com.google.common.base.Preconditions;
import com.staros.filestore.AbstractFileStore;
import com.staros.filestore.FileStore;
import com.staros.proto.FileStoreInfo;
import com.staros.proto.FileStoreType;
import com.staros.proto.HDFSFileStoreInfo;
import com.staros.util.LockCloseable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public class HDFSFileStore
extends AbstractFileStore {
    private String userName = "";
    private Map<String, String> configuration = new HashMap<String, String>();

    @Override
    public FileStoreType type() {
        return FileStoreType.HDFS;
    }

    @Override
    public String rootPath() {
        assert (!this.locations.isEmpty());
        String url = (String)this.locations.get(0);
        if (!url.endsWith("/")) {
            return url + "/";
        }
        return url;
    }

    @Override
    public boolean isValid() {
        assert (!this.locations.isEmpty());
        String url = (String)this.locations.get(0);
        return !url.isEmpty();
    }

    public HDFSFileStore(FileStoreInfo fsInfo, String userName, Map<String, String> configuration) {
        super(fsInfo);
        this.configuration.putAll(configuration);
        this.userName = userName;
    }

    public HDFSFileStore(String key, String name, String url) {
        super(key, name);
        this.locations.add(url);
    }

    private FileStoreInfo toProtobufInternal(boolean includeSecret) {
        try (LockCloseable lockCloseable = new LockCloseable((Lock)this.lock.readLock());){
            assert (!this.locations.isEmpty());
            HDFSFileStoreInfo.Builder hdfsBuilder = HDFSFileStoreInfo.newBuilder();
            hdfsBuilder.setUrl((String)this.locations.get(0));
            if (!this.userName.isEmpty()) {
                hdfsBuilder.setUsername(this.userName);
            }
            hdfsBuilder.putAllConfiguration(this.configuration);
            FileStoreInfo fileStoreInfo = this.toProtobufBuilder().setFsType(FileStoreType.HDFS).setHdfsFsInfo(hdfsBuilder).build();
            return fileStoreInfo;
        }
    }

    @Override
    public FileStoreInfo toProtobuf() {
        return this.toProtobufInternal(true);
    }

    @Override
    public FileStoreInfo toDebugProtobuf() {
        return this.toProtobufInternal(false);
    }

    @Override
    public void mergeFrom(FileStore fileStore) {
        Preconditions.checkArgument((boolean)(fileStore instanceof HDFSFileStore));
        super.mergeFrom(fileStore);
        HDFSFileStore otherStore = (HDFSFileStore)fileStore;
        if (!this.userName.equals(otherStore.userName)) {
            this.userName = otherStore.userName;
        }
        this.configuration.putAll(otherStore.configuration);
    }

    public static FileStore fromProtobuf(FileStoreInfo fsInfo) {
        HDFSFileStoreInfo hdfsInfo = fsInfo.getHdfsFsInfo();
        String url = hdfsInfo.getUrl();
        if (fsInfo.getLocationsList().isEmpty()) {
            ArrayList<String> locations = new ArrayList<String>(Arrays.asList(url));
            fsInfo = fsInfo.toBuilder().addAllLocations(locations).build();
        }
        String userName = hdfsInfo.getUsername();
        Map configuration = hdfsInfo.getConfigurationMap();
        return new HDFSFileStore(fsInfo, userName, configuration);
    }
}

