/*
 * Decompiled with CFR 0.152.
 */
package com.staros.journal;

import com.google.protobuf.InvalidProtocolBufferException;
import com.staros.exception.ExceptionCode;
import com.staros.exception.StarException;
import com.staros.journal.Journal;
import com.staros.metrics.MetricsSystem;
import com.staros.proto.CreateShardJournalInfo;
import com.staros.proto.DeleteShardGroupInfo;
import com.staros.proto.DeleteWorkerGroupInfo;
import com.staros.proto.FileStoreInfo;
import com.staros.proto.LeaderInfo;
import com.staros.proto.MetaGroupJournalInfo;
import com.staros.proto.OperationType;
import com.staros.proto.UpdateWorkerGroupInfo;
import com.staros.service.Service;
import com.staros.service.ServiceTemplate;
import com.staros.shard.Shard;
import com.staros.shard.ShardGroup;
import com.staros.util.Text;
import com.staros.worker.Worker;
import com.staros.worker.WorkerGroup;
import io.prometheus.metrics.core.metrics.Counter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class StarMgrJournal {
    public static final Counter METRIC_LOG_UPDATE_SHARDS_NUM_COUNTER = MetricsSystem.registerCounter((String)"starmgr_log_update_shards_num", (String)"total number of shards in logUpdateShard in starmgr");
    public static final Counter METRIC_LOG_UPDATE_SHARDS_OPS_COUNTER = MetricsSystem.registerCounter((String)"starmgr_log_update_shards_ops", (String)"total ops of logUpdateShard in starmgr");
    private static final Journal.AbstractJournalOp<Worker> workerOp = new Journal.WritableJournalOp<Worker>(){

        public Worker parseFrom(DataInput in) throws IOException {
            return Worker.read(in);
        }
    };
    private static final Journal.AbstractJournalOp<WorkerGroup> workerGroupOp = new Journal.WritableJournalOp<WorkerGroup>(){

        public WorkerGroup parseFrom(DataInput in) throws IOException {
            return WorkerGroup.read(in);
        }
    };
    private static final Journal.AbstractJournalOp<ServiceTemplate> serviceTmplOp = new Journal.WritableJournalOp<ServiceTemplate>(){

        public ServiceTemplate parseFrom(DataInput in) throws IOException {
            return ServiceTemplate.read(in);
        }
    };
    private static final Journal.AbstractJournalOp<Service> serviceOp = new Journal.WritableJournalOp<Service>(){

        public Service parseFrom(DataInput in) throws IOException {
            return Service.read(in);
        }
    };
    private static final Journal.AbstractJournalOp<String> stringOp = new Journal.AbstractJournalOp<String>(){

        public void write(DataOutput out, String data) throws IOException {
            Text.writeBytes((DataOutput)out, (byte[])data.getBytes(StandardCharsets.UTF_8));
        }

        public String parseFrom(DataInput in) throws IOException {
            return new String(Text.readBytes((DataInput)in), StandardCharsets.UTF_8);
        }
    };
    private static final Journal.AbstractJournalOp<Long> longOp = new Journal.AbstractJournalOp<Long>(){

        public void write(DataOutput out, Long data) throws IOException {
            out.writeLong(data);
        }

        public Long parseFrom(DataInput in) throws IOException {
            return in.readLong();
        }
    };
    private static final Journal.AbstractListWritableJournalOp<Shard> shardListOp = new Journal.AbstractListWritableJournalOp<Shard>(){

        public Shard parseElement(DataInput in) throws IOException {
            return Shard.read(in);
        }
    };
    private static final Journal.AbstractListWritableJournalOp<ShardGroup> shardGroupListOp = new Journal.AbstractListWritableJournalOp<ShardGroup>(){

        public ShardGroup parseElement(DataInput in) throws IOException {
            return ShardGroup.read(in);
        }
    };
    private static final Journal.AbstractListWritableJournalOp<Worker> workerListOp = new Journal.AbstractListWritableJournalOp<Worker>(){

        public Worker parseElement(DataInput in) throws IOException {
            return Worker.read(in);
        }
    };
    private static final Journal.AbstractListJournalOp<Long> longListOp = new Journal.AbstractListJournalOp<Long>(){

        public void writeElement(DataOutput out, Long data) throws IOException {
            out.writeLong(data);
        }

        public Long parseElement(DataInput in) throws IOException {
            return in.readLong();
        }
    };
    private static final Journal.ProtoJournalOp<DeleteShardGroupInfo> deleteShardGroupsOp = new Journal.ProtoJournalOp<DeleteShardGroupInfo>(){

        public DeleteShardGroupInfo read(byte[] bytes) {
            try {
                return DeleteShardGroupInfo.parseFrom((byte[])bytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new StarException(ExceptionCode.JOURNAL, e.getMessage());
            }
        }
    };
    private static final Journal.ProtoJournalOp<MetaGroupJournalInfo> metaGroupOp = new Journal.ProtoJournalOp<MetaGroupJournalInfo>(){

        public MetaGroupJournalInfo read(byte[] bytes) {
            try {
                return MetaGroupJournalInfo.parseFrom((byte[])bytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new StarException(ExceptionCode.JOURNAL, e.getMessage());
            }
        }
    };
    private static final Journal.ProtoJournalOp<CreateShardJournalInfo> createShardOp = new Journal.ProtoJournalOp<CreateShardJournalInfo>(){

        public CreateShardJournalInfo read(byte[] bytes) {
            try {
                return CreateShardJournalInfo.parseFrom((byte[])bytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new StarException(ExceptionCode.JOURNAL, e.getMessage());
            }
        }
    };
    private static final Journal.ProtoJournalOp<DeleteWorkerGroupInfo> deleteWorkerGroupOp = new Journal.ProtoJournalOp<DeleteWorkerGroupInfo>(){

        public DeleteWorkerGroupInfo read(byte[] bytes) {
            try {
                return DeleteWorkerGroupInfo.parseFrom((byte[])bytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new StarException(ExceptionCode.JOURNAL, e.getMessage());
            }
        }
    };
    private static final Journal.ProtoJournalOp<UpdateWorkerGroupInfo> updateWorkerGroupOp = new Journal.ProtoJournalOp<UpdateWorkerGroupInfo>(){

        public UpdateWorkerGroupInfo read(byte[] bytes) {
            try {
                return UpdateWorkerGroupInfo.parseFrom((byte[])bytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new StarException(ExceptionCode.JOURNAL, e.getMessage());
            }
        }
    };
    private static final Journal.ProtoJournalOp<FileStoreInfo> fileStoreOp = new Journal.ProtoJournalOp<FileStoreInfo>(){

        public FileStoreInfo read(byte[] bytes) {
            try {
                return FileStoreInfo.parseFrom((byte[])bytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new StarException(ExceptionCode.JOURNAL, e.getMessage());
            }
        }
    };
    private static final Journal.ProtoJournalOp<LeaderInfo> leaderInfoOp = new Journal.ProtoJournalOp<LeaderInfo>(){

        public LeaderInfo read(byte[] bytes) {
            try {
                return LeaderInfo.parseFrom((byte[])bytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new StarException(ExceptionCode.JOURNAL, e.getMessage());
            }
        }
    };

    public static Journal logCreateShard(String serviceId, CreateShardJournalInfo info) throws StarException {
        return createShardOp.toJournal(OperationType.OP_CREATE_SHARD, serviceId, (Object)info);
    }

    public static Journal logDeleteShard(String serviceId, List<Long> shardIds) throws StarException {
        return longListOp.toJournal(OperationType.OP_DELETE_SHARD, serviceId, shardIds);
    }

    public static Journal logUpdateShard(String serviceId, List<Shard> shards) throws StarException {
        METRIC_LOG_UPDATE_SHARDS_NUM_COUNTER.inc((long)shards.size());
        METRIC_LOG_UPDATE_SHARDS_OPS_COUNTER.inc();
        return shardListOp.toJournal(OperationType.OP_UPDATE_SHARD, serviceId, shards);
    }

    public static Journal logCreateShardGroup(String serviceId, List<ShardGroup> shardGroups) throws StarException {
        return shardGroupListOp.toJournal(OperationType.OP_CREATE_SHARD_GROUP, serviceId, shardGroups);
    }

    public static Journal logDeleteShardGroup(String serviceId, DeleteShardGroupInfo deleteGroupInfo) throws StarException {
        return deleteShardGroupsOp.toJournal(OperationType.OP_DELETE_SHARD_GROUP, serviceId, (Object)deleteGroupInfo);
    }

    public static Journal logUpdateShardGroup(String serviceId, List<ShardGroup> groups) throws StarException {
        return shardGroupListOp.toJournal(OperationType.OP_UPDATE_SHARD_GROUP, serviceId, groups);
    }

    public static Journal logCreateMetaGroup(String serviceId, MetaGroupJournalInfo metaGroupJournalInfo) throws StarException {
        return metaGroupOp.toJournal(OperationType.OP_CREATE_META_GROUP, serviceId, (Object)metaGroupJournalInfo);
    }

    public static Journal logDeleteMetaGroup(String serviceId, MetaGroupJournalInfo metaGroupJournalInfo) throws StarException {
        return metaGroupOp.toJournal(OperationType.OP_DELETE_META_GROUP, serviceId, (Object)metaGroupJournalInfo);
    }

    public static Journal logUpdateMetaGroup(String serviceId, MetaGroupJournalInfo metaGroupJournalInfo) throws StarException {
        return metaGroupOp.toJournal(OperationType.OP_UPDATE_META_GROUP, serviceId, (Object)metaGroupJournalInfo);
    }

    public static Journal logCreateWorkerGroup(WorkerGroup group) throws StarException {
        return workerGroupOp.toJournal(OperationType.OP_CREATE_WORKER_GROUP, group.getServiceId(), (Object)group);
    }

    public static Journal logDeleteWorkerGroup(String serviceId, long groupId) {
        DeleteWorkerGroupInfo info = DeleteWorkerGroupInfo.newBuilder().setGroupId(groupId).build();
        return deleteWorkerGroupOp.toJournal(OperationType.OP_DELETE_WORKER_GROUP, serviceId, (Object)info);
    }

    public static Journal logUpdateWorkerGroup(String serviceId, UpdateWorkerGroupInfo info) {
        return updateWorkerGroupOp.toJournal(OperationType.OP_UPDATE_WORKER_GROUP, serviceId, (Object)info);
    }

    public static Journal logAddWorker(Worker worker) throws StarException {
        return workerOp.toJournal(OperationType.OP_ADD_WORKER, worker.getServiceId(), (Object)worker);
    }

    public static Journal logRemoveWorker(String serviceId, long groupId, long workerId) throws StarException {
        ArrayList<Long> todo = new ArrayList<Long>(2);
        todo.add(groupId);
        todo.add(workerId);
        return longListOp.toJournal(OperationType.OP_REMOVE_WORKER, serviceId, todo);
    }

    public static Journal logRegisterService(ServiceTemplate serviceTemplate) throws StarException {
        return serviceTmplOp.toJournal(OperationType.OP_REGISTER_SERVICE, "", (Object)serviceTemplate);
    }

    public static Journal logDeregisterService(String serviceTemplateName) throws StarException {
        return stringOp.toJournal(OperationType.OP_DEREGISTER_SERVICE, "", (Object)serviceTemplateName);
    }

    public static Journal logBootstrapService(Service service) throws StarException {
        return serviceOp.toJournal(OperationType.OP_BOOTSTRAP_SERVICE, service.getServiceId(), (Object)service);
    }

    public static Journal logShutdownService(Service service) throws StarException {
        return serviceOp.toJournal(OperationType.OP_SHUTDOWN_SERVICE, service.getServiceId(), (Object)service);
    }

    public static Journal logUpdateWorker(String serviceId, List<Worker> workers) throws StarException {
        assert (!workers.isEmpty());
        return workerListOp.toJournal(OperationType.OP_UPDATE_WORKER, serviceId, workers);
    }

    public static Journal logSetId(long id) throws StarException {
        return longOp.toJournal(OperationType.OP_SET_ID, "", (Object)id);
    }

    public static Journal logLeaderInfo(LeaderInfo leader) throws StarException {
        return leaderInfoOp.toJournal(OperationType.OP_LEADER_CHANGE, "", (Object)leader);
    }

    public static Journal logAddFileStore(String serviceId, FileStoreInfo fs) throws StarException {
        return fileStoreOp.toJournal(OperationType.OP_ADD_FILESTORE, serviceId, (Object)fs);
    }

    public static Journal logUpdateFileStore(String serviceId, FileStoreInfo fs) throws StarException {
        return fileStoreOp.toJournal(OperationType.OP_UPDATE_FILESTORE, serviceId, (Object)fs);
    }

    public static Journal logReplaceFileStore(String serviceId, FileStoreInfo fs) throws StarException {
        return fileStoreOp.toJournal(OperationType.OP_REPLACE_FILESTORE, serviceId, (Object)fs);
    }

    public static Journal logRemoveFileStore(String serviceId, String fsKey) throws StarException {
        return stringOp.toJournal(OperationType.OP_REMOVE_FILESTORE, serviceId, (Object)fsKey);
    }

    public static CreateShardJournalInfo parseLogCreateShard(Journal journal) throws IOException {
        return (CreateShardJournalInfo)createShardOp.parseFromJournal(OperationType.OP_CREATE_SHARD, journal);
    }

    public static List<Long> parseLogDeleteShard(Journal journal) throws IOException {
        return (List)longListOp.parseFromJournal(OperationType.OP_DELETE_SHARD, journal);
    }

    public static List<Shard> parseLogUpdateShard(Journal journal) throws IOException {
        return (List)shardListOp.parseFromJournal(OperationType.OP_UPDATE_SHARD, journal);
    }

    public static List<ShardGroup> parseLogCreateShardGroup(Journal journal) throws IOException {
        return (List)shardGroupListOp.parseFromJournal(OperationType.OP_CREATE_SHARD_GROUP, journal);
    }

    public static DeleteShardGroupInfo parseLogDeleteShardGroup(Journal journal) throws IOException {
        return (DeleteShardGroupInfo)deleteShardGroupsOp.parseFromJournal(OperationType.OP_DELETE_SHARD_GROUP, journal);
    }

    public static List<ShardGroup> parseLogUpdateShardGroup(Journal journal) throws IOException {
        return (List)shardGroupListOp.parseFromJournal(OperationType.OP_UPDATE_SHARD_GROUP, journal);
    }

    public static MetaGroupJournalInfo parseLogCreateMetaGroup(Journal journal) throws IOException {
        return (MetaGroupJournalInfo)metaGroupOp.parseFromJournal(OperationType.OP_CREATE_META_GROUP, journal);
    }

    public static MetaGroupJournalInfo parseLogDeleteMetaGroup(Journal journal) throws IOException {
        return (MetaGroupJournalInfo)metaGroupOp.parseFromJournal(OperationType.OP_DELETE_META_GROUP, journal);
    }

    public static MetaGroupJournalInfo parseLogUpdateMetaGroup(Journal journal) throws IOException {
        return (MetaGroupJournalInfo)metaGroupOp.parseFromJournal(OperationType.OP_UPDATE_META_GROUP, journal);
    }

    public static WorkerGroup parseLogCreateWorkerGroup(Journal journal) throws StarException {
        return (WorkerGroup)workerGroupOp.parseFromJournal(OperationType.OP_CREATE_WORKER_GROUP, journal);
    }

    public static long parseLogDeleteWorkerGroup(Journal journal) {
        DeleteWorkerGroupInfo info = (DeleteWorkerGroupInfo)deleteWorkerGroupOp.parseFromJournal(OperationType.OP_DELETE_WORKER_GROUP, journal);
        return info.getGroupId();
    }

    public static UpdateWorkerGroupInfo parseLogUpdateWorkerGroup(Journal journal) {
        return (UpdateWorkerGroupInfo)updateWorkerGroupOp.parseFromJournal(OperationType.OP_UPDATE_WORKER_GROUP, journal);
    }

    public static Worker parseLogAddWorker(Journal journal) throws IOException {
        return (Worker)workerOp.parseFromJournal(OperationType.OP_ADD_WORKER, journal);
    }

    public static List<Worker> parseLogUpdateWorker(Journal journal) throws IOException {
        return (List)workerListOp.parseFromJournal(OperationType.OP_UPDATE_WORKER, journal);
    }

    public static Pair<Long, Long> parseLogRemoveWorker(Journal journal) throws IOException {
        List data = (List)longListOp.parseFromJournal(OperationType.OP_REMOVE_WORKER, journal);
        assert (data.size() == 2);
        long groupId = (Long)data.get(0);
        long workerId = (Long)data.get(1);
        return Pair.of((Object)groupId, (Object)workerId);
    }

    public static ServiceTemplate parseLogRegisterService(Journal journal) throws IOException {
        return (ServiceTemplate)serviceTmplOp.parseFromJournal(OperationType.OP_REGISTER_SERVICE, journal);
    }

    public static String parseLogDeregisterService(Journal journal) throws IOException {
        return (String)stringOp.parseFromJournal(OperationType.OP_DEREGISTER_SERVICE, journal);
    }

    public static Service parseLogBootstrapService(Journal journal) throws IOException {
        return (Service)serviceOp.parseFromJournal(OperationType.OP_BOOTSTRAP_SERVICE, journal);
    }

    public static Service parseLogShutdownService(Journal journal) throws IOException {
        return (Service)serviceOp.parseFromJournal(OperationType.OP_SHUTDOWN_SERVICE, journal);
    }

    public static long parseLogSetId(Journal journal) throws IOException {
        return (Long)longOp.parseFromJournal(OperationType.OP_SET_ID, journal);
    }

    public static LeaderInfo parseLogLeaderInfo(Journal journal) throws IOException {
        return (LeaderInfo)leaderInfoOp.parseFromJournal(OperationType.OP_LEADER_CHANGE, journal);
    }

    public static FileStoreInfo parseLogAddFileStore(Journal journal) throws IOException {
        return (FileStoreInfo)fileStoreOp.parseFromJournal(OperationType.OP_ADD_FILESTORE, journal);
    }

    public static FileStoreInfo parseLogUpdateFileStore(Journal journal) throws IOException {
        return (FileStoreInfo)fileStoreOp.parseFromJournal(OperationType.OP_UPDATE_FILESTORE, journal);
    }

    public static FileStoreInfo parseLogReplaceFileStore(Journal journal) throws IOException {
        return (FileStoreInfo)fileStoreOp.parseFromJournal(OperationType.OP_REPLACE_FILESTORE, journal);
    }

    public static String parseLogRemoveFileStore(Journal journal) throws IOException {
        return (String)stringOp.parseFromJournal(OperationType.OP_REMOVE_FILESTORE, journal);
    }
}

