/*
 * Decompiled with CFR 0.152.
 */
package com.staros.service;

import com.staros.filestore.FileStoreMgr;
import com.staros.proto.ServiceInfo;
import com.staros.proto.ServiceState;
import com.staros.shard.ShardManager;
import com.staros.util.Text;
import com.staros.util.Writable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Service
implements Writable {
    private final String serviceTemplateName;
    private final String serviceName;
    private final String serviceId;
    private ServiceState state;
    private ShardManager shardManager;
    private FileStoreMgr fileStoreMgr;

    public Service(String serviceTemplateName, String serviceName, String serviceId) {
        this.serviceTemplateName = serviceTemplateName;
        this.serviceName = serviceName;
        this.serviceId = serviceId;
        this.state = ServiceState.RUNNING;
        this.shardManager = null;
    }

    public String getServiceTemplateName() {
        return this.serviceTemplateName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public ServiceState getState() {
        return this.state;
    }

    public boolean setState(ServiceState state) {
        if (this.state == state) {
            return false;
        }
        this.state = state;
        return true;
    }

    public ShardManager getShardManager() {
        return this.shardManager;
    }

    public void setShardManager(ShardManager shardManager) {
        this.shardManager = shardManager;
    }

    public void setFileStoreMgr(FileStoreMgr fileStoreMgr) {
        this.fileStoreMgr = fileStoreMgr;
    }

    public FileStoreMgr getFileStoreMgr() {
        return this.fileStoreMgr;
    }

    public ServiceInfo toProtobuf() {
        ServiceInfo.Builder builder = ServiceInfo.newBuilder().setServiceTemplateName(this.serviceTemplateName).setServiceName(this.serviceName).setServiceId(this.serviceId).setServiceState(this.state);
        return builder.build();
    }

    public static Service fromProtobuf(ServiceInfo info) {
        String serviceTemplateName = info.getServiceTemplateName();
        String serviceName = info.getServiceName();
        String serviceId = info.getServiceId();
        ServiceState state = info.getServiceState();
        Service service = new Service(serviceTemplateName, serviceName, serviceId);
        service.setState(state);
        return service;
    }

    public void write(DataOutput out) throws IOException {
        byte[] bytes = this.toProtobuf().toByteArray();
        Text.writeBytes((DataOutput)out, (byte[])bytes);
    }

    public static Service read(DataInput in) throws IOException {
        byte[] bytes = Text.readBytes((DataInput)in);
        ServiceInfo info = ServiceInfo.parseFrom((byte[])bytes);
        return Service.fromProtobuf(info);
    }
}

