/*
 * Decompiled with CFR 0.152.
 */
package com.staros.shard;

import com.google.common.collect.ImmutableList;
import com.staros.proto.PlacementPolicy;
import com.staros.shard.policy.AbstractShardPlacementPolicy;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ShardPolicyFilter {
    protected static List<AbstractShardPlacementPolicy> policies = ImmutableList.of((Object)new ExcludeShardPlacementPolicy());

    public static void filter(Map<PlacementPolicy, Collection<Long>> constraints, Collection<Long> candidates) {
        policies.forEach(p -> p.filter((Collection)constraints.get(p.getPolicy()), candidates));
    }

    private static class ExcludeShardPlacementPolicy
    extends AbstractShardPlacementPolicy {
        public ExcludeShardPlacementPolicy() {
            super(PlacementPolicy.EXCLUDE);
        }

        @Override
        public void filter(Collection<Long> constraints, Collection<Long> candidates) {
            if (constraints == null || candidates == null) {
                return;
            }
            candidates.removeIf(constraints::contains);
        }
    }
}

