/*
 * Decompiled with CFR 0.152.
 */
package com.staros.filestore;

import com.staros.filestore.ADLS2FileStore;
import com.staros.filestore.AzBlobFileStore;
import com.staros.filestore.FileStore;
import com.staros.filestore.GSFileStore;
import com.staros.filestore.HDFSFileStore;
import com.staros.filestore.InvalidFileStore;
import com.staros.filestore.S3FileStore;
import com.staros.proto.FileStoreInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractFileStore
implements FileStore {
    protected String key;
    protected String name;
    protected List<String> locations = new ArrayList<String>();
    protected boolean enabled = true;
    protected String comment = "";
    private boolean builtin = false;
    protected long version = 0L;
    protected Map<String, String> properties = new HashMap<String, String>();
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public AbstractFileStore(String key, String name) {
        this.key = key;
        this.name = name;
    }

    public AbstractFileStore(FileStoreInfo fsInfo) {
        this.key = fsInfo.getFsKey();
        this.name = fsInfo.getFsName();
        this.enabled = fsInfo.getEnabled();
        this.comment = fsInfo.getComment();
        this.locations.addAll((Collection<String>)fsInfo.getLocationsList());
        this.version = fsInfo.getVersion();
        this.properties = fsInfo.getPropertiesMap();
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isBuiltin() {
        return this.builtin;
    }

    @Override
    public void setBuiltin(boolean builtin) {
        this.builtin = builtin;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public void increaseVersion() {
        ++this.version;
    }

    @Override
    public String rootPath() {
        assert (!this.locations.isEmpty());
        return this.locations.get(0);
    }

    private FileStoreInfo toProtobufInternal(boolean includeSecret) {
        return this.toProtobufBuilder().build();
    }

    @Override
    public FileStoreInfo toProtobuf() {
        return this.toProtobufInternal(true);
    }

    @Override
    public FileStoreInfo toDebugProtobuf() {
        return this.toProtobufInternal(false);
    }

    protected FileStoreInfo.Builder toProtobufBuilder() {
        return FileStoreInfo.newBuilder().setFsKey(this.key).setFsName(this.name).setEnabled(this.enabled).setComment(this.comment).addAllLocations(this.locations).setVersion(this.version).putAllProperties(this.properties);
    }

    @Override
    public void mergeFrom(FileStore other) {
        if (!other.getComment().isEmpty()) {
            this.comment = other.getComment();
        }
        this.enabled = other.getEnabled();
    }

    @Override
    public boolean isPartitionedPrefixEnabled() {
        return false;
    }

    @Override
    public int numOfPartitionedPrefix() {
        return 0;
    }

    @Override
    public Map<String, String> getPropertiesMap() {
        return this.properties;
    }

    public static FileStore fromProtobuf(FileStoreInfo fsInfo) {
        switch (fsInfo.getFsType()) {
            case S3: {
                return S3FileStore.fromProtobuf(fsInfo);
            }
            case HDFS: {
                return HDFSFileStore.fromProtobuf(fsInfo);
            }
            case AZBLOB: {
                return AzBlobFileStore.fromProtobuf(fsInfo);
            }
            case ADLS2: {
                return ADLS2FileStore.fromProtobuf(fsInfo);
            }
            case GS: {
                return GSFileStore.fromProtobuf(fsInfo);
            }
        }
        return InvalidFileStore.fromProtobuf(fsInfo);
    }
}

