/*
 * Decompiled with CFR 0.152.
 */
package com.staros.manager;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.staros.journal.DummyJournalSystem;
import com.staros.journal.JournalSystem;
import com.staros.manager.HttpService;
import com.staros.manager.StarManager;
import com.staros.manager.StarManagerService;
import com.staros.provisioner.StarProvisionServer;
import com.staros.util.Config;
import com.staros.util.LogConfig;
import com.staros.util.Utils;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StarManagerServer {
    private static final Logger LOG = LogManager.getLogger(StarManagerServer.class);
    private StarManager manager;
    private StarManagerService service;
    private HttpService httpService;
    private Server server;
    private AtomicBoolean started;
    private Executor executor;
    private ExecutorService executorService;

    public StarManagerServer() {
        this(new DummyJournalSystem());
    }

    public StarManagerServer(JournalSystem journalSystem) {
        this.manager = new StarManager(journalSystem);
        this.service = new StarManagerService(this.manager);
        this.httpService = new HttpService(this.manager);
        this.started = new AtomicBoolean(false);
    }

    public void start(int port) throws IOException {
        String localAddress = InetAddress.getLocalHost().getHostAddress();
        this.start(localAddress, port, null);
    }

    public void start(String address, int port, Executor executor) throws IOException {
        LOG.info("starting star manager ({}) on port {} ...", (Object)address, (Object)port);
        ServerBuilder builder = ServerBuilder.forPort((int)port);
        builder.addService((BindableService)this.service);
        if (Config.ENABLE_BUILTIN_RESOURCE_PROVISIONER_FOR_TEST) {
            StarProvisionServer provisionServer = new StarProvisionServer();
            StarProvisionServer.getServices(provisionServer).forEach(arg_0 -> ((ServerBuilder)builder).addService(arg_0));
        }
        builder.maxInboundMessageSize(Config.GRPC_CHANNEL_MAX_MESSAGE_SIZE);
        if (executor != null) {
            this.executor = executor;
        } else {
            LOG.info("create default executor for grpc server ...");
            this.executorService = this.createDefaultExecutor();
            this.executor = this.executorService;
        }
        builder.executor(this.executor);
        this.server = builder.build();
        this.server.start();
        this.started.set(true);
        this.manager.setListenAddressInfo(address, this.server.getPort());
        if (port == 0) {
            LOG.info("started star manager ({}) on port {} ...", (Object)address, (Object)this.server.getPort());
        }
    }

    public void shutdown() {
        LOG.info("star manager shutting down...");
        this.server.shutdown();
        this.getStarManager().stopBackgroundThreads();
        if (this.executorService != null) {
            Utils.shutdownExecutorService(this.executorService);
        }
    }

    public void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public int getServerPort() {
        return this.server.getPort();
    }

    public void blockUntilStart() {
        int times = 1;
        while (!this.started.get()) {
            if (times++ >= 100) {
                System.out.println("wait star manager server to start for 5 seconds, abort test!");
                System.exit(-1);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public StarManager getStarManager() {
        return this.manager;
    }

    public HttpService getHttpService() {
        return this.httpService;
    }

    private ExecutorService createDefaultExecutor() {
        String name = "starmgr-grpc-default-executor";
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("starmgr-grpc-default-executor-%d").build();
        return Executors.newCachedThreadPool(factory);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        String confFile = "./starmgr.conf";
        new Config().init(confFile);
        LogConfig.initLogging();
        StarManagerServer server = new StarManagerServer();
        server.getStarManager().becomeLeader();
        server.start(Config.STARMGR_RPC_PORT);
        server.blockUntilShutdown();
    }
}

