/*
 * Decompiled with CFR 0.152.
 */
package com.staros.provisioner;

import com.google.gson.Gson;
import com.staros.exception.AlreadyExistsStarException;
import com.staros.exception.NotExistStarException;
import com.staros.exception.ResourceExhaustedStarException;
import com.staros.proto.NodeInfo;
import com.staros.provisioner.StarProvisionManageService;
import com.staros.provisioner.StarProvisionService;
import com.staros.util.Config;
import com.staros.util.LockCloseable;
import io.grpc.BindableService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StarProvisionServer {
    private static final Logger LOG = LogManager.getLogger(StarProvisionServer.class);
    private List<Node> freeNodes = new ArrayList<Node>();
    private Map<String, List<Node>> assignedPools = new HashMap<String, List<Node>>();
    private final ReentrantLock lock = new ReentrantLock();
    private final String persistFile;

    public StarProvisionServer() {
        String dataFile = "";
        if (!Config.BUILTIN_PROVISION_SERVER_DATA_DIR.isEmpty()) {
            dataFile = String.format("%s/provisioner.dat", Config.BUILTIN_PROVISION_SERVER_DATA_DIR);
        }
        this.persistFile = dataFile;
        if (!this.persistFile.isEmpty()) {
            this.loadData();
        }
    }

    public static List<BindableService> getServices(StarProvisionServer server) {
        ArrayList<BindableService> services = new ArrayList<BindableService>();
        services.add((BindableService)new StarProvisionService(server));
        services.add((BindableService)new StarProvisionManageService(server));
        return services;
    }

    public void processAddNodeRequest(String host) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock);){
            if (this.freeNodes.stream().anyMatch(x -> x.getHost().equals(host))) {
                throw new AlreadyExistsStarException("Host:{} already exists!", new Object[]{host});
            }
            this.assignedPools.forEach((key, val) -> {
                if (val.stream().anyMatch(x -> x.getHost().equals(host))) {
                    throw new AlreadyExistsStarException("Host:{} already exists!", new Object[]{host});
                }
            });
            Node node = new Node(host);
            this.freeNodes.add(node);
            this.dumpData();
        }
    }

    public List<NodeInfo> processProvisionResourceRequest(String name, int numOfNodes) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock);){
            if (this.assignedPools.containsKey(name)) {
                throw new AlreadyExistsStarException("PoolName:{} already exists!", new Object[]{name});
            }
            if (this.freeNodes.size() < numOfNodes) {
                throw new ResourceExhaustedStarException("Not enough resource to meet requirement.");
            }
            ArrayList<Node> newPool = new ArrayList<Node>();
            for (int i = 0; i < numOfNodes; ++i) {
                newPool.add(this.freeNodes.get(i));
            }
            this.assignedPools.put(name, newPool);
            this.freeNodes.removeAll(newPool);
            this.dumpData();
            List<NodeInfo> list = newPool.stream().map(x -> NodeInfo.newBuilder().setHost(x.getHost()).build()).collect(Collectors.toList());
            return list;
        }
    }

    public List<NodeInfo> processGetResourceRequest(String name) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock);){
            if (!this.assignedPools.containsKey(name)) {
                throw new NotExistStarException("PoolName:{} not exist!", new Object[]{name});
            }
            List<NodeInfo> list = this.assignedPools.get(name).stream().map(x -> NodeInfo.newBuilder().setHost(x.getHost()).build()).collect(Collectors.toList());
            return list;
        }
    }

    public List<NodeInfo> processScaleResourceRequest(String name, int numOfNodes) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock);){
            int diff;
            if (!this.assignedPools.containsKey(name)) {
                throw new NotExistStarException("PoolName:{} not exist!", new Object[]{name});
            }
            List<Node> pool = this.assignedPools.get(name);
            if (pool.size() < numOfNodes) {
                diff = numOfNodes - pool.size();
                if (this.freeNodes.size() < diff) {
                    throw new ResourceExhaustedStarException("Not enough resource for scale pool:{}", new Object[]{name});
                }
                while (diff-- > 0) {
                    pool.add(this.freeNodes.remove(0));
                }
            } else if (pool.size() > numOfNodes) {
                diff = pool.size() - numOfNodes;
                while (diff-- > 0) {
                    this.freeNodes.add(pool.remove(pool.size() - 1));
                }
            }
            this.dumpData();
            List<NodeInfo> list = pool.stream().map(x -> NodeInfo.newBuilder().setHost(x.getHost()).build()).collect(Collectors.toList());
            return list;
        }
    }

    public void processDeleteResourceRequest(String name) {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock);){
            if (this.assignedPools.containsKey(name)) {
                this.freeNodes.addAll((Collection<Node>)this.assignedPools.get(name));
                this.assignedPools.remove(name);
                this.dumpData();
            }
        }
    }

    public void clear() {
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock);){
            this.assignedPools.clear();
            this.freeNodes.clear();
        }
    }

    public long getFreeNodeCount() {
        return this.freeNodes.size();
    }

    public long getAssignedPoolsSize() {
        return this.assignedPools.size();
    }

    private void dumpData() {
        if (this.persistFile.isEmpty()) {
            return;
        }
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock);){
            BufferedWriter writer = Files.newBufferedWriter(Paths.get(this.persistFile, new String[0]), new OpenOption[0]);
            String str = new Serializer(this.freeNodes, this.assignedPools).toGson();
            writer.write(str);
            ((Writer)writer).close();
        }
        catch (Exception exception) {
            LOG.warn("Fail to dump data to file:{}, {}", (Object)this.persistFile, (Object)exception.toString());
        }
    }

    private void loadData() {
        if (this.persistFile.isEmpty()) {
            LOG.info("persist file is empty. Skip load data");
            return;
        }
        try (LockCloseable ignored = new LockCloseable((Lock)this.lock);){
            Path path = Paths.get(this.persistFile, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                LOG.info("{} not exist, skip loading data", (Object)this.persistFile);
                return;
            }
            BufferedReader reader = Files.newBufferedReader(path);
            Serializer serializer = Serializer.fromGson(reader);
            ((Reader)reader).close();
            this.freeNodes.clear();
            this.assignedPools.clear();
            this.freeNodes.addAll(serializer.freeNodes);
            this.assignedPools.putAll(serializer.assignedPools);
        }
        catch (Exception exception) {
            LOG.warn("Excepted when load meta from persistent file:{}, {}", (Object)this.persistFile, (Object)exception.toString());
        }
    }

    private static class Serializer {
        private final List<Node> freeNodes;
        private final Map<String, List<Node>> assignedPools;

        public Serializer() {
            this.freeNodes = new ArrayList<Node>();
            this.assignedPools = new HashMap<String, List<Node>>();
        }

        public Serializer(List<Node> freeNodes, Map<String, List<Node>> assignedPools) {
            this.freeNodes = freeNodes;
            this.assignedPools = assignedPools;
        }

        public String toGson() {
            return new Gson().toJson((Object)this);
        }

        public static Serializer fromGson(Reader reader) {
            return (Serializer)new Gson().fromJson(reader, Serializer.class);
        }
    }

    private static class Node {
        private final String host;

        public Node(String host) {
            this.host = host;
        }

        public String getHost() {
            return this.host;
        }
    }
}

