/*
 * Decompiled with CFR 0.152.
 */
package com.staros.starlet;

import com.staros.proto.AddShardInfo;
import com.staros.proto.AddShardRequest;
import com.staros.proto.RemoveShardRequest;
import com.staros.proto.WorkerState;
import com.staros.starlet.StarletAgent;
import com.staros.worker.Worker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MockStarletAgent
extends StarletAgent {
    private static final Logger LOG = LogManager.getLogger(MockStarletAgent.class);
    private Worker worker = null;
    private Map<Long, AddShardInfo> shards = new HashMap<Long, AddShardInfo>();

    public synchronized int getShardCount() {
        return this.shards.size();
    }

    @Override
    public void setWorker(Worker w) {
        this.worker = w;
    }

    @Override
    public synchronized Pair<Boolean, Boolean> heartbeat() {
        this.worker.setState(WorkerState.ON);
        return Pair.of((Object)true, (Object)false);
    }

    @Override
    public synchronized void addShard(AddShardRequest request) {
        List infos = request.getShardInfoList();
        for (AddShardInfo info : infos) {
            this.shards.put(info.getShardId(), info.toBuilder().build());
        }
    }

    @Override
    public synchronized void removeShard(RemoveShardRequest request) {
        List shardIds = request.getShardIdsList();
        for (Long shardId : shardIds) {
            this.shards.remove(shardId);
        }
    }

    public Map<Long, AddShardInfo> getAllShards() {
        return this.shards;
    }
}

