/*
 * Decompiled with CFR 0.152.
 */
package com.staros.filestore;

import com.google.common.base.Preconditions;
import com.staros.credential.GSCredential;
import com.staros.filestore.AbstractFileStore;
import com.staros.filestore.FileStore;
import com.staros.proto.FileStoreInfo;
import com.staros.proto.FileStoreType;
import com.staros.proto.GSFileStoreInfo;
import com.staros.util.LockCloseable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class GSFileStore
extends AbstractFileStore {
    private String endpoint;
    private GSCredential credential;

    @Override
    public FileStoreType type() {
        return FileStoreType.GS;
    }

    @Override
    public boolean isValid() {
        assert (!this.locations.isEmpty());
        if (this.locations.isEmpty()) {
            return false;
        }
        String path = ((String)this.locations.get(0)).substring("gs://".length());
        return !path.isEmpty();
    }

    public GSFileStore(FileStoreInfo fsInfo, String endpoint, GSCredential credential) {
        super(fsInfo);
        this.endpoint = endpoint;
        this.credential = credential;
    }

    public GSFileStore(String key, String name, String endpoint, String path, GSCredential credential) {
        super(key, name);
        this.endpoint = endpoint;
        this.credential = credential;
        this.locations.add("gs://" + path);
    }

    private FileStoreInfo toProtobufInternal(boolean includeSecret) {
        try (LockCloseable lockCloseable = new LockCloseable((Lock)this.lock.readLock());){
            assert (!this.locations.isEmpty());
            GSFileStoreInfo.Builder gsBuilder = GSFileStoreInfo.newBuilder();
            gsBuilder.setEndpoint(this.endpoint);
            gsBuilder.setPath(((String)this.locations.get(0)).substring("gs://".length()));
            if (includeSecret) {
                gsBuilder.setUseComputeEngineServiceAccount(this.credential.isUseComputeEngineServiceAccount());
                gsBuilder.setServiceAccountEmail(this.credential.getServiceAccountEmail());
                gsBuilder.setServiceAccountPrivateKeyId(this.credential.getServiceAccountPrivateKeyId());
                gsBuilder.setServiceAccountPrivateKey(this.credential.getServiceAccountPrivateKey());
                gsBuilder.setImpersonation(this.credential.getImpersonation());
            } else {
                gsBuilder.setUseComputeEngineServiceAccount(true);
            }
            FileStoreInfo fileStoreInfo = this.toProtobufBuilder().setFsType(FileStoreType.GS).setGsFsInfo(gsBuilder).build();
            return fileStoreInfo;
        }
    }

    @Override
    public FileStoreInfo toProtobuf() {
        return this.toProtobufInternal(true);
    }

    @Override
    public FileStoreInfo toDebugProtobuf() {
        return this.toProtobufInternal(false);
    }

    @Override
    public void mergeFrom(FileStore fileStore) {
        Preconditions.checkArgument((boolean)(fileStore instanceof GSFileStore));
        super.mergeFrom(fileStore);
        GSFileStore otherStore = (GSFileStore)fileStore;
        if (!otherStore.endpoint.isEmpty()) {
            this.endpoint = otherStore.endpoint;
        }
        if (!otherStore.credential.isEmpty()) {
            this.credential = otherStore.credential;
        }
    }

    public static FileStore fromProtobuf(FileStoreInfo fsInfo) {
        GSFileStoreInfo gsInfo = fsInfo.getGsFsInfo();
        String endpoint = gsInfo.getEndpoint();
        String path = gsInfo.getPath();
        if (fsInfo.getLocationsList().isEmpty()) {
            List<String> locations = Arrays.asList("gs://" + path);
            fsInfo = fsInfo.toBuilder().addAllLocations(locations).build();
        }
        return new GSFileStore(fsInfo, endpoint, new GSCredential(gsInfo.getUseComputeEngineServiceAccount(), gsInfo.getServiceAccountEmail(), gsInfo.getServiceAccountPrivateKeyId(), gsInfo.getServiceAccountPrivateKey(), gsInfo.getImpersonation()));
    }
}

