/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.FileProtector;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.Feeder;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.stream.BaseProtocol;
import com.sleepycat.je.rep.stream.FeederFilter;
import com.sleepycat.je.rep.stream.FeederSyncupReader;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.subscription.StreamAuthenticator;
import com.sleepycat.je.rep.txn.ReadonlyTxn;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeederReplicaSyncup {
    private static final int MAX_INITIAL_REPLAY = 2400000;
    private static volatile int testMaxInitialReplay;
    private static volatile TestHook<Feeder> afterSyncupStartedHook;
    private static volatile TestHook<Feeder> afterSyncupEndedHook;
    private final Feeder feeder;
    private final RepNode repNode;
    private final NamedChannel namedChannel;
    private final Protocol protocol;
    private final VLSNIndex vlsnIndex;
    private final Logger logger;
    private FeederSyncupReader backwardsReader;

    public FeederReplicaSyncup(Feeder feeder, NamedChannel namedChannel, Protocol protocol) {
        this.feeder = feeder;
        this.repNode = feeder.getRepNode();
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.namedChannel = namedChannel;
        this.protocol = protocol;
        this.vlsnIndex = this.repNode.getVLSNIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws DatabaseException, IOException, InterruptedException, NetworkRestoreException, ChecksumException {
        long startTime = System.currentTimeMillis();
        RepImpl repImpl = this.repNode.getRepImpl();
        LoggerUtils.info(this.logger, repImpl, "Feeder-replica " + this.feeder.getReplicaNameIdPair().getName() + " syncup started. Feeder range: " + this.repNode.getVLSNIndex().getRange());
        FileProtector.ProtectedFileSet protectedFileSet = this.repNode.syncupStarted(this.feeder.getReplicaNameIdPair());
        try {
            VLSN startVLSN;
            block16: {
                BinaryProtocol.Message message;
                assert (TestHookExecute.doHookIfSet(afterSyncupStartedHook, this.feeder));
                VLSNRange range = this.vlsnIndex.getRange();
                BaseProtocol.EntryRequest firstRequest = (BaseProtocol.EntryRequest)this.protocol.read(this.namedChannel);
                BinaryProtocol.Message response = this.makeResponseToEntryRequest(range, firstRequest, true);
                this.protocol.write(response, this.namedChannel);
                while (true) {
                    message = this.protocol.read(this.namedChannel);
                    if (this.logger.isLoggable(Level.FINEST)) {
                        LoggerUtils.finest(this.logger, repImpl, "Replica " + this.feeder.getReplicaNameIdPair() + " message op: " + message.getOp());
                    }
                    if (message instanceof BaseProtocol.StartStream) {
                        BaseProtocol.StartStream startMessage = (BaseProtocol.StartStream)message;
                        startVLSN = startMessage.getVLSN();
                        FeederFilter filter = startMessage.getFeederFilter();
                        if (filter != null) {
                            filter.setLogger(this.logger);
                        }
                        this.feeder.setFeederFilter(filter);
                        if (this.feeder.needSecurityChecks()) {
                            StreamAuthenticator auth = this.feeder.getAuthenticator();
                            assert (auth != null);
                            if (filter != null) {
                                auth.setTableIds(filter.getTableIds());
                            } else {
                                auth.setTableIds(null);
                            }
                            if (!auth.checkAccess()) {
                                String err = "Replica " + this.feeder.getReplicaNameIdPair().getName() + " fails security check in start stream syncup";
                                LoggerUtils.warning(this.logger, repImpl, err);
                                this.feeder.makeSecurityCheckResponse(err);
                            }
                        }
                        break block16;
                    }
                    if (message instanceof BaseProtocol.EntryRequest) {
                        response = this.makeResponseToEntryRequest(range, (BaseProtocol.EntryRequest)message, false);
                        this.protocol.write(response, this.namedChannel);
                        continue;
                    }
                    if (message instanceof BaseProtocol.RestoreRequest) {
                        throw this.answerRestore(range, ((BaseProtocol.RestoreRequest)message).getVLSN());
                    }
                    if (!(message instanceof Protocol.DBIdRequest)) break;
                    String dbName = ((Protocol.DBIdRequest)message).getDbName();
                    response = this.makeResponseToDBIdRequest(this.repNode, dbName);
                    this.protocol.write(response, this.namedChannel);
                }
                throw EnvironmentFailureException.unexpectedState(repImpl, "Expected StartStream or EntryRequest but got " + message);
            }
            LoggerUtils.info(this.logger, repImpl, "Feeder-replica " + this.feeder.getReplicaNameIdPair().getName() + " start stream at VLSN: " + startVLSN);
            this.feeder.initMasterFeederSource(startVLSN);
            this.repNode.syncupEnded(protectedFileSet);
        }
        catch (Throwable throwable) {
            this.repNode.syncupEnded(protectedFileSet);
            assert (TestHookExecute.doHookIfSet(afterSyncupEndedHook, this.feeder));
            LoggerUtils.info(this.logger, repImpl, String.format("Feeder-replica " + this.feeder.getReplicaNameIdPair().getName() + " syncup ended. Elapsed time: %,dms", System.currentTimeMillis() - startTime));
            throw throwable;
        }
        assert (TestHookExecute.doHookIfSet(afterSyncupEndedHook, this.feeder));
        LoggerUtils.info(this.logger, repImpl, String.format("Feeder-replica " + this.feeder.getReplicaNameIdPair().getName() + " syncup ended. Elapsed time: %,dms", System.currentTimeMillis() - startTime));
    }

    private static int getMaxInitialReplay() {
        return testMaxInitialReplay != 0 ? testMaxInitialReplay : 2400000;
    }

    public static void setTestMaxInitialReplay(int val) {
        testMaxInitialReplay = val;
    }

    public static void setAfterSyncupStartedHook(TestHook<Feeder> hook) {
        afterSyncupStartedHook = hook;
    }

    public static void setAfterSyncupEndedHook(TestHook<Feeder> hook) {
        afterSyncupEndedHook = hook;
    }

    private FeederSyncupReader setupReader(VLSN startVLSN) throws DatabaseException, IOException {
        RepImpl envImpl = this.repNode.getRepImpl();
        int readBufferSize = envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        long lastUsedLsn = envImpl.getFileManager().getLastUsedLsn();
        VLSN firstVLSN = this.vlsnIndex.getRange().getFirst();
        long firstFile = this.vlsnIndex.getLTEFileNumber(firstVLSN);
        long finishLsn = DbLsn.makeLsn(firstFile, 0);
        return new FeederSyncupReader((EnvironmentImpl)envImpl, this.vlsnIndex, lastUsedLsn, readBufferSize, startVLSN, finishLsn);
    }

    private BinaryProtocol.Message makeResponseToDBIdRequest(RepNode rn, String dbName) {
        DatabaseId dbId = FeederReplicaSyncup.getDBId(rn.getRepImpl(), dbName);
        Protocol protocol = this.protocol;
        protocol.getClass();
        return protocol.new Protocol.DBIdResponse(dbId);
    }

    public static DatabaseId getDBId(RepImpl repImpl, String dbName) throws DatabaseNotFoundException {
        DatabaseId dbId;
        DbTree dbTree = repImpl.getDbTree();
        TransactionConfig txnConfig = new TransactionConfig();
        ReadonlyTxn txn = new ReadonlyTxn(repImpl, txnConfig);
        try {
            dbId = dbTree.getDbIdFromName(txn, dbName, null, false);
            txn.commit();
        }
        catch (Exception exp) {
            txn.abort();
            throw exp;
        }
        if (dbId == null) {
            throw new DatabaseNotFoundException("Cannot find db id for JE database " + dbName);
        }
        return dbId;
    }

    private BinaryProtocol.Message makeResponseToEntryRequest(VLSNRange range, BaseProtocol.EntryRequest request, boolean isFirstResponse) throws IOException, ChecksumException {
        VLSN requestMatchpoint = request.getVLSN();
        BaseProtocol.EntryRequestType type = request.getType();
        if (type.equals((Object)BaseProtocol.EntryRequestType.NOW)) {
            Protocol protocol = this.protocol;
            protocol.getClass();
            return (BaseProtocol)protocol.new BaseProtocol.Entry(this.getMatchPtRecord(range.getLast()));
        }
        if (range.getFirst().compareTo(requestMatchpoint) > 0) {
            if (type.equals((Object)BaseProtocol.EntryRequestType.AVAILABLE)) {
                Protocol protocol = this.protocol;
                protocol.getClass();
                return (BaseProtocol)protocol.new BaseProtocol.Entry(this.getMatchPtRecord(range.getFirst()));
            }
            return this.protocol.new BaseProtocol.EntryNotFound();
        }
        if (range.getLast().compareTo(requestMatchpoint) < 0) {
            if (type.equals((Object)BaseProtocol.EntryRequestType.AVAILABLE)) {
                Protocol protocol = this.protocol;
                protocol.getClass();
                return (BaseProtocol)protocol.new BaseProtocol.Entry(this.getMatchPtRecord(range.getLast()));
            }
            assert (this.backwardsReader == null) : "Replica request for vlsn > feeder range should only happen on the first exchange.";
            if (range.getLastSync().equals(VLSN.NULL_VLSN)) {
                return this.protocol.new BaseProtocol.EntryNotFound();
            }
            if (isFirstResponse) {
                OutputWireRecord lastSync = this.getMatchPtRecord(range.getLastSync());
                assert (lastSync != null) : "Look for alternative, range=" + range;
                Protocol protocol = this.protocol;
                protocol.getClass();
                return (BaseProtocol)protocol.new BaseProtocol.AlternateMatchpoint(lastSync);
            }
            throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "RequestMatchpoint=" + requestMatchpoint + " range=" + range + "should only happen on first response");
        }
        if (requestMatchpoint.equals(VLSN.FIRST_VLSN) && range.getLast().getSequence() > (long)FeederReplicaSyncup.getMaxInitialReplay()) {
            return this.protocol.new BaseProtocol.EntryNotFound();
        }
        OutputWireRecord matchRecord = this.getMatchPtRecord(requestMatchpoint);
        if (matchRecord == null) {
            throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "Couldn't find matchpoint " + requestMatchpoint + " in log. VLSN range=" + range);
        }
        Protocol protocol = this.protocol;
        protocol.getClass();
        return (BaseProtocol)protocol.new BaseProtocol.Entry(matchRecord);
    }

    private OutputWireRecord getMatchPtRecord(VLSN matchPointVLSN) throws IOException, ChecksumException {
        if (this.backwardsReader == null) {
            this.backwardsReader = this.setupReader(matchPointVLSN);
        }
        return this.backwardsReader.scanBackwards(matchPointVLSN);
    }

    private NetworkRestoreException answerRestore(VLSNRange range, VLSN failedMatchpoint) throws IOException {
        Protocol protocol = this.protocol;
        protocol.getClass();
        BaseProtocol.RestoreResponse response = protocol.new BaseProtocol.RestoreResponse(this.repNode.getRestoreResponseVLSN(range), this.repNode.getLogProviders());
        this.protocol.write((BinaryProtocol.Message)response, this.namedChannel);
        return new NetworkRestoreException(failedMatchpoint, range.getFirst(), range.getLast(), this.feeder.getReplicaNameIdPair());
    }

    public static class NetworkRestoreException
    extends Exception {
        private final VLSN vlsn;
        private final VLSN firstVLSN;
        private final VLSN lastVLSN;
        private final NameIdPair replicaNameIdPair;

        public NetworkRestoreException(VLSN vlsn, VLSN firstVLSN, VLSN lastVLSN, NameIdPair replicaNameIdPair) {
            this.vlsn = vlsn;
            this.firstVLSN = firstVLSN;
            this.lastVLSN = lastVLSN;
            this.replicaNameIdPair = replicaNameIdPair;
        }

        @Override
        public String getMessage() {
            return "Matchpoint vlsn " + this.vlsn + " requested by node: " + this.replicaNameIdPair + " was outside the VLSN range: [" + this.firstVLSN + "-" + this.lastVLSN + "]";
        }

        public VLSN getVlsn() {
            return this.vlsn;
        }

        public NameIdPair getReplicaNameIdPair() {
            return this.replicaNameIdPair;
        }
    }
}

